<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>商城订单管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/shop/shopOrder/">订单管理</a></li>
		<shiro:hasPermission name="shop:shopOrder:add"><li><a href="${ctx}/shop/shopOrder/form">订单添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="shopOrder" action="${ctx}/shop/shopOrder/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>会员名称：</label>
				<form:input path="memberName" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>订单类型：</label>
				<form:select path="type" class="input-medium">
					<form:option value="" label="全部"></form:option>
					<form:options items="${fns:getDictList('channel_type')}" itemLabel="label" itemValue="value" htmlEscape="false"></form:options>
				</form:select>
			</li>
			<li><label>订单编号：</label>
				<form:input path="shopOrderCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>订单总量：</label>
				<form:input path="num" htmlEscape="false"  maxlength="64" class="input-medium"/>
			</li>
			<li><label>订单总价：</label>
				<form:input path="price" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>收货人：</label>
				<form:input path="postName" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>录入时间：</label>
				<input name="beginOrderDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${shopOrder.beginOrderDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>-
				<input name="endOrderDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${shopOrder.endOrderDate}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});"/>
			</li>
			<li><label>是否发货：</label>
				<form:select path="isSend" class="input-medium">
					<form:option value="" label="全部"></form:option>
					<form:options items="${fns:getDictList('yes_no')}" itemLabel="label" itemValue="value" htmlEscape="false"></form:options>
				</form:select>
			</li>
			<li><label>支付状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"></form:option>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"></form:options>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>订单编号</th>
				<th>订单类型</th>
				<th>会员编号</th>
				<th>会员名称</th>
				<th>购买商品</th>
				<th>订单总量</th>
				<th>订单总价</th>
				<th>销售渠道</th>
				<th>录入时间</th>
				<th>收货人</th>
				<th>支付状态</th>
				<th>发货状态</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="shopOrder" varStatus="status">
			<tr>

				<td><a href="${ctx}/shop/shopOrder/view?id=${shopOrder.id}">
						${fns:escapeHtml(shopOrder.shopOrderCode)}
				</a></td>
				<td>
					${fns:getDictLabel(shopOrder.type, 'channel_type', '')}
				</td>
				<td>
						${fns:escapeHtml(shopOrder.memberCode)}
				</td>
				<td>
						${fns:escapeHtml(shopOrder.memberName)}
				</td>
				<td>
					<c:if test="${shopOrder.orderDetailList!=null || fn:length(shopOrder.orderDetailList)>0}">
							<table id="goods${goods.id}" class="table table-striped table-bordered table-condensed">
								<thead>
									<tr>
										<td>名称</td><td>单价</td><td>数量</td><td>备注</td><td>邮费</td><td>总价</td>
									</tr>
								</thead>
								<tbody>
								<c:forEach items="${shopOrder.orderDetailList}" var="orderDetail">
									<tr>
										<td>${fns:escapeHtml(orderDetail.goodsName)}</td><td>${fns:escapeHtml(orderDetail.goodsPrice)}</td><td>${fns:escapeHtml(orderDetail.goodsNum)}</td><td>${orderDetail.isBuyGifts=='0'?'':'赠品'}</td><td>${fns:escapeHtml(orderDetail.postPrice)}</td><td>${fns:escapeHtml(orderDetail.totalPrice)}</td>
									</tr>
								</c:forEach>
									<tr>
										<td>合计</td><td><div style="border-top:1px solid #000;width:30px;height:1px;"> </div></td><td>${shopOrder.num}</td><td><div style="border-top:1px solid #000;width:30px;height:1px;"> </div></td><td>${fns:escapeHtml(shopOrder.postPrice)}</td><td>${fns:escapeHtml(shopOrder.price)}</td>
									</tr>
								</tbody>
							</table>
					</c:if>
				</td>
				<td>
						${fns:escapeHtml(shopOrder.num)}
				</td>
				<td>
						${fns:escapeHtml(shopOrder.price)}
				</td>
				<td>
						${fns:getDictLabel(shopOrder.channelType, 'channel_type','' )}-${shopOrder.channelName}
				</td>
				<td>
					<fmt:formatDate value="${shopOrder.orderDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${fns:escapeHtml(shopOrder.postName)}
				</td>
				<td>
						${fns:getDictLabel(shopOrder.paymentState, 'user_payment_state', '')}
				</td>
				<td>
					<shiro:hasPermission name="shop:shopOrder:send">

						<c:if test="${shopOrder.isSend=='0'}">
							<c:choose>
								<c:when test="${shopOrder.paymentState=='2'}">
									<a onclick="sendOrder('${shopOrder.id}')" class="text-danger">未发货</a>
								</c:when>
								<c:otherwise>
									<a class="text-danger">未发货</a>
								</c:otherwise>
							</c:choose>
						</c:if>
						<c:if test="${shopOrder.isSend=='1'}">
							<p style="color: red;">已发货</p>
						</c:if>
					</shiro:hasPermission>
				</td>
				<td>
					<shiro:hasPermission name="shop:shopOrder:delete">
					<c:if test="${shopOrder.isSend=='0'}">
						<a href="${ctx}/shop/shopOrder/delOrder?id=${shopOrder.id}"  onclick="return confirmx('确认要撤销此订单吗？', this.href)" class="text-danger">撤销</a>
					</c:if>
					</shiro:hasPermission>
					<shiro:hasPermission name="shop:shopOrder:returnGoods">
					<c:if test="${shopOrder.isSend=='1'}">
						<c:if test="${shopOrder.isReturn=='0'}">
							<a onclick="returnGoods('${shopOrder.id}')" class="text-danger">退回</a>
						</c:if>
						<c:if test="${shopOrder.isReturn=='1'}">
							<p style="color: red;">已退回</p>
						</c:if>
					</c:if>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
	<script>
		function returnGoods(id){
			parent.layer.open({
				type: 2,
				title: ['商品退回管理', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '400px'],
				content: ctx+"/shop/shopOrder/toReturnGoods?id="+id,
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						if(mainF.contents().find("#searchForm").length != 0){
							mainF.contents().find("#searchForm").submit();
						}else{
							parent.document.getElementById("mainFrame").contentWindow.location.reload();
						}
					};
				}
			});
		};
		function sendOrder(id){
			//收货地址 邮寄方式 物流单号
			parent.layer.open({
				type: 2,
				title: ['发货信息管理', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '280px'],
				content: ctx+"/shop/shopOrder/toSendOrder?id="+id,
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						if(mainF.contents().find("#searchForm").length != 0){
							mainF.contents().find("#searchForm").submit();
						}else{
							parent.document.getElementById("mainFrame").contentWindow.location.reload();
						}
					};
				}
			});
		}
	</script>
</body>
</html>