<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>合作机构采样包发放</title>
	<meta name="decorator" content="default"/>
	<script src="${ctxStatic}/jquery-validation/1.11.0/lib/jquery.form.js" type="text/javascript"></script>
	<script src="${ctxStatic}/xmSelect/xm-select.js" type="text/javascript"></script>
	<script type="text/javascript">
		$(document).ready(function() {
			var samplingList = [];
			<c:forEach items="${samplingList}" var="item">
				var temp = {};
				temp.id = "${item.id}";
				temp.samplingCode = "${item.samplingCode}";
				samplingList.push(temp);
			</c:forEach>

			//保存事件
			$("#btnSubmit").click(function () {
				$("#inputForm").ajaxSubmit({
					dataType: 'json',
					beforeSubmit: function () {
						if (!$("#inputForm").valid() || $(".error:visible").length > 0) {
							return false;
						} else {
							return true;
						}
					},
					success: function (data) {
						if (data.rc == 0) {
							layer.msg(data.data);
							window.location = "${ctx}/sys/org/"
						} else {
							layer.msg(data.msg);
						}
					},
					error: function (err) {
						layer.msg("操作失败!");
					}
				});
			});

			//初始化select
			xmSelect.render({
				el: '#samplingCodeSelect',
				checkbox: true,
				repeat: false,
				autoRow: true,
				filterable: true,
				prop: {name: 'samplingCode', value: 'id'},
				height: '165px',
				tips: '请选择',
				toolbar: {
					show: true,
				},
				tree: {
					show: true,
					showFolderIcon: true,
					showLine: true,
					indent: 20,
					expandedKeys: [-3],
					strict: false,
				},
				data: function () {
					return samplingList;
				},
				on: function (data) {
					let valStr = "";
					$.each(data.arr, function (index, item) {
						valStr += item.samplingCode;
						if (index != data.arr.length - 1) {
							valStr += ',';
						}
					});
					$("#samplingCode").val(valStr);
				},
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/sys/org/">合作机构列表</a></li>
		<li class="active"><a href="${ctx}/org/orgSampling/addForm?orgId=${orgSampling.orgId}">合作机构采样包发放</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="orgSampling" action="${ctx}/org/orgSampling/add" method="post" class="form-horizontal">
		<form:hidden path="orgId"/>
		<form:hidden path="samplingCode"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">合作机构名称：</label>
			<div class="controls">
					${fns:escapeHtml(org.name)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">合作机构编号：</label>
			<div class="controls">
					${fns:escapeHtml(org.memberCode)}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">发放时间：</label>
			<div class="controls">
				<input name="postDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					   value="<fmt:formatDate value="${orgSampling.postDate}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">地址：</label>
			<div class="controls">
				<form:input path="address" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">采样包编号：</label>
			<div class="controls" style="overflow: visible">
				<div id="samplingCodeSelect" class="xm-select-demo" style="width: 500px;"></div>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="org:orgSampling:add"><input id="btnSubmit" class="btn btn-primary" type="button" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>