<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>美容师审查员管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/groomer/groomerShowReferee/">美容师审查员列表</a></li>
		<shiro:hasPermission name="groomer:groomerShowReferee:add"><li><a href="${ctx}/groomer/groomerShowReferee/form">美容师审查员添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="groomerShowReferee" action="${ctx}/groomer/groomerShowReferee/list" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>审查员中/英文名：</label>
				<form:input path="judgeName" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>审查员国籍：</label>
				<form:input path="refereeCitizenship" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>审查员姓名</th>
				<th>审查员国籍</th>
				<th>审查员性别</th>
				<th>备注信息</th>
				<shiro:hasPermission name="groomer:groomerShowReferee:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="groomerShowReferee">
			<tr>
				<td><%--<a href="${ctx}/judge/showJudge/form?id=${groomerShowReferee.id}">--%>
					${groomerShowReferee.judgeName}
				<%--</a>--%></td>
				<td>
					${groomerShowReferee.refereeCitizenship}
				</td>
				<td>
					${fns:getDictLabel(groomerShowReferee.refereeSex, 'sex', '')}
				</td>
				<td>
					${groomerShowReferee.remarks}
				</td>
				<td>
				<shiro:hasPermission name="groomer:groomerShowReferee:view">
					<a href="${ctx}/groomer/groomerShowReferee/view?id=${groomerShowReferee.id}">查看</a>
					</shiro:hasPermission>
				<shiro:hasPermission name="groomer:groomerShowReferee:edit">
    				<a href="${ctx}/groomer/groomerShowReferee/form?id=${groomerShowReferee.id}">修改</a>
				</shiro:hasPermission>
				<shiro:hasPermission name="groomer:groomerShowReferee:delete">
					<a href="${ctx}/groomer/groomerShowReferee/delete?id=${groomerShowReferee.id}" onclick="return confirmx('确认要删除该赛事审查员吗？', this.href)">删除</a>
				</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>