<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>订单管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#name").focus();

			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					save();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				},

			});
		});
		function save(){
			var frm = $("#inputForm");
			var dataPara = util.getFormJson(frm);
			$.ajax({
				url: '${ctx}/finance/paymentOrderProject/addOrderProjectRestful',
				type: 'POST',
				data: dataPara,
				success: function(json){
					parent.isYes = true;
					parent.layer.closeAll();
				}
			});

		}
		function closeLayer(){
			parent.isYes = false;
			parent.layer.closeAll();
		};
	</script>
</head>
<body>
	<div  id="addFormContent">
		<div class="panel panel-default" id="addForm">
			<div class="panel-body">
				<form:form id="inputForm" modelAttribute="paymentOrderProject" action="${ctx}/finance/paymentOrderProject/addOrderProjectRestful" method="post" class="form-horizontal">
					<div class="control-group">
						<label class="control-label">项目名称：</label>
						<div class="controls">
							<input name="name" htmlEscape="false" maxlength="200" class="input-medium" required title="项目名称不能为空！"/>
						</div>
					</div>
					<div class="control-group">
						<label class="control-label">添加时间：</label>
						<div class="controls">
							<input name="startDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
								   value="<fmt:formatDate value="${member.birthday}" pattern="yyyy-MM-dd"/>"
								   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});" required title="添加时间不能为空！"/>
						</div>
					</div>
					<div class="control-group">
						<label class="control-label">活动地点：</label>
						<div class="controls">
							<input name="address" htmlEscape="false" maxlength="200" class="input-medium" required title="活动地点不能为空！"/>
						</div>
					</div>
					<div class="form-actions">
						<shiro:hasPermission name="finance:paymentOrderProject:add">
							<input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存" />&nbsp;
						</shiro:hasPermission>
						<input id="btnCancel" class="btn" type="button" value="关 闭" onclick="closeLayer()"/>
					</div>
				</form:form>
			</div>
		</div>
	</div>
</body>
</html>