<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>OA订单录入组合收费项管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/finance/paymentChargingItemGroup/">OA订单录入组合收费项列表</a></li>
		<shiro:hasPermission name="finance:paymentChargingItemGroup:edit"><li><a href="${ctx}/finance/paymentChargingItemGroup/form">OA订单录入组合收费项添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="paymentChargingItemGroup" action="${ctx}/finance/paymentChargingItemGroup/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>名称：</label>
				<form:input path="name" htmlEscape="false" maxlength="60" class="input-medium"/>
			</li>
			<li><label>备注：</label>
				<form:input path="remarks" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>名称</th>
				<th>金额</th>
				<th>收费项数量</th>
				<th>更新时间</th>
				<th>备注</th>
				<shiro:hasPermission name="finance:paymentChargingItemGroup:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="paymentChargingItemGroup">
			<tr>
				<td><a href="${ctx}/finance/paymentChargingItemGroup/form?id=${paymentChargingItemGroup.id}">
					${paymentChargingItemGroup.name}
				</a></td>
				<td>
					${paymentChargingItemGroup.price}
				</td>
				<td>
					${paymentChargingItemGroup.num}
				</td>
				<td>
					<fmt:formatDate value="${paymentChargingItemGroup.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${paymentChargingItemGroup.remarks}
				</td>
				<shiro:hasPermission name="finance:paymentChargingItemGroup:edit"><td>
    				<a href="${ctx}/finance/paymentChargingItemGroup/form?id=${paymentChargingItemGroup.id}">修改</a>
					<a href="${ctx}/finance/paymentChargingItemGroup/delete?id=${paymentChargingItemGroup.id}" onclick="return confirmx('确认要删除该OA订单录入组合收费项吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>