<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>会员账户充值</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
						if(confirm("是否确认提交？")){
							 loading('正在提交，请稍等...');
							 form.submit(); 
						 }
					
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			$("#paymentShow span:first-child").remove();
			$("#paymentWay2").attr("checked","true");
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/finance/memberAccount/">会员账户资金收支明细</a></li>
		<li class="active"><a href="${ctx}/finance/memberAccount/form?id=${memberAccount.id}">会员账户充值</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="memberAccount" action="${ctx}/finance/memberAccount/rechargeAccount" method="post" class="form-horizontal">
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<input name="memberCode" id="memberCode" readonly="readonly"  type="text" htmlEscape="false" maxlength="100" class="form-control" required title="会员号不能为空！"/>
                <span class="input-group-btn">
                <button class="btn btn-default" type="button" id="memberCodeBtn" onclick="searchUser()">查</button>
                <font id="paymentState" ></font>
                </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓 名：</label>
			<div class="controls">
				<input type="text" readonly="readonly" id="name"  htmlEscape="false" maxlength="100" class="form-control" required title="会员名称不能为空！"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">手机号：</label>
			<div class="controls">
				<input id="mobile" type="text" htmlEscape="false" maxlength="100"  class="form-control" readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<input name="gender" maxlength="50" class="input-xlarge" type="radio" value="male" disabled="disabled"/>
				<label>男</label>
				<input name="gender" maxlength="50" class="input-xlarge" type="radio" value="female" disabled="disabled"/>
				<label>女</label>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">余额：</label>
			<div class="controls">
				<input type="text" readonly="readonly" id="accountBalance"   class="form-control" >
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">缴费金额：</label>
			<div class="controls">
				<input type="number"  name="paymentAmount" min="0" step="0.01" class="form-control" required >
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">缴费方式：</label>
			<div class="controls" id="paymentShow">
				<form:radiobuttons path="paymentWay" items="${fns:getDictList('payment_way')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required" title="缴费方式不能为空！"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">缴费时间：</label>
			<div class="controls">
				<input name="paymentTime" type="text" readonly="readonly" maxlength="20" class="form-control Wdate "
					   value="<fmt:formatDate value="${today}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});" required title="缴费时间不能为空！"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">支付宝订单号：</label>
			<div class="controls">
				<input type="text" name="outTradeNo" class="form-control">
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注说明：</label>
			<div class="controls">
				<textarea name="paymentRemarks" class="form-control"></textarea>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="finance:memberAccount:recharge"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
	<script>
		//打开查询用户的弹窗
		function searchUser(){
			top.layer.open({
				type: 2,
				title: ['会员查询', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['700px', '500px'],
				content: "${ctx}/sys/user/member/search"
			});
		}

		//查询用户完成的回调方法
		this.searchUserCallback = function (json){
			$("#name").val(json.name);
			$("#memberCode").val(json.memberCode);
			if(json.paymentState=='1'){
				$("#paymentState").text('无效');
			}else if(json.paymentState=='2'){
				$("#paymentState").text('有效');
				$("#paymentState").css("color","red");
			};
			$("#mobile").val(json.mobile);
			$("#accountBalance").val(json.accountBalance);
			$("input[type=radio][name='gender'][value="+json.gender+"]").attr("checked",'checked');
		}
	</script>
</body>
</html>