<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>犬只贴纸管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/dog/dogSticker/">犬只贴纸列表</a></li>
    <shiro:hasPermission name="dog:dogSticker:edit">
        <li><a href="${ctx}/dog/dogSticker/form">犬只贴纸添加</a></li>
    </shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="dogSticker" action="${ctx}/dog/dogSticker/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>芯片号：</label>
            <form:input path="identificationFlag" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>贴纸号码：</label>
            <form:input path="stickerNo" htmlEscape="false" maxlength="20" class="input-medium"/>
        </li>
        <li><label>贴纸等级:1优宠级;2纯种级;3参赛级;4冠军级：</label>
            <form:input path="stickerClass" htmlEscape="false" maxlength="1" class="input-medium"/>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>芯片号</th>
        <th>贴纸号码</th>
        <th>贴纸等级:1优宠级;2纯种级;3参赛级;4冠军级</th>
        <th>修改时间</th>
        <th>备注信息</th>
        <shiro:hasPermission name="dog:dogSticker:edit">
            <th>操作</th>
        </shiro:hasPermission>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="dogSticker">
        <tr>
            <td><a href="${ctx}/dog/dogSticker/form?id=${dogSticker.id}">
                    ${dogSticker.identificationFlag}
            </a></td>
            <td>
                    ${dogSticker.stickerNo}
            </td>
            <td>
                    ${dogSticker.stickerClass}
            </td>
            <td>
                <fmt:formatDate value="${dogSticker.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                    ${dogSticker.remarks}
            </td>
            <shiro:hasPermission name="dog:dogSticker:edit">
                <td>
                    <a href="${ctx}/dog/dogSticker/form?id=${dogSticker.id}">修改</a>
                    <a href="${ctx}/dog/dogSticker/delete?id=${dogSticker.id}"
                       onclick="return confirmx('确认要删除该犬只贴纸吗？', this.href)">删除</a>
                </td>
            </shiro:hasPermission>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>