<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>种犬申报管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            $("#reviewRemarksDiv").hide();
            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function (form) {
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });

            //下拉回显
            $("#reviewState").val("${dogFrozenSemen.reviewState}");
            $("#reviewState").trigger("change");

        });

        function changeReviewState() {
            var reviewState = $('#reviewState').val();
            if (reviewState == '2') {
                $("#reviewRemarksDiv").show();
            } else if (reviewState == '1') {
                $("#reviewRemarksDiv").hide();
            }
        }

    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/dogfrozensemen/dogFrozenSemen/list?businessType=1">种犬报备列表</a></li>
    <li class="active"><a href="${ctx}/dogfrozensemen/dogFrozenSemen/form?id=${dogFrozenSemen.id}">种犬报备审核</a></li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="dogFrozenSemen" action="${ctx}/dogfrozensemen/dogFrozenSemen/audit1"
           method="post" class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">血统证书号：</label>
        <div class="controls">
                ${fns:escapeHtml(dogFrozenSemen.dog.pedigreeCertifiedCode) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">芯片号码：</label>
        <div class="controls">
                ${fns:escapeHtml(dogFrozenSemen.dog.identificationFlag) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬种：</label>
        <div class="controls">
                ${fns:escapeHtml(dogFrozenSemen.breedCnName) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬名：</label>
        <div class="controls">
                ${fns:escapeHtml(dogFrozenSemen.dog.nameEn) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬主：</label>
        <div class="controls">
                ${fns:escapeHtml(dogFrozenSemen.dog.dogOwner) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬主会员号：</label>
        <div class="controls">
                ${fns:escapeHtml(dogFrozenSemen.dog.memberCode) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">精子信息：</label>
        <div class="controls">
                ${fns:escapeHtml(dogFrozenSemen.semenNumber) }管
            <table class="table table-striped table-bordered table-condensed">
                <thead>
                <tr>
                    <th>原精子编号</th>
                    <th>CKU精子编号</th>
                </tr>
                </thead>
                <tbody>
                <c:forEach items="${dogSemenList}" var="dogSemen">
                <tr>
                    <td>
                            ${fns:escapeHtml(dogSemen.originalSemenCode) }
                    </td>
                    <td>
                            ${fns:escapeHtml(dogSemen.semenCode) }
                    </td>
                <tr>
                    </c:forEach>
                </tbody>
            </table>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">审核状态：</label>
        <div class="controls">
            <form:select id="reviewState" path="reviewState" class="input-medium" onchange="changeReviewState()">
                <option value="1">通过</option>
                <option value="2">不通过</option>
            </form:select>
        </div>
    </div>
    <div id="reviewRemarksDiv" class="control-group">
        <label class="control-label">审核意见：</label>
        <div class="controls">
            <form:input path="reviewRemarks" htmlEscape="false" maxlength="200" class="input-xlarge required"/>
        </div>
    </div>
    <div class="form-actions">
        <shiro:hasPermission name="dogfrozensemen:dogFrozenSemen:audit"><input id="btnSubmit" class="btn btn-primary"
                                                                               type="submit"
                                                                               value="保 存"/>&nbsp;</shiro:hasPermission>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>