<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>出口证书申请管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function auditForm(id){
 			parent.layer.open({
				type: 2,
				title: ['证书出口审核', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['800px', '600px'],
				content: ctx+"/dogexport/dogPedigreeCertifiedExport/auditForm?id="+id,
				end: function(){
					if(parent.isYes){
						var mainF = parent.$("#mainFrame");
						mainF.contents().find("#searchForm").submit();
					};
				}
			});
		}
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/dogexport/dogPedigreeCertifiedExport/">出口证书申请列表</a></li>
		<%-- <shiro:hasPermission name="dogexport:dogPedigreeCertifiedExport:edit"><li><a href="${ctx}/dogexport/dogPedigreeCertifiedExport/form">出口证书申请添加</a></li></shiro:hasPermission> --%>
	</ul>
	<form:form id="searchForm" modelAttribute="dogPedigreeCertifiedExport" action="${ctx}/dogexport/dogPedigreeCertifiedExport/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>血统证书号：</label>
				<form:input path="pedigreeCertified" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>会员号/姓名：</label>
				<form:input path="paymentMemberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>审核状态：</label>
				<form:select path="reviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>订单状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>申请日期：</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogPedigreeCertifiedExport.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> - 
					<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${dogPedigreeCertifiedExport.endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>血统证书号</th>
				<th>会员名</th>
				<th>申请日期</th>
				<th>出口国家</th>
				<th>接收人</th>
				<th>地址</th>
				<th>操作人</th>
				<th>订单状态</th>
				<th>审核状态</th>
				<th>管理</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogPedigreeCertifiedExport">
			<tr>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedExport.pedigreeCertified)}
				</td>
				<td title="${fns:escapeHtml(dogPedigreeCertifiedExport.paymentMemberCode)}">
					${fns:escapeHtml(dogPedigreeCertifiedExport.dogOwner)}
				</td>
				<td>
					<fmt:formatDate value="${dogPedigreeCertifiedExport.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedExport.exportCountry)}
				</td>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedExport.exporter)}
				</td>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedExport.exportDestination)}
				</td>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedExport.operator)}
				</td>
				<td style="color:${dogPedigreeCertifiedExport.paymentState=='2'?'#090':'#F00'}">
					${fns:getDictLabel(dogPedigreeCertifiedExport.paymentState, 'user_payment_state', '')}
				</td>
				<td title="${fns:escapeHtml(dogPedigreeCertifiedExport.reviewRemarks)}">
					<c:if test="${dogPedigreeCertifiedExport.paymentState=='2'}">
					<c:choose>
						<c:when test="${(dogPedigreeCertifiedExport.reviewState=='0'||dogPedigreeCertifiedExport.reviewState=='2'||dogPedigreeCertifiedExport.reviewState=='1')&&!dogPedigreeCertifiedExport.businessRefundState}">
							<a style="color:#F00" onclick="auditForm('${fns:escapeHtml(dogPedigreeCertifiedExport.id)}')">${fns:getDictLabel(dogPedigreeCertifiedExport.reviewState, 'review_state', '')}</a>
						</c:when>
						<c:otherwise>
							${fns:getDictLabel(dogPedigreeCertifiedExport.reviewState, 'review_state', '')}
						</c:otherwise>
					</c:choose>
					</c:if>
				</td>
				<td>
					<c:if test="${dogPedigreeCertifiedExport.paymentState=='2'&&dogPedigreeCertifiedExport.reviewState=='1'}">
						<c:choose>
							<c:when test="${dogPedigreeCertifiedExport.processState=='0'}">
								<a style="color:#F00" href="${ctx}/dogexport/dogPedigreeCertifiedExport/resolve?id=${fns:escapeHtml(dogPedigreeCertifiedExport.id)}"
									onclick="return confirmx('确认要处理该证书出口吗？', this.href)">
								${fns:getDictLabel(dogPedigreeCertifiedExport.processState, 'proccess_state', '')}
								</a>
							</c:when>
							<c:when test="${dogPedigreeCertifiedExport.processState=='1'}">
								${fns:getDictLabel(dogPedigreeCertifiedExport.processState, 'proccess_state', '')}
							</c:when>
						</c:choose>
					</c:if>
				</td>
				<td>
    				<a href="${ctx}/dogexport/dogPedigreeCertifiedExport/form?id=${dogPedigreeCertifiedExport.id}">查看</a>
				<shiro:hasPermission name="dogexport:dogPedigreeCertifiedExport:edit">
					<c:if test="${!dogPedigreeCertifiedExport.businessRefundState}">
						<a href="${ctx}/dogexport/dogPedigreeCertifiedExport/editForm?id=${dogPedigreeCertifiedExport.id}">编辑</a>
					</c:if>
				</shiro:hasPermission>
				<c:if test="${dogPedigreeCertifiedExport.processState=='1'}">
				<shiro:hasPermission name="dogexport:dogPedigreeCertifiedExport:print">
					<c:if test="${dogPedigreeCertifiedExport.printState=='3'}">
					<a href="${ctx}/dogexport/dogPedigreeCertifiedExport/print?id=${dogPedigreeCertifiedExport.id}">证书出口打印</a>
					</c:if>
				</shiro:hasPermission>				
				<shiro:hasPermission name="dogexport:dogPedigreeCertifiedExport:resetPrint">
					<c:if test="${dogPedigreeCertifiedExport.printState=='03'}">
					<a href="${ctx}/dogexport/dogPedigreeCertifiedExport/resetPrint?id=${dogPedigreeCertifiedExport.id}">重置证书出口打印</a>
					</c:if>
				</shiro:hasPermission>				
				</c:if>
				<c:if test="${'1' eq dogPedigreeCertifiedExport.paymentState}">
				<shiro:hasPermission name="dogexport:dogPedigreeCertifiedExport:delete">
				<c:if test="${!dogPedigreeCertifiedExport.businessRefundState}">
					<a href="${ctx}/dogexport/dogPedigreeCertifiedExport/delete?id=${dogPedigreeCertifiedExport.id}" onclick="return confirmx('确认要删除该出口证书申请吗？', this.href)">删除</a>
				</c:if>
				</shiro:hasPermission>
				</c:if>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>