<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>冠军登录信息管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {
            
        });
    </script>
</head>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
	<thead>
	<tr>
		<th>出生纸编号</th>
		<th>血统证书编号</th>
		<th>犬主</th>
		<th>父血统证书号</th>
		<th>母血统证书号</th>
		<th>申请日期</th>
		<th>订单状态</th>
		<th>审核状态</th>
		<th>撤销状态</th>
		<shiro:hasPermission name="dogdnaparentscompare:dogDnaParentsCompare:edit"><th>操作</th></shiro:hasPermission>
	</tr>
	</thead>
	<tbody>
	<c:forEach items="${list}" var="dogDnaParentsCompare">
		<tr>
			<td>
					${dogDnaParentsCompare.birthCode}
				</a>
			</td>
			<td>
					${dogDnaParentsCompare.pedigreeCertified}
			</td>
			<td>
					${dogDnaParentsCompare.name}
			</td>
			<td>
					${dogDnaParentsCompare.fdogPedigreeCertified}
			</td>
			<td>
					${dogDnaParentsCompare.mdogPedigreeCertified}
			</td>
			<td>
				<fmt:formatDate value="${dogDnaParentsCompare.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</td>
			<td style="color:${dogDnaParentsCompare.paymentState=='2'?'#090':'#F00'}">
					${fns:getDictLabel(dogDnaParentsCompare.paymentState, 'user_payment_state', '')}
			</td>
			<td>
				<c:if test="${dogDnaParentsCompare.paymentState==2}">
					<c:if test="${dogDnaParentsCompare.reviewState==0 and !dogDnaParentsCompare.businessRefundState}">
						<a onclick="auditForm('${dogDnaParentsCompare.id}')">
								${fns:getDictLabel(dogDnaParentsCompare.reviewState, 'review_state', '')}
						</a>
					</c:if>
					<c:if test="${dogDnaParentsCompare.reviewState!=0}">
						${fns:getDictLabel(dogDnaParentsCompare.reviewState, 'review_state', '')}
					</c:if>
				</c:if>
			</td>
			<td>
				<c:if test="${dogDnaParentsCompare.isCanceled=='1'}">
					已撤销
				</c:if>
			</td>
			<shiro:hasPermission name="dogdnaparentscompare:dogDnaParentsCompare:delete"><td>
				<c:if test="${!dogDnaParentsCompare.businessRefundState}">
					<a href="${ctx}/dogdnaparentscompare/dogDnaParentsCompare/delete?id=${dogDnaParentsCompare.id}" onclick="return confirmx('确认要删除该DNA双亲比对吗？', this.href)">删除</a>
				</c:if>
			</td></shiro:hasPermission>
		</tr>
	</c:forEach>
	</tbody>
</table>
</body>
</html>