<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬只颜色及标志管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/dogcolormark/dogColorMark/">犬只颜色及标志列表</a></li>
		<shiro:hasPermission name="dogcolormark:dogColorMark:edit"><li><a href="${ctx}/dogcolormark/dogColorMark/form">犬只颜色及标志添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="dogColorMark" action="${ctx}/dogcolormark/dogColorMark/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>犬颜色及标记编码：</label>
				<form:input path="dogColorMarkCode" htmlEscape="false" maxlength="20" class="input-medium"/>
			</li>
			<li><label>犬颜色及标记(中文)：</label>
				<form:input path="dogColorMarkCn" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>犬颜色及标记编码</th>
				<th>犬颜色及标记(中文)</th>
				<th>修改时间</th>
				<th>备注信息</th>
				<shiro:hasPermission name="dogcolormark:dogColorMark:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogColorMark">
			<tr>
				<td><a href="${ctx}/dogcolormark/dogColorMark/form?id=${dogColorMark.id}">
					${fns:escapeHtml(dogColorMark.dogColorMarkCode)}
				</a></td>
				<td>
					${fns:escapeHtml(dogColorMark.dogColorMarkCn)}
				</td>
				<td>
					<fmt:formatDate value="${dogColorMark.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${fns:escapeHtml(dogColorMark.remarks)}
				</td>
				<shiro:hasPermission name="dogcolormark:dogColorMark:edit"><td>
    				<a href="${ctx}/dogcolormark/dogColorMark/form?id=${dogColorMark.id}">修改</a>
					<a href="${ctx}/dogcolormark/dogColorMark/delete?id=${dogColorMark.id}" onclick="return confirmx('确认要删除该犬只颜色及标志吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>