<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬只信息管理</title>
	<meta name="decorator" content="default"/>
    <link href="${ctxStatic}/layui/css/layui.css" rel="stylesheet"/>
    <script src="${ctxStatic}/layui/layui.js" type="text/javascript"></script>
    <script src="${ctxStatic}/layui/lay/dest/layui.all.js" type="text/javascript"></script>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					var pedigreeCertifiedCode=$("#pedigreeCertifiedCode").val();//血统证书号
					var identificationFlag=$("#identificationFlag").val();//芯片号
					var identificationFlagHid = $("#identificationFlagHid").val();//页面初始化时的芯片号
					var id=$("#id").val();
					var b = true;
					if (identificationFlag!=null&&identificationFlag!=''&&identificationFlag!=identificationFlagHid) {
						 $.ajax({
								type: "POST",
				                dataType:"json",
				                url:"${ctx}/dog/dog/checkIdentification?id="+id+"&identificationFlag="+identificationFlag,
				                async: false,
				                error: function(request, textStatus, errorThrown) {
				                    alert("请求失败！");
				                },
				                success: function(data) {
				                	if(data.rc == 1){
										$.jBox.alert("此芯片号【"+data.identificationFlag+"】已存在","提示");
										b=false;
										layer.closeAll('loading');
				                	}else{
				                		b=true;
				                	}
				                }
							});
					}
					if(b){
						$.ajax({
                            type: "POST",
                            dataType:"json",
                            url:"${ctx}/dog/dog/codeCheck?pedigreeCertifiedCode="+pedigreeCertifiedCode+"&id="+id,
                            async: false,
                            error: function(request, textStatus, errorThrown) {
                                alert("请求失败！");
                            },
                            success: function(data) {
                                if(data.rc == 1){
                                        $.jBox.alert("此血统证书号【"+data.pedigreeCertifiedCode+"】已存在","提示");
                                        layer.closeAll('loading');
                                }else{
                                    form.submit();
                                }
                            }
                        });
					}
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});

			var i='${empty dog.id?"0":"1"}';
			if(i==1){
				$('#identificationFlag').attr("disabled",true);
				$('#cabPassport_edit').attr("disabled",true);
			}
			
			if( $("#fdogPedigreeCertified_edit").val().indexOf("*") != -1){
				$('#fdogPedigreeCertified_edit_check').attr("disabled",true);
			}
			if( $("#mdogPedigreeCertified_edit").val().indexOf("*") != -1){
				$('#mdogPedigreeCertified_edit_check').attr("disabled",true);
			}
			$("#mdogPedigreeCertified_edit").on('change', function(){
				$('#mdogPedigreeCertified_edit_check').attr("disabled",false);
			});
			$("#fdogPedigreeCertified_edit").on('change', function(){
				$('#fdogPedigreeCertified_edit_check').attr("disabled",false);
			});
			


			$("#pedigreeCertifiedCode").on('change', function(){
				var code = $("#pedigreeCertifiedCode").val().toLowerCase();
				if(code.indexOf("ngkc") == 0){
					var encode = code.substring(4,code.length).trim();
					$("#pedigreeCertifiedEn").val(encode + "S");
				} else if(code.indexOf("ng") == 0){
					var encode = code.substring(2,code.length).trim();
					$("#pedigreeCertifiedEn").val(encode + "S");
				}
			});

		});
		//打开查询用户的弹窗
        var searchUserFlag = "";
        function searchUser(index){
            searchUserFlag = index;
            top.layer.open({
                type: 2,
                title: ['会员查询', 'font-size:18px;text-align: center;'],
                shadeClose: false,
                shade: [0.8, '#393D49'],
                maxmin: false, //开启最大化最小化按钮
                area: ['700px', '500px'],
                content: "${ctx}/sys/user/member/search"
            });
        }

        function cleanSecondOwner(){
            $("#secondDogOwner").val("");
            $("#secondOwnerMemberNum").val("");
        }

       //查询用户完成的回调方法
       this.searchUserCallback = function (json){
           if(searchUserFlag=="1"){
               $("#memberCode").val(json.memberCode);
               $("#dogOwner").val(json.name);
           }else if(searchUserFlag=="2"){
               $("#secondOwnerMemberNum").val(json.memberCode);
               $("#secondDogOwner").val(json.name);
           }
       }

       //查询父母犬配种信息
       function searchFmdog(){
    	   var fmdogBreedCertifiedCode=$("#fmdogBreedCertifiedCode").val();
    	   var b=$.isNumeric(fmdogBreedCertifiedCode);
    	   var pedigreeCertifiedEn=$("#pedigreeCertifiedEn").val();
    	   if (fmdogBreedCertifiedCode!='') {
	    	  if (!b) {//国外犬只配种证号
	    		  $.ajax({
						type: "POST",
		               dataType:"json",
		               url:"${ctx}/dog/dogamphimixis/dogAmphimixisProve/getFM?fmdogBreedCertifiedCode="+fmdogBreedCertifiedCode,
		               async: false,
		               error: function(request, textStatus, errorThrown) {
		                   alert("请求失败！");
		               },
		               success: function(data) {
		            	   if (data.rc==0) {
			            	  $("#fdogName").val(data.fdogName);
			            	  $("#fdogPedigreeCertified").val(data.fdogPedigreeCertified);
			            	  $("#mdogPedigreeCertified").val(data.mdogPedigreeCertified);
			            	  $("#mdogName").val(data.mdogName);
							}else{
								$.jBox.alert(data.error,"提示");
							}
		               }
					});
				}else{//国内犬只配种证号
	    		   $.ajax({
						type: "POST",
		               dataType:"json",
		               url:"${ctx}/dognewborn/dogNewborn/getFM?breedCertifiedCode="+fmdogBreedCertifiedCode,
		               async: false,
		               error: function(request, textStatus, errorThrown) {
		                   alert("请求失败！");
		               },
		               success: function(data) {
		            	   if (data.rc==0) {
			            	  $("#mdogName").val(data.fdogName);
			            	  $("#mdogPedigreeCertified").val(data.femalePedigreeCertified);
			            	  $("#fdogPedigreeCertified").val(data.malePedigreeCertified);
			            	  $("#fdogName").val(data.mdogName);
							}else{
								$.jBox.alert(data.error,"提示");
							}
		               }
					});
				}
			}
       }
        function setShowDogBreed() {
            var dogBreed = $("#dogBreed").val();
            $.post('${ctx}/dogTypeShow/dogTypeShow/findListByDogBreed', {
                dogBreed: dogBreed
            }, function (data) {
                $('#showDogBreed').empty();
                if (data.length != '1') {
                    $('#showDogBreed').append("<option value=''>请选择FCI赛事编码</option>");
                }
                $.each(data, function (i, val) {
                    $('#showDogBreed').append("<option value ='" + val.dogShowCode + "'>" + val.showEnName + "</option>");
                });
                $("#showDogBreed").trigger("change");
            });
        }
       function jumpUrl(i){
			if(i==1){
				var fdog=$("#fdogPedigreeCertified").val();
				if (fdog!="") {
					var fdogPedigreeCertified_edit = $("#fdogPedigreeCertified_edit").val();
					if(fdogPedigreeCertified_edit.indexOf("*") == -1 ){
						fdog=fdogPedigreeCertified_edit;
						window.open('${dogInfoURL}'+fdog);
					}else{
						$('#fdogPedigreeCertified_edit_check').attr("disabled",true);
						alert("如需修改请写完整完整血统证书号!");
					}
					
				}
			}
			if(i==2){
				var mdog=$("#mdogPedigreeCertified").val();
				if (mdog!="") {
					var mdogPedigreeCertified_edit = $("#mdogPedigreeCertified_edit").val();
					if(mdogPedigreeCertified_edit.indexOf("*") == -1 ){
						mdog=mdogPedigreeCertified_edit;
						window.open('${dogInfoURL}'+mdog);
					}else{
						$('#mdogPedigreeCertified_edit_check').attr("disabled",true);
						alert("如需修改请写完整完整血统证书号!");
					}
				}
			}
		}

        function saveDog() {
            if (!$('#inputForm').valid()){
                return;
            }
            layer.load();
            var birthCertificateLevelCode_edit = $("#birthCertificateLevelCode_edit").val();
            if (birthCertificateLevelCode_edit.indexOf("*") == -1) {
                $("#birthCertificateLevelCode").val(birthCertificateLevelCode_edit);
            }
            var pedigreeCertifiedCode_edit = $("#pedigreeCertifiedCode_edit").val();
            if (pedigreeCertifiedCode_edit.indexOf("*") == -1) {
                $("#pedigreeCertifiedCode").val(pedigreeCertifiedCode_edit);
            }
            var fdogPedigreeCertified_edit = $("#fdogPedigreeCertified_edit").val();
            if (fdogPedigreeCertified_edit.indexOf("*") == -1) {
                $("#fdogPedigreeCertified").val(fdogPedigreeCertified_edit);
            }
            var mdogPedigreeCertified_edit = $("#mdogPedigreeCertified_edit").val();
            if (mdogPedigreeCertified_edit.indexOf("*") == -1) {
                $("#mdogPedigreeCertified").val(mdogPedigreeCertified_edit);
            }
            var cabPassport_edit = $("#cabPassport_edit").val();
            if (cabPassport_edit.indexOf("*") == -1) {
                $("#cabPassport").val(cabPassport_edit);
            }
            $("#inputForm").submit();
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/dog/dog/${'230'eq dog.dogBreed?'?dogBreed=230':''}">犬只信息列表</a></li>
		<li class="active"><a href="${ctx}/dog/dog/form?id=${dog.id}">犬只信息<shiro:hasPermission name="dog:dog:${not empty dog.id?'edit':'add'}">${not empty dog.id?'修改':'添加'}</shiro:hasPermission><shiro:lacksPermission name="dog:dog:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="dog" action="${ctx}/dog/dog/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<input type="hidden" id="identificationFlagHid" value="${dog.identificationFlag}"/>
		<sys:message content="${message}"/>
        <div style="width: 100%">
            <div style="float: left ;width: 50%">
                <div class="control-group">
                    <label class="control-label">犬只照片：</label>
                    <div class="controls">
                        <img  style="width:180px; height: 190px" src="${dog.picture}">
                    </div>
                </div>
            </div>
            <div style="float: left ;width: 50%;">
                <div class="control-group">
                    <label class="control-label">图片审核：</label>
                    <div class="controls">
                    	<div style="height: 123px;" >
                            ${fns:getDictLabel(dog.pictureReviewState, 'review_state', '')}
                        </div>
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label">未通过原因：</label>
                    <div class="controls">
                        <form:textarea path="pictureReviewRemark" htmlEscape="false" style="resize:none" maxlength="255" class="input-xlarge " readonly="true"/>
                    </div>
                </div>
            </div>
        </div>
        <div style="clear:both;"/>
		<div class="control-group">
			<label class="control-label">出生证明编号：</label>
			<div class="controls">
				<form:hidden path="birthCertificateLevelCode" htmlEscape="false" maxlength="64" class="input-xlarge "/>
				<input id="birthCertificateLevelCode_edit" htmlEscape="false" maxlength="64" class="input-xlarge "   type="text" 
                     value="${fns:desensitize(dog.birthCertificateLevelCode,4)}"/>(如需修改请写完整出生证明编号)
			</div>
		</div>
		<%-- <div class="control-group">
            <label class="control-label">档案号：</label>
            <div class="controls">
                <form:input path="archivesCode" htmlEscape="false" maxlength="100" class="input-xlarge "/>
            </div>
        </div> --%>
		<div class="control-group">
            <label class="control-label">性别：</label>
            <div class="controls">
                <form:radiobuttons path="gender" items="${fns:getDictList('dog_gender')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
                <font color="#FF0000">* </font>
            </div>
        </div>
        <div class="control-group" style="float: left">
			<label class="control-label">犬只代数：</label>
			<div class="controls">
				<form:input path="dogGeneration" readonly="true" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div>
        <div class="control-group">
            <label class="control-label">犬只呼名：</label>
            <div class="controls">
                <form:input path="callName"  htmlEscape="false" maxlength="4" class="input-xlarge "/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">犬只状态：</label>
            <div class="controls">
                <form:select path="dogState" class="input-xlarge ">
                    <form:options items="${fns:getDictList('dogState')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </div>
        </div>
		<div class="control-group" style="float: left">
            <label class="control-label">血统证书号：</label>
            <div class="controls">
                <form:hidden path="pedigreeCertifiedCode" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
                <input  id="pedigreeCertifiedCode_edit" htmlEscape="false" maxlength="64" class="input-xlarge required"   type="text" 
                	value="${fns:desensitize(dog.pedigreeCertifiedCode,1)}"/>
                <font color="#FF0000">* </font>(如需修改请写完整血统证书号)
                <span id="pedigreeCertifiedCodeError" style="color:red;display:none" class="error"></span>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">芯片号：</label>
            <div class="controls">
               <form:input path="identificationFlag" htmlEscape="false" maxlength="64" class="input-xlarge "/>
            	<span id="identificationFlagError" style="color:red;display:none" class="error"></span>
            </div>
        </div>
        <div style="clear:both;"></div>
        <div class="control-group">
            <label class="control-label">宠爱护照号：</label>
            <div class="controls">
                <form:hidden path="cabPassport"/>
                <input id="cabPassport_edit" htmlEscape="false" maxlength="64" class="input-xlarge "  type="text" 
                	value="${fns:desensitize(dog.cabPassport,3)}"/>
            </div>
        </div>
		<div class="control-group" style="float: left">
            <label class="control-label">英文姓名：</label>
            <div class="controls">
                <form:input path="nameEn" htmlEscape="false" maxlength="255" class="input-xlarge required"/>
                <font color="#FF0000">* </font>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">中文姓名：</label>
            <div class="controls">
                <form:input path="nameCn" htmlEscape="false" maxlength="64" class="input-xlarge "/>
            </div>
        </div>
        <div class="control-group"  style="float: left">
            <label class="control-label">种类：</label>
            <div class="controls">
                <form:select id="dogBreed" path="dogBreed" class="input-xlarge required" onchange="setShowDogBreed();">
                    <form:option value="" label=""/>
                    <form:options items="${dogBreedList}" itemLabel="breedEnName" itemValue="dogBreedCode" htmlEscape="false"/>
                </form:select>
                <font color="#FF0000">* </font>
            </div>
        </div>
        <shiro:hasPermission name="dog:dog:editshow">
            <div class="control-group">
                <label class="control-label">FCI赛事编码：</label>
                <div class="controls">
                    <form:select id="showDogBreed" path="showDogBreed" class="input-xlarge">
                        <form:option value="" label=""/>
                        <form:options items="${showDogBreedList}" itemLabel="showEnName" itemValue="dogShowCode" htmlEscape="false"/>
                    </form:select>
                </div>
            </div>
        </shiro:hasPermission>
        <shiro:lacksPermission name="dog:dog:editshow">
            <div class="control-group">
                <label class="control-label">FCI赛事编码：</label>
                <div class="controls">
                    <form:select id="showDogBreed" path="showDogBreed" class="input-xlarge" disabled="true">
                        <form:option value="" label=""/>
                        <form:options items="${showDogBreedList}" itemLabel="showEnName" itemValue="dogShowCode" htmlEscape="false"/>
                    </form:select>
                </div>
            </div>
        </shiro:lacksPermission>
        <div class="control-group">
            <label class="control-label">出生日期：</label>
            <div class="controls">
                <input name="birthdate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
                    value="<fmt:formatDate value="${dog.birthdate}" pattern="yyyy-MM-dd"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
            </div>
        </div>
        <div class="control-group" style="float: left">
            <label class="control-label">犬主人：</label>
            <div class="controls">
                <form:input path="dogOwner" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">会员号：</label>
            <div class="controls">
                <form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-xlarge " readonly="true"/>
                <input id="search" class="btn btn-primary" type="button" value="查" onclick="searchUser(1)"/>
            </div>
        </div>
        <div class="control-group" style="float: left">
            <label class="control-label">第二犬主人：</label>
            <div class="controls">
                <form:input path="secondDogOwner" htmlEscape="false" maxlength="64" class="input-xlarge "/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">第二犬主会员号：</label>
            <div class="controls">
                <form:input path="secondOwnerMemberNum" htmlEscape="false" maxlength="64" class="input-xlarge "/>
                <input id="search" class="btn btn-primary" type="button" value="查" onclick="searchUser(2)"/>
                <input class="btn btn-primary" type="button" value="清空" onclick="cleanSecondOwner()"/>
            </div>
        </div>
        <div class="control-group" style="float: left">
            <label class="control-label">颜色及标志1：</label>
            <div class="controls">
            	<form:input path="colorFlag" htmlEscape="false" maxlength="64" class="input-xlarge "/>
<%--                 <form:select id="colorFlag" path="colorFlag" class="input-xlarge">
                    <form:option value="" label=""/>
                    <form:options items="${dogColorMarkList}" itemLabel="dogColorMarkCn" itemValue="dogColorMarkCode" htmlEscape="false"/>
                </form:select> --%>
            </div>
        </div>
		<%-- <div class="control-group">
			<label class="control-label">毛质：</label>
			<div class="controls">
				<form:input path="wool" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
		</div> --%>
		<div class="control-group">
            <label class="control-label">特殊标志：</label>
            <div class="controls">
                <form:input path="specialFlag" htmlEscape="false" maxlength="64" class="input-xlarge "/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">配种证明号：</label>
            <div class="controls">
                <form:input path="fmdogBreedCertifiedCode" htmlEscape="false" maxlength="100" class="input-xlarge "/>
                <input class="btn btn-primary" type="button" value="查" onclick="searchFmdog()"/>
            </div>
        </div>
		<div class="control-group">
            <label class="control-label">DNA编号：</label>
            <div class="controls">
                <form:input path="dna" htmlEscape="false" maxlength="64" class="input-xlarge "/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">采样包编号：</label>
            <div class="controls">
                <form:input path="samplingCode" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">金质证书类型：</label>
            <div class="controls">
                <form:select path="goldCertifiedType" class="input-xlarge " disabled="true">
                    <form:option value="" label=""/>
                    <form:options items="${fns:getDictList('dna_parents_compare_apply_source')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">金质证书状态：</label>
            <div class="controls">
                <form:select path="goldCertifiedState" class="input-xlarge " disabled="true">
                    <form:option value="" label=""/>
                    <form:options items="${fns:getDictList('gold_certified_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </div>
        </div>
        <div style="clear:both;"></div>
        <%-- <div class="control-group">
            <label class="control-label">繁育审核：</label>
            <div class="controls">
                <form:input path="breedReviewe" htmlEscape="false" maxlength="50" class="input-xlarge "/>
            </div>
        </div> --%>
         <div class="control-group" style="float: left">
            <label class="control-label">公犬姓名：</label>
            <div class="controls">
                <input id="fdogName" type="text" />
            </div>
        </div>
        <div class="control-group" >
            <label class="control-label">父犬血统证书号：</label>
            <div class="controls">
                <form:hidden path="fdogPedigreeCertified"/>
                <input id="fdogPedigreeCertified_edit" htmlEscape="false" maxlength="100" class="input-xlarge " type="text" 
                	value="${fns:desensitize(dog.fdogPedigreeCertified,1)}"/>
                <input  id="fdogPedigreeCertified_edit_check" class="btn btn-primary" type="button" value="查" onclick="jumpUrl(1)"/>(如需修改请写完整血统证书号)
            </div>
        </div>
         <div class="control-group" style="float: left">
            <label class="control-label" >母犬姓名：</label>
            <div class="controls">
                <input id="mdogName" type="text" />
            </div>
        </div>
        <div class="control-group" >
            <label class="control-label">母犬血统证书号：</label>
            <div class="controls">
                <form:hidden path="mdogPedigreeCertified"/>
                <input id="mdogPedigreeCertified_edit" htmlEscape="false" maxlength="100" class="input-xlarge "type="text" 
                	value="${fns:desensitize(dog.mdogPedigreeCertified,1)}"/>
                <input  id="mdogPedigreeCertified_edit_check"  class="btn btn-primary" type="button" value="查" onclick="jumpUrl(2)"/>(如需修改请写完整血统证书号)
            </div>
        </div>
        <div class="control-group" style="float: left">
            <label class="control-label">比赛级别：</label>
            <div class="controls">
                <form:input path="showLevel" htmlEscape="false" maxlength="64" class="input-xlarge "/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">比赛成绩：</label>
            <div class="controls">
                <form:input path="showGrade" htmlEscape="false" maxlength="100" class="input-xlarge "/>
            </div>
        </div>
        <div class="control-group" style="float: left">
            <label class="control-label">考试级别：</label>
            <div class="controls">
                <form:input path="testLevel" htmlEscape="false" maxlength="64" class="input-xlarge "/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">考试成绩：</label>
            <div class="controls">
                <form:input path="testGrade" htmlEscape="false" maxlength="100" class="input-xlarge "/>
            </div>
        </div>
        <div class="control-group" style="float: left">
            <label class="control-label">旧血统证书号：</label>
            <div class="controls">
                <form:input path="pedigreeCertifiedOld" htmlEscape="false" maxlength="64" class="input-xlarge "/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">国外血统证书号：</label>
            <div class="controls">
                <form:input path="pedigreeCertifiedEn" htmlEscape="false" maxlength="64" class="input-xlarge "/>
            </div>
        </div>
        <div class="control-group" style="float: left">
            <label class="control-label">肘关节鉴定结果：</label>
            <div class="controls">
                <form:input path="elbowQualificationResult" htmlEscape="false" maxlength="64" class="input-xlarge "/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">髋关节鉴定结果：</label>
            <div class="controls">
                <form:input path="hipQualificationResult" htmlEscape="false" maxlength="255" class="input-xlarge "/>
            </div>
        </div>
		<div class="control-group" style="float: left">
			<label class="control-label">繁殖资格：</label>
			<div class="controls">
				<form:input path="breedQualification" htmlEscape="false" maxlength="64" class="input-xlarge "/>
			</div>
        </div>
        <div class="control-group">
            <label class="control-label">繁殖禁止：</label>
            <div class="controls">
                <form:select path="businessBan" class="input-xlarge ">
                    <form:options items="${fns:getDictList('business_ban')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </div>
        </div>
         <div class="control-group">
            <label class="control-label">出口禁止：</label>
            <div class="controls">
                <form:select path="changeBan" class="input-xlarge ">
                    <form:options items="${fns:getDictList('business_ban')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </div>
        </div>
        <div class="control-group" style="float: left">
			<label class="control-label">失格次数：</label>
			<div class="controls">
				<form:input path="disqualificationNumber" htmlEscape="false" maxlength="11" class="input-xlarge digits"/>
			</div>
		</div>
        <div class="control-group">
            <label class="control-label">犬展禁止：</label>
            <div class="controls">
                <form:select path="showBan" class="input-xlarge ">
                    <form:options items="${fns:getDictList('business_ban')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
                </form:select>
            </div>
        </div>
        
        
		<div class="control-group">
            <label class="control-label">裁判评价：</label>
            <div class="controls">
                <form:textarea path="refereeEvaluation" htmlEscape="false" rows="4" maxlength="500" class="input-xxlarge "/>
            </div>
        </div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="dog:dog:${not empty dog.id?'edit':'add'}"><input id="btnSubmit" class="btn btn-primary" type="button" onclick="saveDog()" value="保 存"/>&nbsp;</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
			<button class="btn" onclick="util.showLog('/oa-web/oaManage/dog/dog','${dog.id}');return false;">查看操作日志</button>
		</div>
	</form:form>
</body>
</html>