<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>犬主变更管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            //悬浮提示插件
            $(document).tooltip();
        });

        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }

        function mergePayByOrder(id, table, items, memberCode) {
            parent.layer.open({
                type: 2,
                title: ['会员扣款', 'font-size:18px;text-align: center;'],
                shadeClose: false,
                shade: [0.8, '#393D49'],
                maxmin: false, //开启最大化最小化按钮
                area: ['700px', '550px'],
                content: ctx + "/finance/deductCost/toMergeMemberPayByOrder?memberCode=" + memberCode + "&items=" + items + "&businessId=" + id + "&businessTable=" + table,
                end: function () {
                    if (parent.isYes) {
                        var mainF = parent.$("#mainFrame");
                        if (mainF.contents().find("#searchForm").length != 0) {
                            mainF.contents().find("#searchForm").submit();
                        } else {
                            parent.document.getElementById("mainFrame").contentWindow.location.reload();
                        }
                    }
                    ;
                }
            });
        };
    </script>
    <link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
    <script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/catx/dog/dogOwnerChange/">犬主变更列表</a></li>
    <li><a href="${ctx}/catx/dog/dogOwnerChange/addForm">犬主变更添加</a></li>
</ul>
<form:form id="searchForm" modelAttribute="dogOwnerChange" action="${ctx}/catx/dog/dogOwnerChange/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>血统证书号：</label>
            <form:input path="dog.pedigreeCertifiedCode" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>会员号/姓名：</label>
            <form:input path="originOwnerName" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>审核人：</label>
            <form:input path="reviewer" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>付款状态：</label>
            <form:select path="paymentState" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
        </li>
        <li><label>审核状态：</label>
            <form:select path="reviewState" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
        </li>
        <li><label>处理状态：</label>
            <form:select path="processState" class="input-medium">
                <form:option value="" label="全部"/>
                <form:options items="${fns:getDictList('proccess_state')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
        </li>
        <li><label>申请时间：</label>
            <input name="beginDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                   value="<fmt:formatDate value="${dogOwnerChange.beginDate}" pattern="yyyy-MM-dd"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>--
            <input name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                   value="<fmt:formatDate value="${dogOwnerChange.endDate}" pattern="yyyy-MM-dd"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>血统证书号</th>
        <th>原犬主姓名</th>
        <th>新犬主姓名</th>
        <th>申请日期</th>
        <th>订单状态</th>
        <th>缴费时间</th>
        <th>审核状态</th>
        <th>审核日期</th>
        <th>审核人</th>
        <th>处理状态</th>
        <th>操作</th>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="dogOwnerChange">
        <tr>
            <td>
                    ${fns:escapeHtml(dogOwnerChange.dog.pedigreeCertifiedCode)}
            </td>
            <td style="color:#000" title="${fns:escapeHtml(dogOwnerChange.originOwnerMemberCode)}">
                    ${fns:escapeHtml(dogOwnerChange.originOwnerName)}
            </td>
            <td style="color:#000" title="${fns:escapeHtml(dogOwnerChange.newOwnerMemberCode)}">
                    ${fns:escapeHtml(dogOwnerChange.newOwnerName)}
            </td>
            <td>
                <fmt:formatDate value="${dogOwnerChange.createDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                <c:if test="${dogOwnerChange.paymentState==1}">
                    <c:if test="${not empty dogOwnerChange.newOwnerMemberId}">
                        <a onclick="util.pay('${dogOwnerChange.newOwnerMemberId}','sys_member@B','1','','${dogOwnerChange.originOwnerMemberCode}')">
                            <font color="red">新犬主会员费</font>
                        </a>
                    </c:if>
                    <c:if test="${empty dogOwnerChange.newOwnerMemberId}">
                        <a onclick="mergePayByOrder('${dogOwnerChange.id}','dog_owner_change','${dogOwnerChange.items}','${dogOwnerChange.originOwnerMemberCode}')">
                            <font color="red">${fns:getDictLabel(dogOwnerChange.paymentState, 'user_payment_state', '')}</font>
                        </a>
                    </c:if>
                </c:if>
                <c:if test="${dogOwnerChange.paymentState==2}">
                    <font color="green">${fns:getDictLabel(dogOwnerChange.paymentState, 'user_payment_state', '')}</font>
                </c:if>
            </td>
            <td>
                <fmt:formatDate value="${dogOwnerChange.paymentTime}" pattern="yyyy-MM-dd"/>
            </td>
            <td title="${fns:escapeHtml(dogOwnerChange.reviewRemarks) }">
                    ${fns:getDictLabel(dogOwnerChange.reviewState, 'review_state', '')}
            </td>
            <td>
                <fmt:formatDate value="${dogOwnerChange.reviewTime}" pattern="yyyy-MM-dd"/>
            </td>
            <td>
                    ${fns:escapeHtml(dogOwnerChange.reviewer) }
            </td>
            <td>
                    ${fns:getDictLabel(dogOwnerChange.processState, 'proccess_state', '')}
            </td>
            <td>
                <shiro:hasPermission name="catx:dogOwnerChange:delete">
                    <c:if test="${dogOwnerChange.paymentState==1}">
                        <a href="${ctx}/dogownerchange/dogOwnerChange/delete?id=${dogOwnerChange.id}"
                           onclick="return confirmx('确认要删除该犬主变更申请吗？', this.href)">删除</a>
                    </c:if>
                </shiro:hasPermission>
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>