<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>用户管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		function page(n,s){
			if(n) $("#pageNo").val(n);
			if(s) $("#pageSize").val(s);
			$("#searchForm").attr("action","${ctx}/sys/user/all");
			$("#searchForm").submit();
	    	return false;
	    }
		
		function delUser(userId){
			var html1 = '<div style="margin:10px 10px 0px 10px;min-height:30px;height:auto;padding-left:40px;text-align:left;">'+
						'<span class="jbox-icon jbox-icon-info" style="position: absolute; top: 55px; left: 15px; width: 32px; height: 32px;"></span>'+
						'<span style="font-size:14px;">请先确定<span style="color:#e45656;">是否已解绑账号绑定的会员及登录手机号？</span></span>'+
						'</div>'+
						'<div style="margin:0 10px 20px 10px;min-height:30px;height:auto;padding-left:40px;text-align:left;">'+
						'	<div>&nbsp;如未解绑直接删除账号,会导致登录账号绑定的手机号无法再次绑定</div>'+
						'	<div>&nbsp;如不确认是否已经解绑，请转到&nbsp;<a href="${ctx}/sys/user/member/bind">关联会员</a>&nbsp;功能确认</div>'+
						'</div>';
			var html2 = '<div style="margin:10px;min-height:30px;height:auto;padding-left:40px;text-align:left;">'+
						'<span class="jbox-icon jbox-icon-info" style="position: absolute; top: 55px; left: 15px; width: 32px; height: 32px;"></span>'+
						'<span style="font-size:14px;line-height: 25px;color:#303133;">确认要删除该用户吗？</span>'+
						'</div>';
			
			var states = {};
			states.state1 = {
			    content: html1,
			    buttons: { '确定已解绑': 1, '取消': 0 },
			    buttonsFocus: 0,
			    submit: function (v, h, f) {
			        if (v == 0) {
			            return true;
			        }
			        else {
			            $.jBox.nextState();
			        }
			        return false;
			    }
			};
			states.state2 = {
			    content: html2,
			    buttons: { '确定': 1, '取消': 0 },
			    buttonsFocus: 0,
			    submit: function (v, o, f) {
			        if (v == 0) {
			            return true;
			        }
			        else {
			        	layer.load();
			            window.location.href = "${ctx}/sys/user/delete?pageFlag=all&id="+userId;
			        }
			        return false;
			    }
			};
			$.jBox.open(states, '系统提示', 450, 'auto');
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/sys/user/all">用户列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="user" action="${ctx}/sys/user/all" method="post" class="breadcrumb form-search ">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<sys:tableSort id="orderBy" name="orderBy" value="${page.orderBy}" callback="page();"/>
		<ul class="ul-form">
			<li><label>登录名：</label><form:input path="loginName" htmlEscape="false" maxlength="50" class="input-medium"/></li>
			<li><label>姓&nbsp;&nbsp;&nbsp;名：</label><form:input path="name" htmlEscape="false" maxlength="50" class="input-medium"/></li>
			<li><label>邮箱：</label><form:input path="email" htmlEscape="false" maxlength="50" class="input-medium"/></li>
			<li><label>手机：</label><form:input path="mobile" htmlEscape="false" maxlength="50" class="input-medium"/></li>
			<li><label>身份：</label>
				<form:select path="userType" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('sys_user_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询" onclick="return page();"/>
				</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th class="sort-column login_name">登录名</th>
				<th class="sort-column name">姓名</th>
				<th>电话</th>
				<th>邮箱</th>
				<th>手机</th>
				<th>身份</th>
				<th>允许登录</th>
				<th>邮箱激活</th>
				<shiro:hasPermission name="sys:user:edit">
					<th>操作</th>
				</shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="user">
			<tr>
				<td><a href="${ctx}/sys/user/form?id=${user.id}">${user.loginName}</a></td>
				<td>${user.name}</td>
				<td>${user.phone}</td>
				<td>${user.email}</td>
				<td>${user.mobile}</td>
				<td>${fns:getDictLabels(user.userType, 'sys_user_type', '')}</td>
				<td>${fns:getDictLabels(user.loginFlag,'yes_no','')}</td>
				<td>${fns:getDictLabels(user.mailCheck,'yes_no','')}</td>
				<shiro:hasPermission name="sys:user:edit"><td>
    				<a href="${ctx}/sys/user/form?id=${user.id}">修改</a>
    				<a href="javascript:;" onclick="delUser('${user.id}');">删除</a>
					<%-- <a href="${ctx}/sys/user/delete?id=${user.id}" onclick="return confirmx('确认要删除该用户吗？', this.href)">删除</a> --%>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>