<%@ tag language="java" pageEncoding="UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<%@ attribute name="module" type="java.lang.String" required="true" description="文件上传之后的目录，会影响物理文件存储" %>
<%@ attribute name="maxCount" type="java.lang.Integer" required="false" description="限制文件上传的总数量 （默认 3 个）" %>
<%@ attribute name="maxSize" type="java.lang.Integer" required="false" description="限制文件的上传的总大小（单位 M 默认30M，例：100 ）" %>
<%@ attribute name="accept" type="java.lang.String" required="false" description="允许上传的文件格式，多个逗号分隔（默认 * ，例如：gif,jpg,jpeg,bmp,png）" %>
<%@ attribute name="duplicate" type="java.lang.Boolean" required="false" description="是否允许重复选择同一文件（默认 false ，例如：true）" %>
<%@ attribute name="multiple" type="java.lang.Boolean" required="false" description="是否可以多选（默认 true）" %>
<%@ attribute name="messageTime" type="java.lang.Integer" required="false" description="消息提示时间（单位毫秒，默认 2000 例：5000）" %>
<%@ attribute name="successHideFile" type="java.lang.Boolean" required="false" description="是否隐藏上传结果" %>
<%@ attribute name="successCallback" type="java.lang.String" required="false" description="文件上传成功的回调方法，有俩个参数(file,response),对应文件信息和服务器的反馈"%>
<!-- 处理非必填项默认值--开始-->
<c:set var="maxCountWrap" value="${empty maxCount ? 3 : maxCount}" scope="request"/>
<c:set var="maxSizeWrap" value="${empty maxSize ? 30 * 1024 * 1024 : maxSize * 1024 * 1024}" scope="request"/>
<c:set var="acceptWrap" value="${empty accept ? '*' : accept}" scope="request"/>
<c:set var="duplicateWrap" value="${empty duplicate ? false : duplicate}" scope="request"/>
<c:set var="multipleWrap" value="${empty multiple ? true : multiple}" scope="request"/>
<c:set var="messageTimeWrap" value="${empty messageTime ? 2000 : messageTime}" scope="request"/>
<c:set var="successHideFileWrap" value="${empty successHideFile ? false : successHideFile}" scope="request"/>
<c:set var="successCallbackWrap" value="${empty successCallback ? '' : successCallback}" scope="request"/>
<!-- 处理非必填项默认值--结束-->
<script type="text/javascript" src="${ctxStatic }/vue/vue.js"></script>
<script type="text/javascript" src="${ctxStatic }/webuploader/webuploader.js"></script>
<link rel="stylesheet" href="${ctxStatic }/webuploader/webuploader.oss.css"/>
<div id="uploader${module}" class="oss-upload">
	<span v-show="showMsg" :class="['message-box',msgBg]">{{msgText}}</span>
	<div class="loading">
		<div class="loading-icon"></div>
		<div class="loading-mask"></div>
	</div>
	<div class="btn-list">
		<div id="picker${module}" btntype="select" class="btn-eu btn-list-item btnlist-item-select">选择文件</div>
		<div @click="upload" v-show="fileList.length > 0" class="btn-eu btn-list-item btnlist-item-upload">上传<img src="${ctxStatic}/img/upload.png" class="ctlBtn-icon-right" /></div>
		<div @click="cancel" v-show="fileList.length > 0" class="btn-eu btn-list-item btnlist-item-cancel">终止<img src="${ctxStatic}/img/stop.png" class="ctlBtn-icon-right" style="width:12px;height:12px;" /></div>
	</div>
	<ul class="file-list" v-if="fileList.length > 0">
		<transition-group name="fade" tag="p">
		<li v-for="(fl, index) in fileList" v-bind:key="fl.id" v-show="fl.status != 'delete' && fl.display != 'none' " class="file-list-item" :fileid="fl.id">
			<div class="preview">
				<img v-show="fl.base64 != null" class="preview-img" :src="fl.base64" :alt="fl.name">
				<img v-show="fl.base64 == null" class="preview-div">
			</div>
			<div class="btn-file">
				<div btntype="delone" class="btn-eu btn-file-del" @click.stop="delfile(fl.id)" :fileid="fl.id">
					<span btntype="delone" class="btn-file-del-text" :fileid="fl.id">X</span>
				</div>
			</div>
			<div class="fileinfo">
				<p class="fileinfo-text">
					<span class="fileinfo-text-name" :title="fl.name"> <i class="fileinfo-text-size normalbg">{{fl.fileSize}}</i>{{fl.name}}</span>
					<span :class="['fileinfo-text-status',fl.statusTextColor]" :fileid="fl.id">{{fl.statusText}}</span>
				</p>
				<div class="fileinfo-progress">
					<div :class="['fileinfo-progress-bar',fl.statusBg]" :style="'width:'+ fl.progress" :fileid="fl.id"></div>
				</div>
			</div>
		</li>
		</transition-group>
	</ul>
</div>
<script type="text/javascript">
function render${module}(){
	var defaultConfig = {
		id:'uploader${module}',
		//swf文件路径
	    swf: '${ctxStatic}/webuploader/Uploader.swf',
	    //文件接收服务端。
	    server: '${fns:getOssEndpoint()}',
	    //选择文件的按钮。是否允许多选。
	    pick: {id:'#picker${module}',multiple: ${multipleWrap}},
	    //是否允许选择重复文件
	    duplicate: ${duplicateWrap},
	    //允许上传的文件类型
	    accept:{
	        extensions: "${acceptWrap}"
	    },
	    //文件的数量的限制
	    fileNumLimit: ${maxCountWrap},
	    //文件总大小的限制
    	fileSizeLimit: ${maxSizeWrap},
	    //不压缩image, 默认如果是jpeg，文件上传前会压缩一把再上传！
	    resize: false,
	    messageTime: ${messageTimeWrap}, //messageBox消息提示毫秒数，Number类型
	    statusText: {  //不同状态展示的提示文字，key为对应文件状态(不可修改)，value为展示文字
	        'inited': '等待上传',
	        'queued': '正在上传',
	        'progress': '0%',
	        'complete': '上传成功',
	        'error': '上传失败',
	        'interrupt': '上传中断',
	        'invalid': '文件无效',
	        'cancelled': '文件被移除'
	    },
	    statusTextColor: {  //不同状态'提示文字'标签的className，key为对应文件状态(不可修改)，value为标签的className
	    	'inited': 'normalcolor',
	        'queued': 'normalcolor',
	        'progress': 'normalcolor',
	        'complete': 'normalcolor',
	        'error': 'failedcolor',
	        'interrupt': 'warncolor',
	        'invalid': 'warncolor',
	        'cancelled': 'warncolor'
	    },
	    statusBg: {  //不同状态对应标签的className，key为对应文件状态(不可修改)，value为标签的className
	    	'inited': 'normalbg',
	        'queued': 'normalbg',
	        'progress': 'normalbg',
	        'complete': 'normalbg',
	        'error': 'failedbg',
	        'interrupt': 'warnbg',
	        'invalid': 'warnbg',
	        'cancelled': 'warnbg'
	    }
	};

	var userConfigs = Object.assign({},defaultConfig,{});
	var vmf = new Vue({
        el: '#uploader${module}',
        data: {
        	successHideFile:${successHideFileWrap},
        	messageTime: ${messageTimeWrap},
        	showMsg: false,
        	msgText: "",
        	msgBg: "",
        	fileUrls: {},
            fileList: []
        },
        methods: {
        	upload: function () {
        		var tvmf = this;
        		if(fileuploader.getFiles("inited","queued","progress","interrupt").length == 0){
        			tvmf.showMsg = true;
        			tvmf.msgText = "请选择要上传的文件!";
        			tvmf.msgBg = "warnbg";
	            	setTimeout(function(){
	            		tvmf.showMsg = false;
	            	},vmf.messageTime);
        		}else{
	        		fileuploader.upload();
        		}
            },
            cancel: function () {
            	fileuploader.stop(true);
            },
            delfile: function(fileId) {
            	$.jBox.confirm("确认要删除吗？","系统提示",function(v,h,f){
					if(v=="ok"){
		            	fileuploader.removeFile(fileId,true);
					}
				},{buttonsFocus:1});
				$('.jbox-body .jbox-icon').css('top','55px');
            },
            renderList: function(uself){
            	var _self = this;
            	var fileArr = uself.getFiles("inited","queued","progress","complete","error","interrupt","invalid");
                for (var i = 0; i < fileArr.length; i++) {
                	var fileStatus = fileArr[i].getStatus();
                	fileArr[i].status = fileStatus;
                	fileArr[i].statusTextColor = uself.configs.statusTextColor[fileStatus];
                	fileArr[i].statusBg = uself.configs.statusBg[fileStatus];
                	fileArr[i].statusText = uself.configs.statusText[fileStatus];
                	fileArr[i].fileSize = _self.bytesToSize(fileArr[i].size);
                }
                _self.fileList.splice(0,vmf.fileList.length);
                _self.fileList = fileArr;
            },
            bytesToSize: function(bytes) {
                if (bytes === 0) return '0 B';
                var k = 1024,
                sizes = ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'],
                i = Math.floor(Math.log(bytes) / Math.log(k));
                return (bytes / Math.pow(k, i)).toPrecision(3) + ' ' + sizes[i];
            }
        },
        mounted: function () {
        },
        updated: function () {
        }
    });
	
	var fileuploader = WebUploader.create(userConfigs);
	fileuploader.configs = userConfigs; 
	bindUploaderEvent${module}(fileuploader,vmf);
}

render${module}();

function bindUploaderEvent${module}(fileuploader,vmf){
	fileuploader.on('uploadBeforeSend', function (obj, data, headers) {
		$.ajax({  
	      	type : "POST",  
        	url : "${ctx}/sys/file/signature",  
	        data : {"module":"${module}","fileName":obj.file.name},
	        dataType:"JSON",
	        success : function(result) {
	        	vmf.fileUrls[obj.file.id] = "${fns:getOssEndpoint()}/" + result.dir;
	            data = $.extend(data,{
                    'key' : result.dir,//这里最好在后台处理好
                    'policy': result.policy,
                    'OSSAccessKeyId': result.accessid, 
                    'success_action_status' : '200', //让服务端返回200,不然，默认会返回204
                    //'callback' : result.callback,
                    'signature': result.signature,
                    'Content-Disposition':"attachment;filename="+obj.file.name
                });
	        },  
	        error : function(XMLHttpRequest, textStatus, errorThrown) {  
	        	$.jBox.alert("获取签名信息失败！");  
	        },  
	        async : false 
		});
	});
	
	//当有文件被添加进队列的时候
	fileuploader.on('fileQueued', function( file ) {
		file.base64 = null;
		fileuploader.makeThumb(file, function (error, src) {
		    if (!error) {
			    file.base64 = src;
		    }
		    file.progress = "0%";
		}, 300, 300);
	});
	
	//当有文件被添加进队列的时候
	fileuploader.on('filesQueued', function( files ) {
		setTimeout(function(){
			vmf.renderList(fileuploader,vmf);
		},100);
	});
	
	//文件上传的实时进度条
	fileuploader.on('uploadProgress', function( file, percentage ) {
	    file.progress = percentage * 100 + '%';
	    file.statusText = parseInt(percentage * 100) + '%';
	});
	
	//当文件被移除队列的时候
	fileuploader.on('fileDequeued', function( file ) {
	    file.status = 'delete';
	    delete vmf.fileUrls[file.id]; 
	});
	
	fileuploader.on('startUpload', function() {
		for(var idx in vmf.fileList){
			var f = vmf.fileList[idx];
			f.status = "queued";
			f.statusTextColor = fileuploader.configs.statusTextColor[f.status];
			f.statusText = fileuploader.configs.statusText[f.status];
			f.statusBg = fileuploader.configs.statusBg[f.status];
		}
	});
	
	fileuploader.on('stopUpload', function() {
		for(var idx in vmf.fileList){
			var f = vmf.fileList[idx];
			f.status = "interrupt";
			f.statusTextColor = fileuploader.configs.statusTextColor[f.status];
			f.statusText = fileuploader.configs.statusText[f.status];
			f.statusBg = fileuploader.configs.statusBg[f.status];
		}
	});
	
    fileuploader.onError = function( code ) {
    	vmf.showMsg = true;
    	if(code == "Q_EXCEED_NUM_LIMIT"){
    		vmf.msgText = "文件数量超出限制！";
    		vmf.msgBg = fileuploader.configs.statusBg['invalid'];
    	}else if(code == "Q_EXCEED_SIZE_LIMIT"){
    		vmf.msgText = "文件大小超出限制!";
    		vmf.msgBg = fileuploader.configs.statusBg['invalid'];
    	}else if(code == "Q_TYPE_DENIED"){
    		vmf.msgText = "文件类型错误！";
    		vmf.msgBg = fileuploader.configs.statusBg['invalid'];
    	}else if(code == "F_DUPLICATE"){
    		vmf.msgText = "不能重复添加文件!";
    		vmf.msgBg = fileuploader.configs.statusBg['invalid'];
        }else if(code == "F_EXCEED_SIZE"){
        	vmf.msgText = "文件已超出大小限制!";
    		vmf.msgBg = fileuploader.configs.statusBg['invalid'];
        }else{
        	vmf.msgText = "上传出错!";
    		vmf.msgBg = fileuploader.configs.statusBg['error'];
        }
    	setTimeout(function(){
    		vmf.showMsg = false;
    	},vmf.messageTime);
    };
	
	//上传成功
	fileuploader.on('uploadSuccess', function( file,response ) {
		file.status = file.getStatus();
		file.statusTextColor = fileuploader.configs.statusTextColor[file.getStatus()];
		file.statusText = fileuploader.configs.statusText[file.getStatus()];
		file.statusBg = fileuploader.configs.statusBg[file.getStatus()];
		if(vmf.successHideFile){
			file.display = 'none';
		}
	    if(typeof ${successCallback} === "function"){
	    	response.fileUrl = vmf.fileUrls[file.id]; 
	    	${successCallback}(file,response);
	    }
	    
	    file.on('statuschange', function( cur, prev ) {
	    	if(cur == "cancelled"){
				fileuploader.removeFile(file,true);
	    	}
	    });
	    
	});
	
	//上传失败
	fileuploader.on('uploadError', function( file ) {
		vmf.showMsg = true;
   		vmf.msgText = "上传出错！";
   		vmf.msgBg = fileuploader.configs.statusBg['error'];
   		file.status = "error";
		file.statusTextColor = fileuploader.configs.statusTextColor[file.status];
		file.statusText = fileuploader.configs.statusText[file.status];
		file.statusBg = fileuploader.configs.statusBg[file.status];
    	setTimeout(function(){
    		vmf.showMsg = false;
    	},vmf.messageTime);
	});
}

</script>