package com.ufida.api.vo;

import java.io.Serializable;
import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;

@JSONType(orders={"accounting_period","date","enter","fiscal_year","voucher_type","debit","credit"})
public class VoucherVo implements Serializable {
	
	private static final long serialVersionUID = -732793227870271285L;

	@JSONField(name = "accounting_period")
	//所属的会计期间，不填写取当前月份
	private Integer accountingPeriod;

	//制单日期
	@JSONField(format = "yyyy-MM-dd")
	private Date date;
	
	//制单人名称
	private String enter;
	
	//凭证所属的会计年度，不填写取当前年
	@JSONField(name = "fiscal_year")
	private Integer fiscalYear;
	
	//凭证类别
	@JSONField(name = "voucher_type")
	private String voucherType;
	
	//分录 借
	private DebitVo debit;
	
	//分录 贷
	private CreditVo credit;

	public Integer getAccountingPeriod() {
		return accountingPeriod;
	}

	public void setAccountingPeriod(Integer accountingPeriod) {
		this.accountingPeriod = accountingPeriod;
	}

	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	public String getEnter() {
		return enter;
	}

	public void setEnter(String enter) {
		this.enter = enter;
	}

	public Integer getFiscalYear() {
		return fiscalYear;
	}

	public void setFiscalYear(Integer fiscalYear) {
		this.fiscalYear = fiscalYear;
	}

	public String getVoucherType() {
		return voucherType;
	}

	public void setVoucherType(String voucherType) {
		this.voucherType = voucherType;
	}

	public DebitVo getDebit() {
		return debit;
	}

	public void setDebit(DebitVo debit) {
		this.debit = debit;
	}

	public CreditVo getCredit() {
		return credit;
	}

	public void setCredit(CreditVo credit) {
		this.credit = credit;
	}
	
}
