/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.subsystem.user;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ZAException;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.MemberUtil;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 犬舍基本信息Controller
 * @author fanhuibin
 * @version 2016-07-13
 */
@Controller
@RequestMapping(value = "/subSystem/kennel")
public class SubKennelController extends BaseController {

	@Autowired
	private KennelService kennelService;
	
	@Autowired
	private MemberService memberService;
	@Autowired
	private LoginServerService loginServerService;
	
	/**
	 * 查询当前登录人登录类型得到跳转路径头
	 * @return
	 * @author chaixueteng
	 */
	public String getUrlByUserType(){
		User loginUser = UserUtils.getLoginUser();
		return loginServerService.getShortNameByUserType(loginUser.getUserType());
	}
	@ModelAttribute
	public Kennel get(@RequestParam(required=false) String id) {
		Kennel entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = kennelService.get(id);
		}
		if (entity == null){
			entity = new Kennel();
		}
		return entity;
	}
	
	@RequestMapping(value = {"list", ""})
	public String list(Kennel kennel, HttpServletRequest request, HttpServletResponse response, Model model) {
		String name = kennel.getName();
		if (StringUtils.isNotBlank(name)) {
			String string = StringEscapeUtils.unescapeHtml4(name);
			kennel.setName(string);
		}
		String fciName = kennel.getFciName();
		if (StringUtils.isNotBlank(fciName)) {
			String string = StringEscapeUtils.unescapeHtml4(fciName);
			kennel.setFciName(string);
		}
		if("Fci".equals(kennel.getType())){//筛选条件为Fci犬舍
			model.addAttribute("tempFci", "Fci");
		}
		Page<Kennel> page = kennelService.findPage(new Page<Kennel>(request, response), kennel); 
		model.addAttribute("page", page);
		Calendar ca = Calendar.getInstance();//得到一个Calendar的实例  
		ca.setTime(new Date());   //设置时间为当前时间  
		ca.add(Calendar.DATE, -1); //日期减1
		Date date = ca.getTime();
		model.addAttribute("date", date);
		return "subSystem/"+getUrlByUserType()+"/kennel/kennelList";
	}
	
	

	@RequestMapping(value = "view")
	public String view(Kennel kennel, Model model) {			
		/*Member member = memberService.getByMemberCode(kennel.getMemberCode());
		kennel.setMember(member);*/
		model.addAttribute("date", new Date());
		model.addAttribute("kennel", kennel);
		/*if(kennel.getEndTime()==null || (kennel.getEndTime()==null && ))*/
		return "subSystem/"+getUrlByUserType()+"/kennel/kennelFormView";
	}	
	

	
}