package com.cku.restful.v1.sys.web;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.ListResultDto;
import com.cku.core.ResultDto;
import com.cku.restful.v1.sys.model.RestDict;
import com.thinkgem.jeesite.modules.sys.entity.Dict;
import com.thinkgem.jeesite.modules.sys.service.DictService;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 数据字典Controller
 *
 * @author zhangjunwu
 * @version 2020-09-01
 */
@Controller
@RequestMapping(value = "/api/v1/dict")
@Api(tags = "系统数据字典接口")
public class RestDictController extends BaseRestController {
	
	@Autowired
	private DictService dictService;
	
	@ResponseBody
	@GetMapping(value = "types/{type}")
	@ApiOperation("根据类型获取数据字典列表")
	public ListResultDto<RestDict> values(@PathVariable("type") String type) throws Exception {
		List<RestDict> resultList = new ArrayList<>();
		List<Dict> dictList = DictUtils.getDictList(type);
		if(Objects.nonNull(dictList) && !dictList.isEmpty()) {
			resultList = dictList.stream().map(dict->{
				return RestDict.builder()
						.type(dict.getType())
						.value(dict.getValue())
						.label(dict.getLabel())
						.description(dict.getDescription()).sort(dict.getSort())
						.remarks(dict.getRemarks())
						.build();
			}).collect(Collectors.toList());
		}
		return ListResultDto.success(resultList);
	}
	
	@ResponseBody
	@GetMapping(value = "types/{type}/values/{value}")
	@ApiOperation("根据类型及value，获取数据字典label")
	public ResultDto<RestDict> value(@PathVariable("type") String type,@PathVariable("value") String value) throws Exception {
		Dict dict = DictUtils.getDict(value, type, new Dict());
		RestDict result = RestDict.builder()
				.type(type)
				.value(value)
				.label(dict.getLabel())
				.description(dict.getDescription())
				.remarks(dict.getRemarks())
				.sort(dict.getSort())
				.build();
		return ResultDto.success(result);
	}

	
	@ResponseBody
	@PutMapping(value = "types/{type}/values/{value}/labels/{label}")
	@ApiOperation("根据字典type及value，修改数据字典label")
	public ResultDto<Boolean> editValue(@PathVariable("type") String type,@PathVariable("value") String value,@PathVariable("label") String label) throws Exception {
		Boolean result = Boolean.FALSE;
		//目前只对IOS，微信及苹果登录开关做控制 2020-10-23
		if("apple_approve_status".equals(type)) {
			Dict entity = DictUtils.getDict(value, type, null);
			if(!Objects.isNull(entity)) {
				//应IOS开发要求，此接口只将开关设置为FALSE 2020-10-23
				entity.setLabel(Boolean.FALSE.toString());
				try {
					dictService.save(entity);
					result = Boolean.TRUE;
				}catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		return ResultDto.success(result);
	}
	
}