package com.cku.restful.v1.sys.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.ListResultDto;
import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.coupon.service.SysCouponService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.sys.model.CouponTypeResponse;
import com.cku.restful.v1.sys.model.RestCoupon;
import com.cku.restful.v1.sys.model.RestCouponComposeList;
import com.cku.restful.v1.sys.model.RestCouponComposePost;
import com.cku.restful.v1.sys.model.RestCouponComposePostResponse;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Controller
@RequestMapping(value = "/api/v1/coupon")
public class RestCouponController extends BaseRestController {
	@Autowired
	private SysCouponService sysCouponService;
	@Autowired
	private KennelService kennelService;
	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;

	/**
	 * @description: 根据当前登录人获取优惠劵列表
	 * @author: chaixueteng
	 * @date: 2018/4/12 14:12
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ResponseBody
	public void list(HttpServletRequest request, HttpServletResponse response) throws IOException {
		Member member = UserUtils.getLoginMember();
		String state = request.getParameter("state");
		String couponName = request.getParameter("couponName");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		String couponType = request.getParameter("couponType");
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (org.apache.commons.lang.StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (org.apache.commons.lang.StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}
		SysCoupon example = new SysCoupon();
		// 设置分页参数
		Page<SysCoupon> page = new Page<SysCoupon>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		if (StringUtils.isNotBlank(couponName)) {
			example.setCouponName(couponName);
		}
		example.setState(state);
		example.setCouponTypeApp(couponType);
		example.setOrderByStr("app"); // app端优惠包需要折叠
		// example.setGroupByStr("app");
		example.setMemberCode(member.getMemberCode());
		Page<SysCoupon> result = sysCouponService.findPage(page, example);
		List<SysCoupon> couponsList = result.getList();
		List<RestCoupon> list = new ArrayList<RestCoupon>();
		for (SysCoupon coupon : couponsList) {
			coupon.setState(state);
			Integer expireNum = sysCouponService.findExpireNum(coupon);
			RestCoupon vo = new RestCoupon();
			BeanUtil.copyProperties(vo, coupon, "yyyy-MM-dd");
			
			vo.setExpireNum(expireNum);
			// 不显示过期的合作机构
			if (coupon.getUseState().equals("1")) {
				vo.setState("已用");
			} else {
				if (StringUtils.isNotBlank(vo.getValidDate())
						&& DateUtils.isAfterMounth(new Date(), vo.getValidDate(), Boolean.FALSE)) {
					vo.setState("过期");
				} else {
					vo.setState("有效");
				}
			}
			if ("CAC赛事免费参赛券".equals(coupon.getCouponName())||"CAC犬展免费参展券".equals(coupon.getCouponName())) {
				vo.setFacePrice("150/280");
			}
			String couponTypeDesc = "";
			if ("1".equals(coupon.getCouponType())) {
				couponTypeDesc = "代金券";
			}
			if ("2".equals(coupon.getCouponType())) {
				couponTypeDesc = "抵扣券";
			}
			if ("3".equals(coupon.getCouponType())) {
				couponTypeDesc = "参展券";
			}
			if ("4".equals(coupon.getCouponType())) {
				couponTypeDesc = "满减券";
			}
			String business = "";
			if ("dogBirthCertificate".equals(coupon.getTarget())) {
				business = "dogBirthCertificate";
			}
			if ("dogChipApply".equals(coupon.getTarget())) {
				business = "dogChipApply";
			}
			if ("dogChip".equals(coupon.getTarget())) {
				business = "show";
			}
			
			vo.setBusiness(business);
			vo.setCouponTypeDesc(couponTypeDesc);
			list.add(vo);
		}
		long count = result.getCount();
		ServletUtils.writeResponse(response, new RESTResponse("list", new PageBeanResult<RestCoupon>(list, count)));
	}

	/**
	 * @description: 根据当前登录人获取可用的优惠劵
	 * @author: chaixueteng
	 * @date: 2018/4/12 14:12
	 */
	@RequestMapping(value = "/getCoupon", method = RequestMethod.GET)
	@ResponseBody
	public void getCoupon(HttpServletRequest request, HttpServletResponse response) throws IOException {
		// 新增标记参数
		String type = request.getParameter("type");

		Map<String, String> map = new HashMap<>();
		map.put("couponCount", "0");
		map.put("couponOnePrice", "0");
		Member member = UserUtils.getLoginMember();
		// 查询是否可用优惠劵 犬舍保留期内申请的大于等于5张有效出生纸起
		Kennel k = kennelService.getKennelByMemberCode(member.getMemberCode());
		if (k != null/* &&k.getCalculationDate()!=null */) {// 犬舍必须是有核算日期的

			/*
			 * Calendar calendar = Calendar.getInstance();//日历对象
			 * calendar.setTime(k.getCalculationDate());//设置当前日期 calendar.add(Calendar.YEAR,
			 * -1);//年份-1 calendar.set(Calendar.HOUR_OF_DAY, 0);//时
			 * calendar.set(Calendar.MINUTE, 0);//分 calendar.set(Calendar.SECOND, 0);//秒 int
			 * birthCount=dogBirthCertificateService.getKennelBirth(calendar.getTime(),k.
			 * getCalculationDate(),member.getMemberCode());
			 */
			/* if(birthCount>=5){ */// 犬舍保留期内申请的出生纸数符合条件
			/*
			 * 2019-02-21 15:40 将出生纸抵扣券的使用门槛（原来为申请的第六张出生纸可使用此券）删除，变为随时可用此优惠券 zhangxiang
			 */
			SysCoupon sysCoupon = new SysCoupon();
			sysCoupon.setMemberCode(member.getMemberCode());
			sysCoupon.setState("0");// 可用的
			List<SysCoupon> sList = sysCouponService.findCouponListByTarget(member.getMemberCode(), "0", type);
			if (sList.size() > 0) {
				map.put("couponCount", String.valueOf(sList.size()));
				map.put("couponOnePrice", sList.get(0).getFacePrice());
			}
			/* } */
		}
		ServletUtils.writeResponse(response, new RESTResponse("data", map));
	}

	@ApiOperation(value = "优惠包-列表", tags = { "coupon-compose-zxy" })
	@RequestMapping(value = "/compose/list", method = RequestMethod.GET)
	@ResponseBody
	public ResultDto<RestCouponComposeList> composeList(
			@ApiParam(name = "composeType", value = "优惠包类型 certificate血统证书 register登记卡", required = true) @RequestParam String composeType,
			HttpServletRequest request, HttpServletResponse response) throws IOException {
		return sysCouponService.composeList(composeType);
	}

	@ApiOperation(value = "优惠包-下单页", tags = { "coupon-compose-zxy" })
	@RequestMapping(value = "/compose/post", method = RequestMethod.POST)
	@ResponseBody
	public ResultDto<RestCouponComposePostResponse> composePost(@Valid @RequestBody RestCouponComposePost vo,
			HttpServletRequest request, HttpServletResponse response) throws IOException {
		return sysCouponService.composePost(vo);
	}

	@ApiOperation(value = "优惠券类型", tags = { "coupon-zxy" })
	@RequestMapping(value = "/couponType", method = RequestMethod.GET)
	@ResponseBody
	public ListResultDto<CouponTypeResponse> couponType(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		return sysCouponService.getCouponType();
	}

}
