/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.shop.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.oa.shop.entity.ShopGoodsClass;
import com.cku.oa.shop.service.ShopGoodsClassService;
import com.cku.restful.v1.shop.model.RestShopGoodsClass;
import com.cku.restful.v1.sys.utils.BeanUtil;

/**
 * 商品类别Service
 * 
 * @author lyy
 * @version 2016-08-11
 */
@Service
@Transactional(readOnly = true)
public class RestShopGoodsClassService {

	@Autowired
	private ShopGoodsClassService shopGoodsClassService;

	public RESTResponse getList() {
		// 查询并组装返回对象
		List<ShopGoodsClass> shopGoodsClassList = shopGoodsClassService
				.findAllList(new ShopGoodsClass());
		List<RestShopGoodsClass> list = new ArrayList<RestShopGoodsClass>();
		for (ShopGoodsClass shopGoodsClass : shopGoodsClassList) {
			RestShopGoodsClass vo = new RestShopGoodsClass();
			BeanUtil.copyProperties(vo, shopGoodsClass, "yyyy-MM-dd");
			list.add(vo);
		}
		long count = shopGoodsClassList.size();
		return new RESTResponse("list", new PageBeanResult<RestShopGoodsClass>(
				list, count));
	}
}