/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.shop.model;

import java.util.List;

import net.sf.json.JSONArray;

import org.hibernate.validator.constraints.Length;

import com.cku.oa.shop.dao.ShopGoodsDao;
import com.cku.oa.shop.entity.ShopGoods;
import com.cku.oa.shop.entity.ShopOrderDetail;
import com.cku.restful.v1.sys.utils.BeanUtil;

/**
 * 商城订单Entity
 * 
 * @author lyy
 * @version 2016-08-12
 */
public class RestShopOrder {
	private String id;
	private String state; // 订单状态
	private String num; // 总量
	private String price; // 总价String
	private String memberCode; // 会员号
	private String memberName; // 会员名称
	private String type; // 订单类型
	private String channel; // 销售渠道
	private String channelName; // 渠道名称
	private String channelType; // 渠道类型
	private String shopOrderCode; // 订单编号
	private String postType; // 邮寄方式
	private String postName; // 收货人
	private String postDel; // 收货人电话
	private String postCode; // 邮政编码
	private String postPrice; // 邮费
	private String postOrderNo; // 邮寄单号
	private String address; // 收货地址
	private String message; // 买家留言
	private String orderDate; // 下单时间
	private String isSend; // 是否发货
	private String sendDate; // 发货时间
	private String returnDate; // 退回时间
	private String isReturn; // 是否退货
	private String sendPostType; // 发送时方式
	private String sendPostOrderNo; // 发送时方式
	private String paymentDate; // 付款时间
	private String paymentWay; // 支付方式
	private String paymentState; // 支付状态
	private JSONArray orderDetailList = new JSONArray(); // 商品详细
	// 接收参数
	private String province; // 新增地址省
	private String city; // 新增地址市
	private String isNewAddress; // 是否是新地址
	private String userAddressId; // 默认地址id

	private String isOrg; // 是否是机构
	private String beginOrderDate; // 下单时间
	private String endOrderDate; //

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@Length(min = 0, max = 10, message = "订单状态长度必须介于 0 和 10 之间")
	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getPrice() {
		return price;
	}

	public void setPrice(String price) {
		this.price = price;
	}

	public String getNum() {
		return num;
	}

	public void setNum(String num) {
		this.num = num;
	}

	@Length(min = 0, max = 64, message = "会员号长度必须介于 0 和 64 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 0, max = 64, message = "会员名称长度必须介于 0 和 64 之间")
	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}

	@Length(min = 0, max = 10, message = "订单类型长度必须介于 0 和 10 之间")
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	@Length(min = 0, max = 64, message = "销售渠道长度必须介于 0 和 64 之间")
	public String getChannel() {
		return channel;
	}

	public void setChannel(String channel) {
		this.channel = channel;
	}

	public String getChannelName() {
		return channelName;
	}

	public void setChannelName(String channelName) {
		this.channelName = channelName;
	}

	public String getChannelType() {
		return channelType;
	}

	public void setChannelType(String channelType) {
		this.channelType = channelType;
	}

	@Length(min = 0, max = 20, message = "订单类型长度必须介于 0 和 20 之间")
	public String getPostType() {
		return postType;
	}

	public void setPostType(String postType) {
		this.postType = postType;
	}

	@Length(min = 0, max = 64, message = "订单编号长度必须介于 0 和 64 之间")
	public String getShopOrderCode() {
		return shopOrderCode;
	}

	public void setShopOrderCode(String shopOrderCode) {
		this.shopOrderCode = shopOrderCode;
	}

	@Length(min = 0, max = 200, message = "收货地址长度必须介于 0 和 200 之间")
	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	@Length(min = 0, max = 255, message = "买家留言长度必须介于 0 和 255 之间")
	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public String getOrderDate() {
		return orderDate;
	}

	public void setOrderDate(String orderDate) {
		this.orderDate = orderDate;
	}

	public String getBeginOrderDate() {
		return beginOrderDate;
	}

	public void setBeginOrderDate(String beginOrderDate) {
		this.beginOrderDate = beginOrderDate;
	}

	public String getEndOrderDate() {
		return endOrderDate;
	}

	public void setEndOrderDate(String endOrderDate) {
		this.endOrderDate = endOrderDate;
	}

	public String getSendDate() {
		return sendDate;
	}

	public void setSendDate(String sendDate) {
		this.sendDate = sendDate;
	}

	public String getReturnDate() {
		return returnDate;
	}

	public void setReturnDate(String returnDate) {
		this.returnDate = returnDate;
	}

	public String getIsSend() {
		return isSend;
	}

	public void setIsSend(String isSend) {
		this.isSend = isSend;
	}

	public String getPaymentDate() {
		return paymentDate;
	}

	public void setPaymentDate(String paymentDate) {
		this.paymentDate = paymentDate;
	}

	@Length(min = 0, max = 10, message = "支付方式长度必须介于 0 和 10 之间")
	public String getPaymentWay() {
		return paymentWay;
	}

	public void setPaymentWay(String paymentWay) {
		this.paymentWay = paymentWay;
	}

	@Length(min = 0, max = 10, message = "支付状态长度必须介于 0 和 10 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	public JSONArray getOrderDetailList() {
		return orderDetailList;
	}

	public void setOrderDetailList(List<ShopOrderDetail> orderDetailList,ShopGoodsDao shopGoodsDao) {
		for (ShopOrderDetail shopOrderDetail : orderDetailList) {
			RestShopOrderDetail restShopOrderDetail = new RestShopOrderDetail();
			BeanUtil.copyProperties(restShopOrderDetail, shopOrderDetail,
					"yyyy-MM-dd HH:mm:ss");
			ShopGoods shopGoods = shopGoodsDao.get(shopOrderDetail.getGoodsId());
			restShopOrderDetail.setImage(shopGoods.getImage());
			this.orderDetailList.add(restShopOrderDetail);
		}
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getIsNewAddress() {
		return isNewAddress;
	}

	public void setIsNewAddress(String isNewAddress) {
		this.isNewAddress = isNewAddress;
	}

	public String getUserAddressId() {
		return userAddressId;
	}

	public void setUserAddressId(String userAddressId) {
		this.userAddressId = userAddressId;
	}

	@Length(min = 0, max = 50, message = "收件人长度必须介于 0 和 50 之间")
	public String getPostName() {
		return postName;
	}

	public void setPostName(String postName) {
		this.postName = postName;
	}

	@Length(min = 0, max = 20, message = "联系电话长度必须介于 0 和 20 之间")
	public String getPostDel() {
		return postDel;
	}

	public void setPostDel(String postDel) {
		this.postDel = postDel;
	}

	@Length(min = 0, max = 10, message = "邮编长度必须介于 0 和 10 之间")
	public String getPostCode() {
		return postCode;
	}

	public void setPostCode(String postCode) {
		this.postCode = postCode;
	}

	public String getPostPrice() {
		return postPrice;
	}

	public void setPostPrice(String postPrice) {
		this.postPrice = postPrice;
	}

	@Length(min = 0, max = 100, message = "邮寄单号必须介于 0 和 100 之间")
	public String getPostOrderNo() {
		return postOrderNo;
	}

	public void setPostOrderNo(String postOrderNo) {
		this.postOrderNo = postOrderNo;
	}

	@Length(min = 0, max = 2, message = "是否退货长度必须介于 0 和 2 之间")
	public String getIsReturn() {
		return isReturn;
	}

	public void setIsReturn(String isReturn) {
		this.isReturn = isReturn;
	}

	@Length(min = 0, max = 20, message = "发送方式长度必须介于 0 和 20 之间")
	public String getSendPostType() {
		return sendPostType;
	}

	public void setSendPostType(String sendPostType) {
		this.sendPostType = sendPostType;
	}

	@Length(min = 0, max = 100, message = "发送邮寄单号长度必须介于 0 和 100 之间")
	public String getSendPostOrderNo() {
		return sendPostOrderNo;
	}

	public void setSendPostOrderNo(String sendPostOrderNo) {
		this.sendPostOrderNo = sendPostOrderNo;
	}

	@Length(min = 0, max = 2, message = "是否是机构长度必须介于 0 和 2 之间")
	public String getIsOrg() {
		return isOrg;
	}

	public void setIsOrg(String isOrg) {
		this.isOrg = isOrg;
	}
}