package com.cku.restful.v1.kennel.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.cku.core.RESTResponse;
import com.cku.core.ResultDto;
import com.cku.restful.v1.kennel.model.RestKennelOwnerChangeMoney;
import com.cku.restful.v1.kennel.service.RestKennelOwnerChangeService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponses;

@RestController
@RequestMapping("/api/v1/ownerChange")
public class RestKennelOwnerChangeController extends BaseRestController{

	@Autowired
	private RestKennelOwnerChangeService restKennelOwnerChangeService;

	@GetMapping("/check")
	@ApiOperation(value = "犬舍所有人变更验证", tags = "繁育-犬舍所有人变更")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({})
	public void check(HttpServletRequest request, HttpServletResponse response) throws Exception {
		RESTResponse result = restKennelOwnerChangeService.check();
		ServletUtils.writeResponse(response, result);
	}

	@GetMapping("/{memberCode}")
	@ApiOperation(value = "犬舍所有人变更查询", tags = "繁育-犬舍所有人变更")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	public void getOwnerChange(@PathVariable String memberCode, HttpServletResponse response) throws Exception {
		RESTResponse result = restKennelOwnerChangeService.getOwnerChange(memberCode);
		ServletUtils.writeResponse(response, result);
	}

	@GetMapping("/{memberCode}/{mobile}")
	@ApiOperation(value = "获取变更授权验证码", tags = "繁育-犬舍所有人变更")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	public void getOwnerChangeCode(@PathVariable String memberCode, @PathVariable String mobile,
		HttpServletResponse response) throws Exception {
		RESTResponse result = restKennelOwnerChangeService.getOwnerChangeCode(memberCode, mobile);
		ServletUtils.writeResponse(response, result);
	}

//    @GetMapping("/detail")
//    @ApiOperation(value = "确认信息页",tags = "繁育-犬舍所有人变更")
//    @ApiImplicitParams({@ApiImplicitParam(name = "memberCode",value = "memberCode",dataType = "query"),
//            @ApiImplicitParam(name = "smsCode",value = "smsCode",dataType = "query"),
//            @ApiImplicitParam(name = "token", paramType = "query", value = "token")})
//    public void getKennelDetail(@RequestParam("memberCode") String memberCode,@RequestParam("smsCode") String smsCode, HttpServletResponse response) throws Exception {
//        RESTResponse result = restKennelOwnerChangeService.getKennelDetail(memberCode,smsCode);
//        ServletUtils.writeResponse(response,result);
//    }

	@PostMapping("/{memberCode}/{smsCode}")
	@ApiOperation(value = "加入购物车", tags = "繁育-犬舍所有人变更")
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ResponseBody
	public ResultDto<RestKennelOwnerChangeMoney> post(@PathVariable String memberCode, @PathVariable String smsCode,
			HttpServletResponse response) throws Exception {
		return ResultDto.success(restKennelOwnerChangeService.post(memberCode, smsCode));
	}

}
