package com.cku.restful.v1.groomer.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.cku.cab.editor.ckuhotel.entity.AppCkuHotel;
import com.cku.cab.editor.ckuhotel.entity.CkuHotel;
import com.cku.cab.editor.ckuhotel.service.CkuHotelService;
import com.cku.cab.editor.handlervenue.entity.AppHandlerVenue;
import com.cku.cab.editor.handlervenue.entity.HandlerVenue;
import com.cku.cab.editor.handlervenue.service.HandlerVenueService;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.handler.dao.HandlerDiplomaDao;
import com.cku.oa.handler.dao.HandlerRegisterDao;
import com.cku.oa.handler.entity.APPHandlerRegister;
import com.cku.oa.handler.entity.AppHandlerShow;
import com.cku.oa.handler.entity.AppHandlerShowDetail;
import com.cku.oa.handler.entity.HandlerDiploma;
import com.cku.oa.handler.entity.HandlerQualificationCertificate;
import com.cku.oa.handler.entity.HandlerRegister;
import com.cku.oa.handler.entity.HandlerShow;
import com.cku.oa.handler.service.HandlerDiplomaService;
import com.cku.oa.handler.service.HandlerQualificationCertificateService;
import com.cku.oa.handler.service.HandlerRegisterService;
import com.cku.oa.handler.service.HandlerShowService;
import com.cku.oa.show.entity.AppShowJudge;
import com.cku.oa.show.entity.ShowJudge;
import com.cku.oa.show.service.ShowJudgeService;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.entity.user.CardTypeEnum;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.FileService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.ImgUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONObject;

/**
 * 训犬师活动报名Service
 *
 * @author zhangxiang
 * @version 2020-10-16
 */
@Service
public class AppHandlerShowService {

	private static final String PAYMENTCHARGINGITEM_SHORTNAME_CHANSHAI = "handler_register@canshai";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_A = "handler_register@kaoshi_a";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_B = "handler_register@kaoshi_b";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_C = "handler_register@kaoshi_c";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_M = "handler_register@kaoshi_master";


	@Autowired
	HandlerShowService handlerShowService;

	@Autowired
	private ShowJudgeService showJudgeService;

	@Autowired
	private HandlerRegisterService handlerRegisterService;

	@Autowired
	private HandlerDiplomaService handlerDiplomaService;

	@Autowired
	private HandlerDiplomaDao handlerDiplomaDao;

	@Autowired
	private FileService fileService;

	@Autowired
	private HandlerRegisterDao handlerRegisterDao;

	@Autowired
	private HandlerVenueService handlerVenueService;

	@Autowired
	private CkuHotelService ckuHotelService;

	@Autowired
	private HandlerQualificationCertificateService handlerQualificationCertificateService;

	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private PaymentCartService paymentCartService;
	@Autowired
	private MemberService memberService;

	public RESTResponse getCourseShowList(HttpServletRequest request, HttpServletResponse response) {
		HandlerShow handlerShow = new HandlerShow();
		//查询一年内
		handlerShow.setOneYear(true);
		String canRegister = request.getParameter("canRegister");
		if(StringUtils.isNotBlank(canRegister) && Boolean.valueOf(canRegister)) {
			handlerShow.setRegisterEndTime(new Date());
		}
		Page<HandlerShow> page = handlerShowService.findListApp(new Page<>(request, response), handlerShow);
		List<AppHandlerShow> collect = page.getList().stream().map(data -> {
			AppHandlerShow appHandlerShow = new AppHandlerShow();
			BeanUtils.copyProperties(data, appHandlerShow);
			//是否可以报名
			if(data.getRegisterEndTime().getTime()>new Date().getTime()){
				appHandlerShow.setFlag(true);
			}
			if(StringUtils.isNotBlank(data.getRegisterImage())){
				appHandlerShow.setRegisterImage(ImgUtil.getImgUrl(request, data.getRegisterImage()));
			}
			//活动头图
			if(StringUtils.isNotBlank(data.getShowPhoto())){
				String path = request.getContextPath();
				String imgPath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/api/v1/file/image/"+data.getShowPhoto();
				appHandlerShow.setShowPhoto(imgPath);
			}
			String shortName = "";
			if("5".equals(data.getShowType())){
				appHandlerShow.setShowType("训犬师考试");
				if("MASTER".equals(data.getTestLevel())){
					shortName = PAYMENTCHARGINGITEM_SHORTNAME_M;
				}
				if("A".equals(data.getTestLevel())){
					shortName = PAYMENTCHARGINGITEM_SHORTNAME_A;
				}
				if("B".equals(data.getTestLevel())){
					shortName = PAYMENTCHARGINGITEM_SHORTNAME_B;
				}
				if("C".equals(data.getTestLevel())){
					shortName = PAYMENTCHARGINGITEM_SHORTNAME_C;
				}
            }
			if("6".equals(data.getShowType())){
				appHandlerShow.setShowType("训犬师比赛");
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_CHANSHAI;
            }
			appHandlerShow.setShortName(shortName);
			SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm");
			appHandlerShow.setStartTime(sd.format(data.getStartTime()));
			appHandlerShow.setEndTime(sd.format(data.getEndTime()));
			appHandlerShow.setRegisterEndTime(sd.format(data.getRegisterEndTime()));
			//活动名称地址转成unicode编码
			appHandlerShow.setShowName(StringEscapeUtils.unescapeHtml4(appHandlerShow.getShowName()));
			appHandlerShow.setShowAddress(StringEscapeUtils.unescapeHtml4(appHandlerShow.getShowAddress()));
			return appHandlerShow;
		}).collect(Collectors.toList());
		return new RESTResponse("data", collect);
	}

	public RESTResponse getCourseShowListDetail(HttpServletRequest request, HttpServletResponse response) {
		//活动id
		String id = request.getParameter("id");
		HandlerShow data = handlerShowService.get(id);
		AppHandlerShowDetail appHandlerShowDetail = new AppHandlerShowDetail();
		List<AppShowJudge> appShowJudges = new ArrayList<>();
		if(data!=null){
			BeanUtils.copyProperties(data, appHandlerShowDetail);
			//是否可以报名
			if(data.getRegisterEndTime().getTime()>new Date().getTime()){
				appHandlerShowDetail.setFlag(true);
			}
			if("5".equals(data.getShowType())){
				appHandlerShowDetail.setShowType("训犬师考试");
			}
			if("6".equals(data.getShowType())){
				appHandlerShowDetail.setShowType("训犬师比赛");
			}
			//审查员
			String referee = data.getReferee();
			if(StringUtils.isNotBlank(referee)){
				String[] split = referee.split(",");
				for(int i=0;i<split.length;i++){
					ShowJudge showJudge = showJudgeService.get(split[i]);
					if(showJudge!=null){
						AppShowJudge appShowJudge = new AppShowJudge();
						BeanUtils.copyProperties(showJudge, appShowJudge);
						if(StringUtils.isNotBlank(appShowJudge.getJudgePicture())){
							String path = request.getContextPath();
							String imgPath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/api/v1/open/image/" + appShowJudge.getJudgePicture();
							appShowJudge.setJudgePicture(imgPath);
						}
						appShowJudges.add(appShowJudge);
					}
				}
			}
			appHandlerShowDetail.setAppShowJudges(appShowJudges);
			//酒店
			if(StringUtils.isNotBlank(data.getHotelId())){
				CkuHotel ckuHotel = ckuHotelService.get(data.getHotelId());
				if(ckuHotel!=null){
					AppCkuHotel appCkuHotel = new AppCkuHotel();
					BeanUtils.copyProperties(ckuHotel, appCkuHotel);
					appHandlerShowDetail.setAppCkuHotel(appCkuHotel);
				}
			}
			//场馆
			if(StringUtils.isNotBlank(data.getVenueId())){
				HandlerVenue handlerVenue = handlerVenueService.get(data.getVenueId());
				if(handlerVenue!=null){
					AppHandlerVenue appHandlerVenue = new AppHandlerVenue();
					BeanUtils.copyProperties(handlerVenue, appHandlerVenue);
					appHandlerShowDetail.setAppHandlerVenue(appHandlerVenue);
				}
			}
			SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			appHandlerShowDetail.setStartTime(sd.format(data.getStartTime()));
			appHandlerShowDetail.setEndTime(sd.format(data.getEndTime()));
			appHandlerShowDetail.setRegisterEndTime(sd.format(data.getRegisterEndTime()));
		}
		return new RESTResponse("data", appHandlerShowDetail);
	}
	public RESTResponse getHandlerRegisterList(HttpServletRequest request, HttpServletResponse response) {
		Member loginMember = UserUtils.getLoginMember();
		HandlerRegister handlerRegister = new HandlerRegister();
		handlerRegister.setMemberCode(loginMember.getMemberCode());
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
		List<APPHandlerRegister> collect = handlerRegisterService.findListApp(new Page<>(request, response), handlerRegister).getList().stream().map(data -> {
			APPHandlerRegister appHandlerRegister = new APPHandlerRegister();
			appHandlerRegister.setCreateDate(simpleDateFormat.format(data.getCreateDate()));
			appHandlerRegister.setId(data.getId());
			appHandlerRegister.setReviewState(data.getReviewState());
			appHandlerRegister.setShowName(StringEscapeUtils.unescapeHtml4(data.getHandlerShow().getShowName()));
			appHandlerRegister.setShowType(data.getHandlerShow().getShowType());
			String shortName = "";
			if("5".equals(data.getHandlerShow().getShowType())){
				appHandlerRegister.setShowType("训犬师考试");
				if("MASTER".equals(data.getShowLevel())){
					shortName = PAYMENTCHARGINGITEM_SHORTNAME_M;
				}
				if("A".equals(data.getShowLevel())){
					shortName = PAYMENTCHARGINGITEM_SHORTNAME_A;
				}
				if("B".equals(data.getShowLevel())){
					shortName = PAYMENTCHARGINGITEM_SHORTNAME_B;
				}
				if("C".equals(data.getShowLevel())){
					shortName = PAYMENTCHARGINGITEM_SHORTNAME_C;
				}
			}
			if("6".equals(data.getHandlerShow().getShowType())){
				appHandlerRegister.setShowType("训犬师比赛");
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_CHANSHAI;
			}
			appHandlerRegister.setShortName(shortName);
			appHandlerRegister.setReviewRemarks(data.getReviewRemarks());
			appHandlerRegister.setShowLevel(data.getShowLevel());
			appHandlerRegister.setShowCode(data.getShowCode());
            appHandlerRegister.setAvatar(data.getAvatar());
            appHandlerRegister.setAnyBreed(data.getAnyBreed());
            appHandlerRegister.setSchoolNameCn(data.getSchoolNameCn());
            HandlerQualificationCertificate hqc = handlerQualificationCertificateService
                    .getRegister(handlerRegister.getId());
			return appHandlerRegister;
		}).collect(Collectors.toList());
		return new RESTResponse("data", collect);
	}

	public RESTResponse checkHandlerRegister(HttpServletRequest request, HttpServletResponse response) {

		Member loginMember = UserUtils.getLoginMember();
		//活动id
		String id = request.getParameter("id");
		HandlerShow handlerShow = handlerShowService.get(id);
		check(handlerShow,loginMember);

		return new RESTResponse();
	}

	public void check(HandlerShow handlerShow,Member loginMember){
		HandlerRegister example = new HandlerRegister();
		example.setMemberCode(loginMember.getMemberCode());
		example.setShowCode(handlerShow.getShowCode());
		List<HandlerRegister> list = handlerRegisterService.findList(example);

		if (list.size() != 0) {
			String paymentState = list.get(0).getPaymentState();
			if ("2".equals(paymentState)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请勿重复报名");
			} else {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您有当前活动未缴费订单，请先去支付");
			}
		}

		//是否可以报名
		if (new Date().getTime() >  handlerShow.getRegisterEndTime().getTime() ) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "活动报名已截止");
		}
		//判断是否有有训犬师结业证书
		HandlerDiploma handlerDiploma = new HandlerDiploma();
		handlerDiploma.setMemberCode(loginMember.getMemberCode());
		List<HandlerDiploma> trainList = handlerDiplomaDao.findTrainList(handlerDiploma);
		//报名等级需要满足C-B-A-教师逐级递增
		List<String> stringList = new ArrayList<>();

		trainList.stream().forEach(data -> {
			if (StringUtils.isNotBlank(data.getCertificateLevel()) && StringUtils.isNotBlank(data.getCertificateCode())) {
				stringList.add(data.getCertificateLevel().trim());
			}
		});

		//比赛银卡会员
		if("6".equals(handlerShow.getShowType())){
			//CKU宠爱银卡及以上会员才可以办理！
			if (CardTypeEnum.DEFAULT_CARD.code() == UserUtils.getMemberCardType(loginMember)){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "CKU宠爱银卡及以上会员才可以办理！");
			}
		}else{
			//CKU宠爱银卡及以上会员才可以办理！
			if (CardTypeEnum.DEFAULT_CARD.code() == UserUtils.getMemberCardType(loginMember)){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "CKU宠爱银卡及以上会员才可以办理！");
			}
			//没有结业证书无法报名c级别考试
			if("C".equals(handlerShow.getTestLevel())){
				if(stringList.contains("嗅闻犬训练师")
						|| stringList.contains("家庭犬训练师")
						|| stringList.contains("敏捷犬训练师")
						|| stringList.contains("犬行为训练师")
						|| stringList.contains("飞盘犬训练师")
						|| stringList.contains("飞球犬训练师")){
				}else{
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您没有参加过相关培训课程，没有证书无法报名！");
				}
			}else{
				if(stringList.contains("嗅闻犬训练师")
						|| stringList.contains("家庭犬训练师")
						|| stringList.contains("敏捷犬训练师")
						|| stringList.contains("犬行为训练师")
						|| stringList.contains("飞盘犬训练师")
						|| stringList.contains("飞球犬训练师")){

					//报名登记需满足C-B-A-教师级逐级递增
					HandlerQualificationCertificate handlerQualificationCertificate = new HandlerQualificationCertificate();
					handlerQualificationCertificate.setMemberCode(loginMember.getMemberCode());
					if("B".equals(handlerShow.getTestLevel())){
						handlerQualificationCertificate.setCertificateLevelEn("C");
						List<HandlerQualificationCertificate> certificateList = handlerQualificationCertificateService.findList(handlerQualificationCertificate);
						if(certificateList.size()<=0){
							throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您还没获得资格考试报名条件，无法报名");
						}
					}

					if("A".equals(handlerShow.getTestLevel())){
						handlerQualificationCertificate.setCertificateLevelEn("B");
						List<HandlerQualificationCertificate> certificateList = handlerQualificationCertificateService.findList(handlerQualificationCertificate);
						if(certificateList.size()<=0){
							throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您还没获得资格考试报名条件，无法报名");
						}
					}

					if("MASTER".equals(handlerShow.getTestLevel())){
						handlerQualificationCertificate.setCertificateLevelEn("A");
						List<HandlerQualificationCertificate> certificateList = handlerQualificationCertificateService.findList(handlerQualificationCertificate);
						if(certificateList.size()<=0){
							throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您还没获得资格考试报名条件，无法报名");
						}
					}
				}else{
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您没有参加过相关培训课程，没有证书无法报名！");
				}



			}
		}
	}


	public RESTResponse confirmHandlerRegister(String json, HttpServletResponse response) {
		Member loginMember = UserUtils.getLoginMember();
		//活动id
		JSONObject object = JSONObject.fromObject(json);
		String id = object.getString("id");
		JSONObject jsonObject = JSONObject.fromObject(json);
		HandlerShow handlerShow = handlerShowService.get(id);

		HandlerRegister vo = new HandlerRegister();
		// 参数校验
		validateParameter(vo, object,handlerShow);
		//业务校验
		check(handlerShow,loginMember);
		//同步修改头像
		memberService.updateAvatar(vo.getAvatar(), loginMember.getId());
		//初始化
//		HandlerRegister po = buildPo(vo,handlerShow);
		// 构造持久对象
		HandlerRegister handlerRegister = buildPo(vo,handlerShow);
		//保存业务
		handlerRegisterService.save(handlerRegister);
		//加入购物车
		PaymentCart paymentCart = buildPaymentCart(handlerRegister,handlerShow);
		paymentCartService.addToCart(paymentCart, "1052");
		return new RESTResponse("data",paymentCart.getId());
	}

	public HandlerRegister buildPo(HandlerRegister po,HandlerShow handlerShow){
		Member member = UserUtils.getLoginMember();
		String shortName = "";
		if("5".equals(handlerShow.getShowType())){
			//训犬师考试
			//shortName = PAYMENTCHARGINGITEM_SHORTNAME_KAOSHI;
			if("MASTER".equals(handlerShow.getTestLevel())){
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_M;
			}
			if("A".equals(handlerShow.getTestLevel())){
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_A;
			}
			if("B".equals(handlerShow.getTestLevel())){
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_B;
			}
			if("C".equals(handlerShow.getTestLevel())){
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_C;
			}
		}
		if("6".equals(handlerShow.getShowType())){
			//训犬师比赛
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_CHANSHAI;
		}
		if (StringUtils.isBlank(shortName)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "收费项为空！");
		}
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(shortName);
		if(null == paymentChargingItem){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "收费项为空！");
		}
		po.setRegisterCode(SysCodeUtil.getHandlerActivitySignCode("WB"));
		po.setMemberCode(member.getMemberCode());
		po.setName(member.getName());
		po.setGender(member.getGender());
		po.setMobile(member.getMobile());
		po.setFee(handlerShow.getFee());
		po.setShowLeave("0");
		po.setLeaveCancel("0");
		po.setOrderPrice(handlerShow.getFee());
		po.setPaymentMemberCode(member.getMemberCode());
		po.setPaymentItemId(paymentChargingItem.getId());
		po.setReviewState("0");
		po.setPaymentState("1");
		po.setProccessState("0");
		po.setShowCode(handlerShow.getShowCode());

		return po;
	}

	private PaymentCart buildPaymentCart(HandlerRegister po,HandlerShow handlerShow) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.get(po.getPaymentItemId());
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(handlerShow.getFee());
		paymentCart.setTotalPrice(handlerShow.getFee());
		paymentCart.setBusinessTable("handler_register");
		paymentCart.setBusinessIds(po.getId());
		return paymentCart;
	}

	public void validateParameter(HandlerRegister vo,JSONObject object,HandlerShow handlerShow){
		//证件照并更新会员证件照
		String avatar = object.getString("avatar");
		if(StringUtils.isBlank(avatar)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "证件照不能为空！");
		}
		vo.setAvatar(avatar);
		//会员
		Member loginMember = UserUtils.getLoginMember();
		vo.setMember(loginMember);
		//级别
		String testLevel = handlerShow.getTestLevel();
		if(StringUtils.isBlank(testLevel)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "级别不能为空！");
		}
		vo.setShowLevel(testLevel);
		//裁判
		String referee = handlerShow.getReferee();
		if(StringUtils.isBlank(referee)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "裁判不能为空！");
		}
		vo.setReferee(referee);
		//犬种
		String anyBreed = object.getString("anyBreed");
		if(StringUtils.isBlank(anyBreed)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬种不能为空！");
		}
		vo.setAnyBreed(anyBreed);
		//机构
		String schoolNameCn = object.getString("schoolNameCn");
		if(StringUtils.isBlank(schoolNameCn)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "机构不能为空！");
		}
		vo.setSchoolNameCn(schoolNameCn);
	}

}