package com.cku.restful.v1.finance.web;

import com.cku.config.WxPayConfig;
import com.cku.core.RESTResponse;
import com.cku.oa.activity.entity.SysMemberActivityRecord;
import com.cku.oa.activity.service.SysMemberActivityRecordService;
import com.cku.oa.buying.dao.BuyingOrderDao;
import com.cku.oa.buying.entity.BuyingOrder;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.shop.entity.ShopOrder;
import com.cku.oa.shop.service.ShopOrderService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.buying.service.RestBuyingService;
import com.cku.restful.v1.finance.entity.RestPaymentOrder;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.cku.restful.v1.shop.model.RestShopOrder;
import com.cku.restful.v1.show.service.RestShowApplyService;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.github.wxpay.sdk.WXPay;
import com.github.wxpay.sdk.WXPayConstants.SignType;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping(value = "/api/v1/finance")
public class RestOrderController extends BaseRestController {
	@Autowired
	RestOrderService restOrderService;
	@Autowired
	PaymentOrderService paymentOrderService;
	@Autowired
	ShopOrderService shopOrderService;
	@Autowired
	RestBuyingService restBuyingService;
	@Autowired
	RestShowApplyService restShowApplyService;
	@Autowired
	BuyingOrderDao BuyingOrderDao;
	@Autowired
	SysMemberActivityRecordService sysMemberActivityRecordService;
	@Autowired
	private WxPayConfig wxPayConfig;

	protected Logger logger = LoggerFactory.getLogger(getClass());

	
	@RequestMapping(value = "/order", method = RequestMethod.GET)
	@ResponseBody
	public void getOrder(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restOrderService.findByPage(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 提交订单
	 * 
	 * @param json
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@ApiOperation(value = "下单", tags = { "通用支付" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{\r\n" + "    \"rc\": 0,\r\n" + "    \"msg\": \"OK\",\r\n"
			+ "    \"data\": {\r\n" + "        \"id\": \"e36310e9d00e4708a15c1575ce8c4cb7\"\r\n" + "    }\r\n" + "}") })
	@RequestMapping(value = "/order", method = RequestMethod.POST)
	@ResponseBody
	public void cartToOrder(@ApiParam(name = "json", value = "{\r\n" + "	\"del\": \"13333333333\",\r\n"
			+ "	\"receiverAddress\": \"漷县镇侯黄庄村606号海润犬舍\",\r\n"
			+ "	\"carts\": [\"6b7e3bdad8e34da8ab52bc2bb02c0bf9\",\"f3406b92e4f740e78e11fb9f8e44de16\"],\r\n"
			+ "	\"receiver\": \"刘载春\",\r\n" +  "	\"postcode\": \"101112\",\r\n" + "	\"receiverCity\": \"北京市\",\r\n"
			+ "	\"receiverProvince\": \"北京市\"\r\n" + "}") @RequestBody String json, HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		JSONArray carts = object.getJSONArray("carts");
		Member member = UserUtils.getLoginMember();
		Object[] ids = carts.toArray();
		PaymentOrder order = new PaymentOrder();
		order.setReceiveProvince(object.getString("receiverProvince"));
		order.setReceiveCity(object.getString("receiverCity"));
		if (object.get("receiverArea") == null) {
			order.setReceiveArea("");
		} else {
			order.setReceiveArea(object.get("receiverArea").toString());
		}
		order.setReceiveAddress(object.getString("receiverAddress"));
		String postcode = (String) object.get("postcode");
		order.setReceivePostCode(postcode);
		order.setReceiveDel(object.getString("del"));
		order.setReceiver(object.getString("receiver"));
		order.setMemberCode(member.getMemberCode());
		order.setMemberName(member.getName());
		// 如果使用优惠券，减去相应的金额
		String couponId = null;
		if (object.get("couponId") != null) {
			couponId = object.getString("couponId");
		}
		String id = restOrderService.cartToOrder(ids, order, couponId);
		 
		JSONObject jo = new JSONObject();
		jo.put("id", id);
		ServletUtils.writeResponse(response, new RESTResponse("data", jo));
	}

	@RequestMapping(value = "/order/{id}", method = RequestMethod.DELETE)
	@ResponseBody
	public void deleteOrder(@PathVariable String id, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		PaymentOrder order = new PaymentOrder();
		order.setId(id);
		paymentOrderService.removeOrder(order);
		RESTResponse result = new RESTResponse();
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/order/{id}", method = RequestMethod.GET)
	@ResponseBody
	public void getOrderById(@PathVariable String id, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		PaymentOrder order = new PaymentOrder();
		order.setId(id);
		order = paymentOrderService.get(order);

		RestPaymentOrder restOrder = new RestPaymentOrder();
		BeanUtil.copyProperties(restOrder, order, "yyyy-MM-dd");
		// 判断是否是赛事
		if (restShowApplyService.isShowApplyOrder(order)) {
			restOrder.setIsMatch("1");
		}
		;
		// fanhuibin 这段的代码是抢购的代码，抢购已经下线，不需要了。
		// List list = restBuyingService.findForRunningNumber(order.getOrderCode());
		// if(list!=null && list.size()>0){
		// restOrder.setIsBuying("1");
		// }
		// chaixueteng CKU广告位抢购
		List<BuyingOrder> list = BuyingOrderDao.findForRunningNumber(order.getOrderCode());
		if (list != null && list.size() > 0) {
			restOrder.setIsBuying("1");
		}
		RESTResponse result = new RESTResponse("data", JSONObject.fromObject(restOrder));
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/orderGift/{id}", method = RequestMethod.GET)
	@ResponseBody
	public void getGiveGiftFlag(@PathVariable String id, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		Member member = UserUtils.getLoginMember();
		PaymentOrder paymentOrder = paymentOrderService.get(id);
		boolean giveGiftFlag = false;
		if (paymentOrder != null && StringUtils.isNotBlank(paymentOrder.getOrderCode())) {
			SysMemberActivityRecord record = new SysMemberActivityRecord();
			record.setMemeberCode(member.getMemberCode());
			record.setOrderCode(paymentOrder.getOrderCode());
			record.setGiveGift("1");
			record = sysMemberActivityRecordService.getOneEntity(record);
			giveGiftFlag = (record == null ? Boolean.FALSE : Boolean.TRUE);
		}
		RESTResponse result = new RESTResponse("data", giveGiftFlag);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/shoporder/{id}", method = RequestMethod.GET)
	@ResponseBody
	public void getShopOrderById(@PathVariable String id, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		ShopOrder order = new ShopOrder();
		order.setId(id);
		order = shopOrderService.get(order);
		RestShopOrder restOrder = new RestShopOrder();
		BeanUtil.copyProperties(restOrder, order, "yyyy-MM-dd");
		RESTResponse result = new RESTResponse("data", JSONObject.fromObject(restOrder));
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/orderCount", method = RequestMethod.GET)
	@ResponseBody
	public void orderCount(HttpServletResponse response) throws IOException {
		RESTResponse result = restOrderService.orderCount();
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：根据订单id
	 * @author: zhuoHeng
	 * @version: 2016年12月23日 下午5:02:33
	 */
	@RequestMapping(value = "/order/cab", method = RequestMethod.GET)
	@ResponseBody
	public void getOrderById(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String orderId = request.getParameter("orderId");
		PaymentOrder order = new PaymentOrder();
		order.setId(orderId);
		order = paymentOrderService.get(order);
		if ("1".equals(order.getPaymentState())) {
			Map<String, String> weixinResponse = this.queryOrderStatus(orderId);
			if (weixinResponse != null) {
				order.setPaymentState("2");
				order.setTransactionId(weixinResponse.get("transaction_id"));
			}
		}
		RestPaymentOrder restOrder = new RestPaymentOrder();
		BeanUtil.copyProperties(restOrder, order, "yyyy-MM-dd");
		RESTResponse result = new RESTResponse("data", JSONObject.fromObject(restOrder));
		ServletUtils.writeResponse(response, result);

	}

	public Map<String, String> queryOrderStatus(String orderId) {
		Map<String, String> reqData = new HashMap<>();
		reqData.put("out_trade_no", orderId);
		Map<String, String> weixinResponse;
		try {
			weixinResponse = new WXPay(wxPayConfig, SignType.MD5).orderQuery(reqData);
			if (!("SUCCESS".equals(weixinResponse.get("return_code"))
					&& "SUCCESS".equals(weixinResponse.get("result_code"))
					&& "SUCCESS".equals(weixinResponse.get("trade_state")))) {
				return null;
			}
		} catch (Exception e) {
			return null;
		}

		return weixinResponse;
	}

	/**
	 *
	 * @Description：根据id取消订单（宠爱王国使用） @author: zhuoHeng
	 * @version: 2016年12月28日 下午3:27:21
	 */
	@RequestMapping(value = "/order/cab", method = RequestMethod.DELETE)
	@ResponseBody
	public void deleteOrderById(HttpServletRequest request, HttpServletResponse response) throws IOException {
		// 这里获取member，如果token失效，会抛出-30，用户信息验证失败的异常
        Member member =  UserUtils.getLoginMember();
		String id = request.getParameter("id");
		PaymentOrder order = new PaymentOrder();
		order.setId(id);
		paymentOrderService.removeOrder(order);
		RESTResponse result = new RESTResponse();
		ServletUtils.writeResponse(response, result);
	}
}
