/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.dog.service.RestDogColorMarkService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

/**
 * 犬只颜色及标志Controller
 *
 * @author lgl
 * @version 2016-08-05
 */
@Controller
@RequestMapping(value = "/api/v1/dog")
public class RestDogColorMarkController extends BaseRestController {

	@Autowired
	private RestDogColorMarkService restDogColorMarkService;

	/**
	 *
	 * @description: 根据犬种获取毛色列表
	 * @author: laiguanglong
	 * @date: 2016年9月7日 下午5:07:39
	 */
	@RequestMapping(value = "/dogcolormark/{dogBreed}")
	@ResponseBody
	public void getByDogBreedCode(@PathVariable("dogBreed") String dogBreed,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restDogColorMarkService.getList(dogBreed);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：根据犬种获取毛色列表（因宠爱王国访问需验证token参数，此接口使用如下方式获取毛色列表）
	 * @author: zhuoHeng
	 * @version: 2016年11月9日 下午5:11:27
	 */
	@RequestMapping(value = "/dogcolormark/getColormark", method = RequestMethod.GET)
	@ResponseBody
	public void dogcolormark(HttpServletRequest request,HttpServletResponse response) throws IOException {
		String dogBreed = request.getParameter("dogBreed");
		RESTResponse result = restDogColorMarkService.getList(dogBreed);
		ServletUtils.writeResponse(response, result);
	}
}