package com.cku.restful.v1.dog.service;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogColorMarkDao;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogColorMark;
import com.cku.oa.dog.entity.DogStickerApply;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogStickerApplyService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
@Transactional(readOnly = true)
public class RestDogStickerApplyService {

    private static final String PAYMENTCHARGINGITEM_STICKER = "dog_sticker_apply@0";
    private static final String PAYMENTCHARGINGITEM_STICKER_PASSPORT = "dog_sticker_apply@1";

    @Autowired
    DogDao dogDao;
    @Autowired
    DogBirthCertificateDao dogBirthCertificateDao;
    @Autowired
    DogColorMarkDao dogColorMarkDao;
    @Autowired
    DogTypeService dogTypeService;
    @Autowired
    DogStickerApplyService dogStickerApplyService;
    @Autowired
    PaymentCartService paymentCartService;
    @Autowired
    PaymentChargingItemService paymentChargingItemService;
    @Autowired
    MemberService memberService;
    public RESTResponse get(String id) {
        DogStickerApply po = dogStickerApplyService.get(id);
        if (po == null) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
        }
        if (!po.getPaymentMemberCode().equals(UserUtils.getLoginMember().getMemberCode())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
        }
        JSONObject data = new JSONObject();
        data.put("id", getString(po.getId()));
        data.put("identificationFlag", getString(po.getIdentificationFlag()));
        data.put("nameEn", getString(po.getNameEn()));
        data.put("breedCnName", dogTypeService.getBreedCnName(po.getDogBreed()));
        data.put("gender", DictUtils.getDictLabel(po.getDogGender(), "dog_gender", ""));
        data.put("applyClass", dogStickerApplyService.getStickerClass(po.getApplyClass()));
        data.put("createDate", DateFormatUtils.format(po.getCreateDate(), "yyyy-MM-dd"));
        data.put("businessState", dogStickerApplyService.getBusinessStates(po));
        String birthdate = "";
        String colorFlag = "";
        Dog dog = dogDao.getNewOneByIdentificationFlag(po.getIdentificationFlag());
        if (dog != null) {
            birthdate = DateFormatUtils.format(dog.getBirthdate(), "yyyy-MM-dd");
            colorFlag = dog.getColorFlag();
            DogColorMark dogColorMark = dogColorMarkDao.getByDogColorMarkCode(dog.getColorFlag());
            if (dogColorMark != null) {
                colorFlag = dogColorMark.getDogColorMarkCn();
            }
        } else {
            DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByIdentificationFlag(po.getIdentificationFlag());
            birthdate = DateFormatUtils.format(dogBirthCertificate.getDogBirthday(), "yyyy-MM-dd");
            colorFlag = dogBirthCertificate.getColorFlag();
            DogColorMark dogColorMark = dogColorMarkDao.getByDogColorMarkCode(dogBirthCertificate.getColorFlag());
            if (dogColorMark != null) {
                colorFlag = dogColorMark.getDogColorMarkCn();
            }
        }
        data.put("birthdate", birthdate);
        data.put("colorFlag", colorFlag);
        return new RESTResponse("data", data);
    }

    public RESTResponse getList(HttpServletRequest request) {
        // 获取参数
        String pageNo = request.getParameter("pageNo");
        String pageSize = request.getParameter("pageSize");
        // 参数校验
        int pageNoInt = 1;
        int pageSizeInt = 10;
        try {
            if (StringUtils.isNotBlank(pageNo)) {
                pageNoInt = Integer.parseInt(pageNo);
            }
            if (StringUtils.isNotBlank(pageSize)) {
                pageSizeInt = Integer.parseInt(pageSize);
            }
        } catch (Exception e) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
                    "pageNo和pageSize必须都为数字");
        }
        DogStickerApply example = new DogStickerApply();
        example.setPaymentMemberCode(UserUtils.getLoginMember().getMemberCode());
        String identificationFlagAndPedigreeCertifiedLike = request.getParameter("identificationFlagAndPedigreeCertifiedLike");
        if (StringUtils.isNotBlank(identificationFlagAndPedigreeCertifiedLike)) {
            example.setIdentificationFlagAndPedigreeCertifiedLike(identificationFlagAndPedigreeCertifiedLike);
        }
        // 设置分页参数
        Page<DogStickerApply> page = new Page<>();
        page.setPageNo(pageNoInt);
        page.setPageSize(pageSizeInt);
        // 查询并组装返回对象
        Page<DogStickerApply> result = dogStickerApplyService.findPage(page, example);
        List<DogStickerApply> dogStickerApplyList = result.getList();
        List<JSONObject> list = new ArrayList<>();
        for (DogStickerApply po : dogStickerApplyList) {
            JSONObject vo = new JSONObject();
            vo.put("id", getString(po.getId()));
            vo.put("identificationFlag", getString(po.getIdentificationFlag()));
            vo.put("pedigreeCertified", getString(po.getPedigreeCertified()));
            vo.put("cabPassport", getString(po.getCabPassport()));
            vo.put("alreadyHaveClass", dogStickerApplyService.getStickerClass(po.getAlreadyHaveClass()));
            vo.put("createDate", DateFormatUtils.format(po.getCreateDate(), "yyyy-MM-dd"));
            vo.put("applyClass", dogStickerApplyService.getStickerClass(po.getApplyClass()));
            vo.put("businessState", dogStickerApplyService.getBusinessStates(po));
            list.add(vo);
        }
        long count = result.getCount();

        return new RESTResponse("list", new PageBeanResult<>(list, count));
    }

    public RESTResponse checkByKey(HttpServletRequest request) {
        String key = request.getParameter("key");
        if (StringUtils.isBlank(key)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请输入血统证书号或芯片号");
        }
        DogBirthCertificate dogBirthCertificate = null;
        Dog dog = dogDao.getByPedigreeCertifiedCode(key);
        if (dog == null) {
            dog = dogDao.getNewOneByIdentificationFlag(key);
            if (dog == null) {
                dogBirthCertificate = dogBirthCertificateDao.getByIdentificationFlag(key);
                if (dogBirthCertificate == null) {
                    throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请输入正确的血统证书号或芯片号");
                } else {
                    throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "优宠级（E）贴纸单独申请渠道暂未开放，开放时间请关注官网通知。您可在申请血统证书时完成宠爱护照及等级申请。");
                }
            }
        }
        return new RESTResponse("data", buildJo(dog, dogBirthCertificate));
    }

    private JSONObject buildJo(Dog dog, DogBirthCertificate dogBirthCertificate) {
        JSONObject jo = new JSONObject();
        String identificationFlag;
        String dogBreed;
        String gender;
        Date dogBirthday;
        String colorFlag;
        String cabPassport;
        String pedigreeCertifiedCode;
        if (dog != null) {
            //单独申请血统证书号必须CKU前缀
            if (!dog.getPedigreeCertifiedCode().toUpperCase().startsWith("CKU")) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "等级贴纸单独申请,仅限血统证书以CKU开头的犬只申请");
            }
            identificationFlag = dog.getIdentificationFlag();
            jo.put("nameEn", dog.getNameEn());
            dogBreed = dog.getDogBreed();
            gender = dog.getGender();
            dogBirthday = dog.getBirthdate();
            colorFlag = dog.getColorFlag();
            cabPassport = dog.getCabPassport();
            pedigreeCertifiedCode = dog.getPedigreeCertifiedCode();
            jo.put("applyClass", dogStickerApplyService.getStickerClass(dogStickerApplyService.getApplyClass(dog)));
        } else {
            identificationFlag = dogBirthCertificate.getIdentificationFlag();
            jo.put("nameEn", dogBirthCertificate.getDogEnName());
            dogBreed = dogBirthCertificate.getDogBreed();
            gender = dogBirthCertificate.getDogGender();
            dogBirthday = dogBirthCertificate.getDogBirthday();
            colorFlag = dogBirthCertificate.getColorFlag();
            cabPassport = dogBirthCertificate.getCabPassport();
            pedigreeCertifiedCode =dogBirthCertificate.getPedigreeCertified();
            jo.put("applyClass", dogStickerApplyService.getStickerClass(dogStickerApplyService.getApplyClass(dogBirthCertificate)));
        }
        // 构造持久对象
        DogStickerApply po = null;
        User user = UserUtils.getUser();
        //判断是后台用户还是会员用户
        if(user!=null && StringUtils.isNotBlank(user.getUserType()) && user.getUserType().equals("1")){
            Member member = null;
            //获取会员信息
            if(dog!=null){
                member = memberService.getByMemberCode(dog.getMemberCode());
            }else{
                member = memberService.getByMemberCode(dogBirthCertificate.getMemberCode());
            }
            po = dogStickerApplyService.buildPo(identificationFlag, member);
        }else{
            po = dogStickerApplyService.buildPo(identificationFlag, UserUtils.getLoginMember());
        }

        // 业务校验
        dogStickerApplyService.validateBusiness(po);
        jo.put("identificationFlag", identificationFlag);
        jo.put("breedCnName", dogTypeService.getBreedCnName(dogBreed));
        jo.put("gender", DictUtils.getDictLabel(gender, "dog_gender", ""));
        jo.put("birthdate", DateFormatUtils.format(dogBirthday, "yyyy-MM-dd"));
        DogColorMark dogColorMark = dogColorMarkDao.getByDogColorMarkCode(colorFlag);
        if (dogColorMark != null) {
            colorFlag = dogColorMark.getDogColorMarkCn();
        }
        jo.put("colorFlag", colorFlag);
        jo.put("cabPassport", cabPassport);
        jo.put("price", getPaymentChargingItem(cabPassport).getPrice());
        jo.put("needReturnOldPassport", po.getNeedReturnOldPassport());
        jo.put("pedigreeCertifiedCode",pedigreeCertifiedCode);
        return jo;
    }

    @Transactional(readOnly = false)
    public RESTResponse post(String json) {
        // 获取参数
        JSONObject jo = JSONObject.fromObject(json);
        // 参数校验
        if (!jo.containsKey("identificationFlag") || StringUtils.isBlank(jo.getString("identificationFlag"))) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号为空");
        }
        String cartIds = applyDogSticker(jo.getString("identificationFlag"));
        JSONObject data = new JSONObject();
        data.put("cartIds", cartIds);
        return new RESTResponse("data", data);
    }

    public String applyDogSticker(String identificationFlag) {
        // 构造持久对象
        DogStickerApply po = dogStickerApplyService.buildPo(identificationFlag, UserUtils.getLoginMember());
        // 业务校验
        dogStickerApplyService.validateBusiness(po);
        // 写入业务表
        dogStickerApplyService.save(po);
        // 写入购物车
        PaymentCart paymentCart = buildPaymentCart(po);
        paymentCartService.addToCart(paymentCart,"1001");
        return paymentCart.getId();
    }

    private PaymentCart buildPaymentCart(DogStickerApply po) {
        PaymentCart paymentCart = new PaymentCart();
        PaymentChargingItem paymentChargingItem = getPaymentChargingItem(po.getCabPassport());
        paymentCart.setChargingItemId(paymentChargingItem.getId());
        paymentCart.setChargingItemName(paymentChargingItem.getName());
        paymentCart.setNum("1");
        paymentCart.setPrice(paymentChargingItem.getPrice());
        paymentCart.setTotalPrice(paymentChargingItem.getPrice());
        paymentCart.setBusinessTable("dog_sticker_apply");
        paymentCart.setBusinessIds(po.getId());
        return paymentCart;
    }

    private PaymentChargingItem getPaymentChargingItem(String cabPassport) {
        String shortName = PAYMENTCHARGINGITEM_STICKER_PASSPORT;
        //有护照无论新旧都免费
        //以是否有护照号来判断有没有护照
        if (StringUtils.isNotBlank(cabPassport) || new Date().getTime()>= DogBirthCertificateService.ACTICATION_OFF_MILLS) {
            shortName = PAYMENTCHARGINGITEM_STICKER;
        }
        return paymentChargingItemService.getByShortName(shortName);
    }

    private String getString(String str) {
        return str == null ? "" : str;
    }

}
