package com.cku.restful.v1.breeder.model;

/**
 * Created by lyyz on 2019/3/13.
 */
public interface IEnumDogBirthCertificate {

    /***
     * 幼犬筛选状态
     */
    enum EnumDogType {
        /**
         * 所有
         */
        All(0, "所有"),
        /**
         * 未上架
         */
        NotOnShelves(1, "未上架"),
        /**
         * 待审核
         */
        ToBeAudited(2, "待审核"),

        /**
         * 审核失败
         */
        AuditFailure(3, "审核失败"),

        /**
         * 已上架
         */
        OnShelves(4, "已上架"),

        /**
         * 已下架
         */
        OffShelf(5, "已下架");


        private int value;
        private String lable;


        public void setValue(int value) {
            this.value = value;
        }

        public String getLable() {
            return lable;
        }

        public void setLable(String lable) {
            this.lable = lable;
        }

        public int getValue() {
            return value;
        }

        EnumDogType(int value, String lable) {
            this.value = value;
            this.lable = lable;
        }

        public static boolean isInEnum(Integer value) {

            for (EnumDogType gender : EnumDogType.values()) {
                if (gender.getValue() == value)
                    return true;
            }
            return false;
        }

    }

    /**
     * 性別
     */
    enum EnumGender {
        ALL(0, "所有"),
        KESHANGMEN(1, "男孩"),
        PEIGUO(2, "女孩");

        private int value;
        private String lable;


        public void setValue(int value) {
            this.value = value;
        }

        public String getLable() {
            return lable;
        }

        public void setLable(String lable) {
            this.lable = lable;
        }

        public int getValue() {
            return value;
        }

        EnumGender(int value, String lable) {
            this.value = value;
            this.lable = lable;
        }

        public static boolean isInEnum(Integer value) {

            for (EnumGender gender : EnumGender.values()) {
                if (gender.getValue() == value)
                    return true;
            }
            return false;
        }
    }
}
