package com.cku.restful.v1.banner.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.PageResultDto;
import com.cku.oa.banner.service.AppBannerService;
import com.cku.restful.v1.banner.vo.RestBannerListRequest;
import com.cku.restful.v1.banner.vo.RestBannerListResponse;
import com.cku.restful.v1.sys.web.BaseRestController;

import io.swagger.annotations.ApiOperation;

@Controller
@RequestMapping(value = "/api/v1/open/banner")
public class RestAppBannerController extends BaseRestController {

	@Autowired
	private AppBannerService appBannerService;

	@ApiOperation(value = "犬舍-列表", tags = { "app-banner广告-zxy" })
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ResponseBody
	public PageResultDto<RestBannerListResponse> getList(@Valid  RestBannerListRequest vo, HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		return appBannerService.list(vo , request , response );
	}
	

}
