package com.cku.partner.club.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogChipDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.dog.service.DogChipService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.finance.dao.PaymentCartDao;
import com.cku.oa.finance.dao.PaymentChargingItemDao;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.dao.PaymentRecordDao;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.entity.PaymentRecord;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemGroupService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.finance.service.PaymentRecordService;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.coupon.service.SysCouponService;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.SysOrgPrint;
import com.cku.oa.sys.entity.user.KennelType;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.entity.user.MemberCardTypeEnum;
import com.cku.oa.sys.service.OrgService;
import com.cku.oa.sys.service.SysOrgPrintService;
import com.cku.oa.sys.service.user.MemberActivity20201212Discount;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.cku.restful.v1.sys.service.RestMemberService;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * user chaixueteng 2016年10月17日
 */
@Service
@Transactional(readOnly = true)
public class PaymentService {

	public static final String MEMER_BASIC = "sys_member@B";// 基础会员费
	public static final String MEMBER_PROFESSIONAL_FIRST = "sys_member@F";// 专业会员的新注册费
	public static final String MEMBER_PROFESSIONAL = "sys_member@P";// 专业会员费
	public static final String MEMBER_PROFESSIONAL_BREED = "sys_member@PB";// 繁育专业会员登记费
	public static final String MEMBER_PROFESSIONAL_BREED_FIRST = "sys_member@PBF";// 繁育专业会员的新注册费

	public static final String KENNEL_FEE_FIRST = "kennel@ZC";// 犬舍初次注册费
	public static final String KENNEL_FEE = "kennel@ND";// 犬舍年度登记费

	public static final String MEMBER_COUPON = "sys_coupon@DK";// 会员抵扣券

	@Autowired
	public MemberService memberService;
	@Autowired
	public DogService dogService;
	@Autowired
	public PaymentChargingItemDao paymentChargingItemDao;
	@Autowired
	private PaymentCartService paymentCartService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	public RestMemberService restMemberService;
	@Autowired
	public PaymentCartDao paymentCartDao;
	@Autowired
	public PaymentOrderDao paymentOrderDao;
	@Autowired
	public PaymentOrderService paymentOrderService;
	@Autowired
	public PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	public RestOrderService restOrderService;
	@Autowired
	public OrgService orgService;
	@Autowired
	public KennelService kennelService;
	@Autowired
	public DogChipDao dogChipDao;
	@Autowired
	public DogChipService dogChipService;
	@Autowired
	public SysOrgPrintService sysOrgPrintService;
	@Autowired
	public PaymentRecordDao paymentRecordDao;
	@Autowired
	private PaymentChargingItemGroupService paymentChargingItemGroupService;
	@Autowired
	private SysCouponService sysCouponService;
	@Autowired
	private MemberActivity20201212Discount memberActivity20201212Discount;
	@Autowired
	private PaymentRecordService paymentRecordService;

	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public List<PaymentCart> toCart(String memberCode, String orgid, String couponId) {
		Org org = orgService.get(orgid);
		Member member = memberService.getByMemberCode(memberCode);
		// 校验是否会员已冻结
		if ("1".equals(member.getFreezeFlag()) && !member.getMemberCode().contains("HZ")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员已被冻结,无法生成订单");
		}
		if (MemberCardTypeEnum.DEFAULT_CARD.code().equals(member.getMemberCardType())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "普通会员不能缴费");
		}
		Member clubMember = memberService.getByMemberCode(org.getMemberCode());
		// 业务查重

		List<PaymentCart> carts = new ArrayList<PaymentCart>();
		PaymentCart cart = new PaymentCart();
		cart.setMemberCode(memberCode);
		List<PaymentCart> paymentCartList = paymentCartDao.findList(cart);
		PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(MEMER_BASIC);
		for (PaymentCart paymentCart : paymentCartList) {
			if (paymentChargingItem.getId().equals(paymentCart.getChargingItemId())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "购物车已有订单，请勿重复提交");
			}
		}
		// 增加会员类校验
		if (member.getMemberEndDate() != null && member.getKennel() != null && member.getKennel().getEndTime() != null
				&& !DateUtils.isSameDay(member.getMemberEndDate(), member.getKennel().getEndTime())
				&& !KennelType.permanent.toString().equals(member.getKennel().getType())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员与犬舍日期不同步，无法完成续费，请联系CKU处理");
		}
		String memberRenewType = memberService.getMemberRenewalType(member);
		List<PaymentChargingItem> itemList = paymentChargingItemGroupService
				.findPaymentChargingItemById(memberRenewType.toString());
		// 20201212活动
		PaymentChargingItem discount = memberActivity20201212Discount.get20201212Discount(memberRenewType, memberCode);
		if (discount != null) {
			itemList.add(discount);
		}
		itemList.forEach(item -> {
			carts.add(addToCart(clubMember, member, item, memberRenewType.toString()));
		});

		// 业务批次号
		Date now = new Date();
		if (member.getMemberEndDate() == null) {// 会员使用优惠券
			if (StringUtils.isNotBlank(couponId)) {
				SysCoupon coupon = sysCouponService.get(couponId);
				if (coupon != null) {
					carts.add(sysCouponService.buildPaymentCart(coupon, MEMBER_COUPON, memberRenewType,
							clubMember.getMemberCode()));
				}
			}

		} else if (member.getMemberEndDate() != null
				&& (new Date().getTime() > DateUtils.parseDate(DateUtils.get1MonthLater(member.getMemberEndDate()))
						.getTime() || member.getRegistrant().equals(org.getUser().getLoginName()))// 过去会员或者是本俱乐部招募的
				&& StringUtils.isNotBlank(org.getOrgType()) && "singleTypeClub".equals(org.getOrgType())) {// 会员使用优惠券
			if (StringUtils.isNotBlank(couponId)) {
				SysCoupon coupon = sysCouponService.get(couponId);
				if (coupon != null) {
					carts.add(sysCouponService.buildPaymentCart(coupon, MEMBER_COUPON, memberRenewType,
							clubMember.getMemberCode()));
				}
			}
		}
		return carts;
	}

	/**
	 * 添加购物车
	 *
	 * @Author chaixueteng
	 * @2016年10月17日下午2:36:32
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public PaymentCart addToCart(Member clubMember, Member member, PaymentChargingItem item, String businessCode) {
		PaymentCart paymentCart = new PaymentCart();
		paymentCart.setChargingItemId(item.getId());
		paymentCart.setChargingItemName(item.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(item.getPrice());
		paymentCart.setTotalPrice(item.getPrice());
		if (item.getShortName().startsWith("kennel")) {
			paymentCart.setBusinessTable("kennel");
			paymentCart.setBusinessIds(member.getKennel().getId());
		} else {
			paymentCart.setBusinessTable("sys_member");
			paymentCart.setBusinessIds(member.getId());
		}
		paymentCart.setBusinessOrderCode(businessCode);
		paymentCart.setMemberCode(clubMember.getMemberCode());
		paymentCart.setMemberName(clubMember.getName());
		paymentCart.setAddTime(new Date());
		paymentCart.setCouponNum("0");
		paymentCart.preInsert();
		paymentCartDao.insert(paymentCart);
		return paymentCart;
	}

	/**
	 * 将购物车中的商品转存入订单
	 *
	 * @param paymentOrder
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public List<PaymentOrderDetail> cartToOrder(List<PaymentCart> carts, PaymentOrder paymentOrder) {

		Double orderTotal = Double.valueOf("0");
		Date addTime = new Date();
		// 校验订单总额标记位
		boolean checkOrderTotal = false;
		for (PaymentCart paymentCart : carts) {
			orderTotal += Double.valueOf(paymentCart.getTotalPrice());
			if (!checkOrderTotal && !"277".equals(paymentCart.getChargingItemId())) {
				checkOrderTotal = true;
			}
		}
		// if(checkOrderTotal&&orderTotal == 0.0){
		// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"订单价格校验失败");
		// }

		// 生成订单商品
		restOrderService.saveOrder(paymentOrder, orderTotal, addTime);
		List<PaymentOrderDetail> list = new ArrayList<PaymentOrderDetail>();
		// 生成订单详情
		for (int i = 0; i < carts.size(); i++) {
			PaymentCart cart = carts.get(i);
			PaymentOrderDetail detail = new PaymentOrderDetail();
			detail.setOrderCode(paymentOrder.getOrderCode());
			detail.setAddTime(addTime);
			detail.setProccessState("0");
			detail.setTotalPrice(cart.getTotalPrice());
			detail.setNum(cart.getNum());
			detail.setPrice(cart.getPrice());
			detail.setBusinessIds(cart.getBusinessIds());
			detail.setBusinessTable(cart.getBusinessTable());
			detail.setBusinessCode(cart.getBusinessOrderCode());
			detail.preInsert();
			detail.setChargingItemId(cart.getChargingItemId());
			detail.setMemberCode(cart.getMemberCode());
			detail.setMemberName(cart.getMemberName());
			detail.setChargingItemName(cart.getChargingItemName());
			paymentOrderDetailDao.insert(detail);
			list.add(detail);
			// 更新业务表不为空且不为会员表的收费项
			if (StringUtils.isNotBlank(cart.getBusinessTable()) && !"sys_member".equals(cart.getBusinessTable())
					&& !"kennel".equals(cart.getBusinessTable())) {
				String businessIds = cart.getBusinessIds();
				if (businessIds.contains(",")) {
					String[] bids = businessIds.split(",");
					for (int j = 0; j < bids.length; j++) {
						paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(), cart.getBusinessTable(),
								bids[i]);
					}
				} else {
					paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(), cart.getBusinessTable(),
							businessIds);
				}
			}

		}

		// 清空购物车中已经购买的商品
		for (PaymentCart paymentCart : carts) {
			paymentCartService.removeCart(paymentCart.getId(), false);
		}
		return list;
	}

	/**
	 * 业务缴费
	 *
	 * @Author chaixueteng
	 * @2016年10月17日下午6:14:33
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public String paymentOrder(String paymentWay, String orderId) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		// 判断订单是否存在，是否为未付款
		PaymentOrder order = paymentOrderService.get(orderId);
		if (order != null && order.getPaymentState().equals("1")) {
			order.setPaymentWay("25");// 25代表余额支付
			memberService.memberCharge(org.getMemberCode(), order.getTotalPrice(), order.getOrderCode());
			restOrderService.afterPayByPartner(order);
		}
		return "redirect:/partner/clubMember/list?repage";
	}

	/**
	 * 超时激活缴费
	 *
	 * @param paymentWay
	 * @param orderId
	 * @return
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public String activitionPaymentOrder(String paymentWay, String orderId) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		// 判断订单是否存在，是否为未付款
		PaymentOrder order = paymentOrderService.get(orderId);
		if (order != null && order.getPaymentState().equals("1")) {
			order.setPaymentWay("25");// 25代表余额支付
			memberService.memberCharge(org.getMemberCode(), order.getTotalPrice(), order.getOrderCode());
			restOrderService.afterPay(order);
		}
		return "redirect:/partner/dogActivation/list?repage";
	}

	/**
	 * 新生犬业务缴费
	 *
	 * @Author chaixueteng
	 * @2016年10月17日下午6:14:33
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public String paymentClubOrder(String paymentWay, String orderId) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		// 判断订单是否存在，是否为未付款
		PaymentOrder order = paymentOrderService.get(orderId);
		if (order != null && order.getPaymentState().equals("1")) {
			order.setPaymentWay("25");// 25代表余额支付
			memberService.memberCharge(org.getMemberCode(), order.getTotalPrice(), order.getOrderCode());
			restOrderService.afterPay(order);
		}
		return "redirect:/partner/clubMember/dogList?repage";
	}

	/**
	 * 新生犬缴费后生成证书号和犬只信息
	 *
	 * @Author chaixueteng
	 * @2016年10月27日上午10:51:45
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	private void createDog(PaymentOrder order) {
		List<PaymentOrderDetail> orderDetailList = order.getOrderDetailList();
		for (PaymentOrderDetail pod2 : orderDetailList) {
			String businessTable = pod2.getBusinessTable();
			String businessIds = pod2.getBusinessIds();
			if ("dog_chip".equals(businessTable)) {// 直接处理生成犬只信息 和血统证书号
				DogChip dogChip = dogChipService.get(businessIds);
				dogChip.setReviewState("1");
				String reviewState = dogChip.getReviewState();
				dogChipDao.changeStatus(dogChip);
				dogChipService.changeProcessState(dogChip);
			}
		}
	}

	/**
	 * 犬舍缴费 直接添加订单
	 *
	 * @Author chaixueteng
	 * @2016年10月19日上午10:09:24
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public List<PaymentOrderDetail> kennelToCart(String memberCode) {
		Kennel kennel = kennelService.getKennelByMemberCode(memberCode);
		// 设置订单基本字段
		PaymentOrder paymentOrder = buildPaymentOrder();
		// 构造订单详情列表
		List<PaymentOrderDetail> paymentOrderDetailList = buildPaymentOrderDetailList(paymentOrder, kennel);
		// 计算订单总额
		Double orderTotal = 0d;
		for (PaymentOrderDetail detail : paymentOrderDetailList) {
			orderTotal = orderTotal + Double.parseDouble(detail.getTotalPrice());
		}
		// 保存订单
		restOrderService.saveOrder(paymentOrder, orderTotal, paymentOrder.getAddTime());
		// 回写订单详情的OrderCode字段
		for (PaymentOrderDetail detail : paymentOrderDetailList) {
			detail.setOrderCode(paymentOrder.getOrderCode());
		}
		// 保存订单详情
		for (PaymentOrderDetail detail : paymentOrderDetailList) {
			detail.preInsert();
			paymentOrderDetailDao.insert(detail);
		}

		return paymentOrderDetailList;
	}

	/**
	 * 订单基本属性
	 *
	 * @Author chaixueteng
	 * @2016年10月19日上午10:18:52
	 */
	private PaymentOrder buildPaymentOrder() {
		PaymentOrder order = new PaymentOrder();
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginType = org.getUser().getLoginType();
		Member member = org.getMember();
		order.setMemberCode(member.getMemberCode());
		order.setMemberName(member.getName());
		order.setAddTime(new Date());
		order.setSource(loginType);// 来自合作机构的订单
		order.setOrderCode(SysCodeUtil.getPayRunningNumberWithMemberCode(member.getMemberCode()));
		return order;
	}

	/**
	 *
	 * @description: 构造订单详情列表
	 * @author: laiguanglong
	 * @date: 2016年10月13日 下午7:22:16
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	private List<PaymentOrderDetail> buildPaymentOrderDetailList(PaymentOrder paymentOrder, Kennel kennel) {

		PaymentChargingItem kennelFirstFee = paymentChargingItemDao.getByShortName(KENNEL_FEE_FIRST);
		PaymentChargingItem kennelYearFee = paymentChargingItemDao.getByShortName(KENNEL_FEE);
		Double firtsFee = Double.parseDouble(kennelFirstFee.getPrice());// 犬舍初次注册费
		Double yearFee = Double.parseDouble(kennelYearFee.getPrice());// 犬舍年度登记费
		List<PaymentOrderDetail> paymentOrderDetailList = new ArrayList<PaymentOrderDetail>();
		PaymentOrderDetail detail1 = new PaymentOrderDetail();
		detail1.setOrderCode(paymentOrder.getOrderCode());
		detail1.setAddTime(paymentOrder.getAddTime());
		detail1.setProccessState("0");
		detail1.setTotalPrice(firtsFee.toString());
		detail1.setNum("1");
		detail1.setPrice(firtsFee.toString());
		detail1.setBusinessIds(kennel.getId());
		detail1.setBusinessTable("kennel");
		detail1.setChargingItemId(kennelFirstFee.getId());
		detail1.setMemberCode(paymentOrder.getMemberCode());
		detail1.setMemberName(paymentOrder.getMemberName());
		detail1.setChargingItemName(kennelFirstFee.getName());
		paymentOrderDetailList.add(detail1);

		PaymentOrderDetail detail2 = new PaymentOrderDetail();
		detail2.setOrderCode(paymentOrder.getOrderCode());
		detail2.setAddTime(paymentOrder.getAddTime());
		detail2.setProccessState("0");
		detail2.setTotalPrice(yearFee.toString());
		detail2.setNum("1");
		detail2.setPrice(yearFee.toString());
		detail2.setBusinessIds(kennel.getId());
		detail2.setBusinessTable("kennel");
		detail2.setChargingItemId(kennelYearFee.getId());
		detail2.setMemberCode(paymentOrder.getMemberCode());
		detail2.setMemberName(paymentOrder.getMemberName());
		detail2.setChargingItemName(kennelYearFee.getName());
		paymentOrderDetailList.add(detail2);
		return paymentOrderDetailList;
	}

	/**
	 * 更改订单支付方式
	 *
	 * @param orderId
	 * @param paymentWay
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public void updateOrderWay(String orderId, String paymentWay) {
		PaymentOrder paymentOrder = paymentOrderService.get(orderId);
		paymentOrder.setPaymentWay(paymentWay);
		paymentOrderDao.update(paymentOrder);
	}

	/**
	 * 公用支付方法
	 *
	 * @param paymentRecord
	 * @throws ZAException
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public void paySave(PaymentRecord paymentRecord) throws ZAException {
		// 生成订单
		Member member = memberService.getByMemberCode(paymentRecord.getMemberCode());
		PaymentOrder paymentOrder = buildPaymentOrder();
		// 扣费
		memberService.memberCharge(paymentRecord.getMemberCode(), paymentRecord.getPaymentAmount(),
				paymentOrder.getOrderCode());
		PaymentChargingItem paymentChargingItem = paymentChargingItemDao.get(paymentRecord.getChargingItemId());
		PaymentOrderDetail buildRePrintPaymentOrderDetailList = buildRePrintPaymentOrderDetailList(paymentOrder,
				paymentChargingItem);
		// 计算订单总额
		Double orderTotal = Double.parseDouble(buildRePrintPaymentOrderDetailList.getTotalPrice());
		// 保存订单
		String loginType = UserUtils.getLoginUser().getLoginType();
		paymentOrder.setOrderCode(paymentOrder.getOrderCode());
		paymentOrder.setAddTime(paymentOrder.getAddTime());
		paymentOrder.setLocked("0");
		paymentOrder.setTotalPrice(orderTotal.toString());
		paymentOrder.setPaymentState("2");
		paymentOrder.setPaymentTime(new Date());
		paymentOrder.setPaymentWay("25");
		paymentOrder.setSource(loginType);
		paymentOrder.preInsert();
		paymentOrderDao.insert(paymentOrder);
		// 回写订单详情的OrderCode字段
		buildRePrintPaymentOrderDetailList.setOrderCode(paymentOrder.getOrderCode());
		// 保存订单详情
		buildRePrintPaymentOrderDetailList.preInsert();
		paymentOrderDetailDao.insert(buildRePrintPaymentOrderDetailList);
		// 生成订单流水
		paymentRecord.setPaymentTime(new Date());
		/*
		 * String sql
		 * ="UPDATE dog_chip SET payment_state = 2,payment_time = now(),review_state = '1',review_time = now()  WHERE id = '"
		 * ).append(paymentRecord.getBusinessId()).append("'");; j =
		 * dao.changePaymentState(sql); if(j<=0){ throw new
		 * ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_UPDATEFAIL_STATE,"修改业务状态失败！"); }
		 */
		paymentRecord.setPaymentWay("25");
		paymentRecord.setPaymentState("2");
		paymentRecord.setRunningNumber(paymentOrder.getOrderCode());
		paymentRecord.preInsert();
		
		paymentRecordService.setRecordRegister(paymentRecord);
		paymentRecordDao.insert(paymentRecord);
		// 重置输入的出生纸
		restPrint(paymentRecord.getPaymentRemarks());

	}

	/**
	 *
	 * @Author chaixueteng
	 * @2017年10月25日下午3:30:57
	 */
	private void restPrint(String birthCode) {
		Dog dog = dogService.getByBirthCertificateLevelCode(birthCode);
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "查询登记卡失败:登记卡编号不正确!");
		}
		if (StringUtils.isBlank(dog.getPrintState())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "查询登记卡失败:该登记卡打印参数有误!");
		} else if ("2".equals(dog.getPrintState())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "该登记卡未打印,不需要重置!");
		}
		dog.setPrintState("2");
		// 打印更新时间和操作人
		dog.preUpdate();
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		dog.setOperator(
				dog.getOperator() + "[" + dog.getUpdateBy() + "<重置打印>:" + format.format(dog.getUpdateDate()) + "]");
		dogService.updatePrintState(dog);
	}

	/**
	 * 构造订单详情
	 *
	 * @Author chaixueteng
	 * @2017年10月25日下午2:00:53
	 */
	@Transactional(readOnly = false)
	private PaymentOrderDetail buildRePrintPaymentOrderDetailList(PaymentOrder paymentOrder,
			PaymentChargingItem paymentChargingItem) {
		Double fee = Double.parseDouble(paymentChargingItem.getPrice());// 重置打印服务费
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		SysOrgPrint sysOrgPrint = new SysOrgPrint();
		sysOrgPrint.setOrgId(org.getId());
		List<SysOrgPrint> findList = sysOrgPrintService.findList(sysOrgPrint);
		SysOrgPrint orgPrint = null;
		if (findList.size() < 0) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "俱乐部数据异常,请联系管理员!");
		} else {
			orgPrint = findList.get(0);
		}
		PaymentOrderDetail detail = new PaymentOrderDetail();
		detail.setOrderCode(paymentOrder.getOrderCode());
		detail.setAddTime(paymentOrder.getAddTime());
		detail.setProccessState("0");
		detail.setTotalPrice(fee.toString());
		detail.setNum("1");
		detail.setPrice(fee.toString());
		detail.setBusinessIds(orgPrint.getId());
		detail.setBusinessTable("sys_org_print");
		detail.setChargingItemId(paymentChargingItem.getId());
		detail.setMemberCode(paymentOrder.getMemberCode());
		detail.setMemberName(paymentOrder.getMemberName());
		detail.setChargingItemName(paymentChargingItem.getName());
		return detail;
	}
}
