/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.trainschool.web;

import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.cku.oa.trainschool.service.TrainingInstitutionService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 合作学校Controller
 * @author 柴雪腾
 * @version 2016-08-08
 */
@Controller
@RequestMapping(value = "${adminPath}/trainschool/trainingInstitution")
public class TrainingInstitutionController extends BaseController {

	@Autowired
	private TrainingInstitutionService trainingInstitutionService;

	@ModelAttribute
	public TrainingInstitution get(@RequestParam(required=false) String id) {
		TrainingInstitution entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = trainingInstitutionService.get(id);
		}
		if (entity == null){
			entity = new TrainingInstitution();
		}
		return entity;
	}

	/**
	 * 美容合作学校录入
	 * @Author chaixueteng
	 * @2016年8月17日上午11:18:56
	 */
	@RequiresPermissions("trainschool:groomer:edit")
	@RequestMapping(value = "groomerForm")
	public String groomerForm(TrainingInstitution trainingInstitution, Model model,HttpServletRequest request) {
		if(StringUtils.isNotBlank(trainingInstitution.getAvatar())){
			String path = request.getContextPath();
			String imgPath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/api/v1/file/image//"+trainingInstitution.getAvatar();
			trainingInstitution.setAvatarBack(imgPath);
		}
		model.addAttribute("trainingInstitution", trainingInstitution);
		model.addAttribute("province", UserUtils.getProvince());
		model.addAttribute("city",UserUtils.getCityByProvince(trainingInstitution.getProvince()));
		return "oa/trainschool/groomerSchoolForm";
	}
	/**
	 * 美容合作学校查看
	 * @Author chaixueteng
	 * @2016年8月17日上午11:18:56
	 */
	@RequiresPermissions("trainschool:groomer:view")
	@RequestMapping(value = "groomerView")
	public String groomerView(TrainingInstitution trainingInstitution, Model model) {
		model.addAttribute("trainingInstitution", trainingInstitution);
		return "oa/trainschool/groomerSchoolView";
	}
	/**
	 * 培训合作学校查看
	 * @Author chaixueteng
	 * @2016年8月17日上午11:18:56
	 */
	@RequiresPermissions("trainschool:handler:view")
	@RequestMapping(value = "handlerView")
	public String handlerView(TrainingInstitution trainingInstitution, Model model) {
		model.addAttribute("trainingInstitution", trainingInstitution);
		return "oa/trainschool/groomerSchoolView";
	}

	/**
	 * 美容师学校保存
	 * @Author chaixueteng
	 * @2016年8月18日上午10:47:15
	 */
	@RequiresPermissions("trainschool:groomer:edit")
	@RequestMapping(value = "save")
	public String save(TrainingInstitution trainingInstitution, Model model, RedirectAttributes redirectAttributes,HttpServletRequest request) {
		if (!beanValidator(model, trainingInstitution)){
			return groomerForm(trainingInstitution, model,request);
		}
		trainingInstitutionService.saveGroomerSchool(trainingInstitution);
		addMessage(redirectAttributes, "保存合作学校成功");
		return "redirect:"+Global.getAdminPath()+"/trainschool/trainingInstitution/groomerSchoolList?repage";
	}
	
	/**
	 * 美容师学校删除
	 * @Author chaixueteng
	 * @2016年8月18日上午11:04:20
	 */
	@RequiresPermissions("trainschool:groomer:delete")
	@RequestMapping(value = "groomerSchoolDelete")
	public String groomerSchoolDelete(TrainingInstitution trainingInstitution, RedirectAttributes redirectAttributes) {
		trainingInstitutionService.groomerSchoolDelete(trainingInstitution);
		addMessage(redirectAttributes, "删除美容学校成功");
		return "redirect:"+Global.getAdminPath()+"/trainschool/trainingInstitution/groomerSchoolList?repage";
	}
	

	/**
	 * 美容师合作学校列表
	 * @Author chaixueteng
	 * @2016年8月15日下午4:18:51
	 */
	@RequiresPermissions("trainschool:groomer:view")
	@RequestMapping(value = "groomerSchoolList")
	public String groomerSchoolList(TrainingInstitution trainingInstitution, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<TrainingInstitution> page = trainingInstitutionService.findGroomerSchoolPage(new Page<TrainingInstitution>(request, response), trainingInstitution,response);
		Date now = new Date();
		request.setAttribute("date", now);
		page.getList().forEach(po -> {
			//学校会员截至日期判断是否缴费
			Member schoolMember = po.getMember();
			if (schoolMember != null) {
				Date memberEndDate = schoolMember.getMemberEndDate();
				po.setSchoolMemberPayFlag(memberEndDate != null && memberEndDate.getTime() + 86400000 > now.getTime() ? "1" : "0");
			}
			//根据负责人会员截止日期判断是否缴费,还需判断美容师会员是否过期
			Date groomerEndDate = po.getResponsiblerGroomerEndDate();
			po.setResponsiblerMemberPayFlag(groomerEndDate != null && groomerEndDate.getTime() + 86400000 > now.getTime() ? "1" : "0");

		});
		model.addAttribute("page", page);
		return "oa/trainschool/groomerSchoolList";
	}
	/**
	 * 培训合作学校列表
	 * @Author chaixueteng
	 * @2016年8月15日下午4:18:51
	 */
	@RequiresPermissions("trainschool:handler:view")
	@RequestMapping(value = "handlerSchoolList")
	public String handlerSchoolList(TrainingInstitution trainingInstitution, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<TrainingInstitution> page = trainingInstitutionService.findHandlerSchoolPage(new Page<TrainingInstitution>(request, response), trainingInstitution); 
		request.setAttribute("date", new Date());
		model.addAttribute("page", page);
		return "oa/trainschool/handlerSchoolList";
	}

	/**
	 * 培训合作学校录入
	 * @Author chaixueteng
	 * @2016年8月17日上午11:18:56
	 */
	@RequiresPermissions("trainschool:handler:add")
	@RequestMapping(value = "handlerForm")
	public String handlerForm(TrainingInstitution trainingInstitution, Model model) {
		model.addAttribute("trainingInstitution", trainingInstitution);
		model.addAttribute("province", UserUtils.getProvince());
		model.addAttribute("city",UserUtils.getCityByProvince(trainingInstitution.getProvince()));
		return "oa/trainschool/handlerSchoolForm";
	}

	/**
	 * 培训学校保存
	 * @Author chaixueteng
	 * @2016年8月18日上午10:47:15
	 */
	@RequiresPermissions("trainschool:handler:edit")
	@RequestMapping(value = "handlerSave")
	public String handlerSave(TrainingInstitution trainingInstitution, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, trainingInstitution)){
			return handlerForm(trainingInstitution, model);
		}
		trainingInstitutionService.save(trainingInstitution);
		addMessage(redirectAttributes, "保存合作学校成功");
		return "redirect:"+Global.getAdminPath()+"/trainschool/trainingInstitution/handlerSchoolList?repage";
	}
	
	/**
	 * 培训学校删除
	 * @Author chaixueteng
	 * @2016年8月18日上午11:04:20
	 */
	@RequiresPermissions("trainschool:handler:delete")
	@RequestMapping(value = "handlerDelete")
	public String handlerDelete(TrainingInstitution trainingInstitution, RedirectAttributes redirectAttributes) {
		trainingInstitutionService.delete(trainingInstitution);
		addMessage(redirectAttributes, "删除合作学校成功");
		return "redirect:"+Global.getAdminPath()+"/trainschool/trainingInstitution/handlerSchoolList?repage";
	}
	

	/**
	 * 美容学校 停止合作
	 * @Author chaixueteng
	 * @2017年9月19日下午2:53:38
	 */
	@RequestMapping(value = "stopSchoolFlag")
	public String stopSchoolFlag(TrainingInstitution trainingInstitution, RedirectAttributes redirectAttributes) {
		trainingInstitutionService.stopSchoolFlag(trainingInstitution);
		addMessage(redirectAttributes, "更新状态成功");
		return "redirect:"+Global.getAdminPath()+"/trainschool/trainingInstitution/groomerSchoolList?repage";
	}
	
}