package com.cku.oa.sys.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.sys.entity.TaskTrigger;
import com.cku.oa.sys.service.TaskTriggerService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 计划任务管理Controller
 * @author zhuoHeng
 * @version 2017-03-29
 */
@Controller
@RequestMapping(value = "${adminPath}/systask/sysTask")
public class TaskTriggerController extends BaseController {

	@Autowired
	private TaskTriggerService sysTaskService;
	
	@ModelAttribute
	public TaskTrigger get(@RequestParam(required=false) String id) {
		TaskTrigger entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = sysTaskService.get(id);
		}
		if (entity == null){
			entity = new TaskTrigger();
		}
		return entity;
	}
	
	@RequiresPermissions("systask:sysTask:view")
	@RequestMapping(value = {"list", ""})
	public String list(TaskTrigger sysTask, HttpServletRequest request, HttpServletResponse response, Model model) throws SchedulerException {
		Page<TaskTrigger> page = sysTaskService.recombinePage(new Page<TaskTrigger>(request, response), sysTask);
		model.addAttribute("page", page);
		return "oa/sys/tasktrigger/taskTriggerList";
	}

	@RequiresPermissions("systask:sysTask:view")
	@RequestMapping(value = "form")
	public String form(TaskTrigger sysTask, Model model) {
		model.addAttribute("sysTask", sysTask);
		return "oa/sys/tasktrigger/taskTriggerForm";
	}

	@RequiresPermissions("systask:sysTask:edit")
	@RequestMapping(value = "save")
	public String save(TaskTrigger sysTask, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, sysTask)){
			return form(sysTask, model);
		}
		sysTaskService.save(sysTask);
		addMessage(redirectAttributes, "保存计划任务管理成功");
		return "redirect:"+Global.getAdminPath()+"/systask/sysTask/?repage";
	}
	
	@RequiresPermissions("systask:sysTask:delete")
	@RequestMapping(value = "delete")
	public String delete(TaskTrigger sysTask, RedirectAttributes redirectAttributes) {
		sysTaskService.delete(sysTask);
		addMessage(redirectAttributes, "删除计划任务管理成功");
		return "redirect:"+Global.getAdminPath()+"/systask/sysTask/?repage";
	}
	
	/**
	 * 
	 * @Description：更改计划任务运行状态
	 * @author: zhuoHeng
	 * @version: 2017年3月29日 上午10:53:17
	 * @throws ClassNotFoundException 
	 */
	@RequiresPermissions("systask:sysTask:changeState")
	@RequestMapping(value = "changeState")
	public String changeState(TaskTrigger sysTask, RedirectAttributes redirectAttributes) throws ClassNotFoundException{
		try {
			sysTaskService.changeState(sysTask);
			addMessage(redirectAttributes, "更改运行状态成功");
		} catch (Exception e) {
			addMessage(redirectAttributes, e.getMessage());
		}
		return "redirect:"+Global.getAdminPath()+"/systask/sysTask/?repage";
	}
	
	/**
	 * 
	 * @Description：开启所有计划任务
	 * @author: zhuoHeng
	 * @version: 2017年4月5日 下午4:31:14
	 */
	@RequiresPermissions("systask:sysTask:changeState")
	@RequestMapping(value = "startAll",method = RequestMethod.GET)
	public String startAll(TaskTrigger sysTask, RedirectAttributes redirectAttributes) throws ClassNotFoundException{
		try {
			sysTaskService.startAll();
			addMessage(redirectAttributes, "更改运行状态成功");
		} catch (Exception e) {
			addMessage(redirectAttributes, e.getMessage());
		}
		return "redirect:"+Global.getAdminPath()+"/systask/sysTask/?repage";
	}
	
	/**
	 * 
	 * @Description：停止所有计划任务
	 * @author: zhuoHeng
	 * @version: 2017年4月6日 下午2:50:14
	 */
	@RequiresPermissions("systask:sysTask:changeState")
	@RequestMapping(value = "shutdownAll",method = RequestMethod.GET)
	public String shutdownAll(TaskTrigger sysTask, RedirectAttributes redirectAttributes) throws ClassNotFoundException{
		try {
			sysTaskService.shutdownAll();
			addMessage(redirectAttributes, "更改运行状态成功");
		} catch (Exception e) {
			addMessage(redirectAttributes, e.getMessage());
		}
		return "redirect:"+Global.getAdminPath()+"/systask/sysTask/?repage";
	}
	
	/**
	 * 
	 * @Description：立即执行一次方法
	 * @author: zhuoHeng
	 * @version: 2017年4月6日 上午10:24:35
	 */
	@RequiresPermissions("systask:sysTask:changeState")
	@RequestMapping(value = "executeOnce")
	public String executeOnce(TaskTrigger sysTask, RedirectAttributes redirectAttributes) throws ClassNotFoundException{
		try {
			sysTaskService.executeOnce(sysTask);
			addMessage(redirectAttributes, "执行成功");
		} catch (Exception e) {
			addMessage(redirectAttributes, e.getMessage());
		}
		return "redirect:"+Global.getAdminPath()+"/systask/sysTask/?repage";
	}

}