/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.entity;

import org.hibernate.validator.constraints.Length;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 会员同步任务Entity
 *
 * @author gyh
 * @version 2019-09-20
 */
public class MemberSyncTask extends DataEntity<MemberSyncTask> {

	public static final String MEMBER_TYPE_CKU = "1";


	private static final long serialVersionUID = 1L;
	private String memberType;        // 会员类型 1cku会员 2csv会员 3caac会员
	private String memberId;        // 会员id
	private String memberCode;        // 会员号
	private String memberName;        // 会员名称
	private Date createTime;        // 创建时间
	private Date syncTime;        // 同步日期
	private String syncStatus = "0";        // 1 已同步 0 未同步

	public MemberSyncTask() {
		super();
	}

	public MemberSyncTask(String id) {
		super(id);
	}

	@Length(min = 0, max = 1, message = "会员类型 1cku会员 2csv会员 3caac会员长度必须介于 0 和 1 之间")
	public String getMemberType() {
		return memberType;
	}

	public void setMemberType(String memberType) {
		this.memberType = memberType;
	}

	@Length(min = 0, max = 100, message = "会员id长度必须介于 0 和 100 之间")
	public String getMemberId() {
		return memberId;
	}

	public void setMemberId(String memberId) {
		this.memberId = memberId;
	}

	@Length(min = 0, max = 100, message = "会员号长度必须介于 0 和 100 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 0, max = 300, message = "会员名称长度必须介于 0 和 300 之间")
	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getSyncTime() {
		return syncTime;
	}

	public void setSyncTime(Date syncTime) {
		this.syncTime = syncTime;
	}

	@Length(min = 0, max = 1, message = "1 已同步 0 未同步长度必须介于 0 和 1 之间")
	public String getSyncStatus() {
		return syncStatus;
	}

	public void setSyncStatus(String syncStatus) {
		this.syncStatus = syncStatus;
	}

}