package com.cku.oa.statistics.service;

import com.cku.oa.finance.cab.dao.CABFinanceStatisticsDao;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.dao.PaymentRecordDao;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.entity.PaymentRecord;
import com.cku.oa.statistics.dao.SaPaymentDetailDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class CheckSplitFinanceService {
    @Autowired
    private PaymentOrderDetailDao paymentOrderDetailDao;
    @Autowired
    private PaymentRecordDao paymentRecordDao;
    @Autowired
    private CABFinanceStatisticsDao cabFinanceStatisticsDao;
    @Autowired
    private SaPaymentDetailDao saPaymentDetailDao;

    @Transactional(readOnly = false)
    public void checkFinance( String startDate,String endDate){
        List<StringBuffer> yes = new ArrayList<StringBuffer>(300);
        List<StringBuffer> no = new ArrayList<StringBuffer>(300);
        List<Map> relist = cabFinanceStatisticsDao.relationShip();

        for(Map re :relist){
            String id = (String)re.get("id");
            String cab = re.get("CAB")!=null?(String)re.get("CAB"):null;
            String cku = re.get("CKU")!=null?(String)re.get("CKU"):null;

            HashMap orderDetail = paymentOrderDetailDao.findDetailByChargeItemCount(id,startDate,endDate);
            HashMap record = paymentRecordDao.findRecordByChargeItemCount(id,startDate,endDate);
            StringBuffer selIds = new StringBuffer();
            if(cku!=null && cku.length()>0){
                for(String a : cku.split(",")){
                    selIds.append("'"+a+"',");
                }
            }
            if(cab!=null && cab.length()>0){
                for(String b: cab.split(",")){
                    selIds.append("'"+b+"',");
                }
            }
            HashMap  saPay = saPaymentDetailDao.findByChargeItemCount(selIds.substring(0,selIds.length()-1),id);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("对应关系："+id+"="+cab+"+"+cku);
            BigDecimal sac = (BigDecimal)saPay.get("con");
            BigDecimal oc = (BigDecimal)orderDetail.get("con");
            BigDecimal rc = (BigDecimal)record.get("con");
            stringBuffer.append("总数量："+sac.toString()+":"+oc.toString()+rc.toString()+"="+oc.add(rc).toString());
            BigDecimal sat = (BigDecimal)saPay.get("total");
            BigDecimal ot = (BigDecimal)orderDetail.get("total");
            BigDecimal rt = (BigDecimal)record.get("total");
            stringBuffer.append("总金额："+sat.toString()+"="+ot.add(rt).toString());

            saPaymentDetailDao.updateCount(id,oc.toString(),ot.toString(),rc.toString(),rt.toString(),sac.toString(),sat.toString());
            if(sat.compareTo(ot.add(rt))==0)
                yes.add(stringBuffer);
            else
                no.add(stringBuffer);
        }

        for (StringBuffer sb : yes){
            System.out.println(sb.toString());
        }
        System.out.println("-------------------------------------------------------------------------------");
        for (StringBuffer sb : no){
            System.out.println(sb.toString());
        }
    }


    public void checkFinanceMatch(String id, String startDate,String endDate){
        List<PaymentOrderDetail> orderDetailList = paymentOrderDetailDao.findDetailByChargeItem(id,startDate,endDate);
        List<PaymentRecord> recordList = paymentRecordDao.findRecordByChargeItem(id,startDate,endDate);
        List<String> list = new ArrayList<String>();
        for(PaymentOrderDetail orderDetail : orderDetailList){
            HashMap map = saPaymentDetailDao.findCountByRunningNumber(orderDetail.getOrderCode());
            list.add("orderDetail==="+orderDetail.getOrderCode()+":"+orderDetail.getTotalPrice()+"="+map.get("total"));
        }

        for (PaymentRecord record :recordList){
            HashMap map = saPaymentDetailDao.findCountByRunningNumber(record.getRunningNumber());
            list.add("record==="+record.getRunningNumber()+":"+record.getPaymentAmount()+"="+map.get("total"));
        }


        for(String str :list){
            System.out.println(str);
        }
    }

    @Transactional(readOnly = false)
    public void testSumInstallmentBalance(String end, String table) {
        List<Map<String,Object>> list = saPaymentDetailDao.findInstallmentBalance(end);
        Connection conn = null;
        try {
            conn = getConn();
            for (Map<String,Object> map : list) {
                PreparedStatement ps;
                String sql = "UPDATE " + table + " SET  installment_balance = '" + map.get("installmentBalance").toString() + "' WHERE member_code = '" + map.get("member_code").toString() + "'";
                System.out.println(sql);
                ps = conn.prepareStatement(sql);
                ps.executeUpdate();
                ps.close();
            }
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            if (conn != null) {
                try {
                    conn.close();
                } catch (SQLException throwables) {
                    throwables.printStackTrace();
                }
            }
        }
        System.out.println("修改了" + list.size());
    }


    private static Connection getConn() {
        String driver = "com.mysql.jdbc.Driver";
        String url = "jdbc:mysql://192.168.18.203:3306/ckuoa_finance_member_log?useUnicode=true&characterEncoding=utf-8";
        String username = "root";
        String password = "Chongaibao123";
        Connection conn = null;
        try {
            //classLoader,加载对应驱动
            Class.forName(driver);
            conn = DriverManager.getConnection(url, username, password);
        } catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
        }
        return conn;
    }
}
