package com.cku.oa.statistics.dao;

import com.cku.oa.statistics.entity.MemberVip;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 大客户数据统计DAO接口
 *
 * @author yuanshuai
 * @version 2020-06-29
 */
@MyBatisDao
public interface MemberVipDao extends CrudDao<MemberVip> {

	/**
	 * @Description： 查询血统证书完成数量
	 * @author: yuanshuai
	 * @date: 2020/6/29 16:30
	 */
	Integer findCashBackPedigreeCertifiedCompleteCount(MemberVip memberVip);
	/**
	 * @Description： 查询血统证书完成数量
	 * @author: yuanshuai
	 * @date: 2020/6/29 16:30
	 */
	Integer findPrepaidPedigreeCertifiedCompleteCount(MemberVip memberVip);

	/**
	 * @Description： 血统证书转化新会员数量
	 * @author: yuanshuai
	 * @date: 2020/11/6 16:24
	 */
	Integer findNewMemberCount(MemberVip memberVip);
}