package com.cku.oa.show.web;

import com.cku.oa.show.entity.ShowJudgeCertificateDogGroup;
import com.cku.oa.show.service.ShowJudgeCertificateDogGroupService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 犬种组犬展裁判证书表Controller
 *
 * @author lgl
 * @version 2018-09-20
 */
@Controller
@RequestMapping(value = "${adminPath}/judgecertificatedoggroup/showJudgeCertificateDogGroup")
public class ShowJudgeCertificateDogGroupController extends BaseController {

    @Autowired
    private ShowJudgeCertificateDogGroupService showJudgeCertificateDogGroupService;

    @ModelAttribute
    public ShowJudgeCertificateDogGroup get(@RequestParam(required = false) String id) {
        ShowJudgeCertificateDogGroup entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = showJudgeCertificateDogGroupService.get(id);
        }
        if (entity == null) {
            entity = new ShowJudgeCertificateDogGroup();
        }
        return entity;
    }

    @RequiresPermissions("judgecertificatedoggroup:showJudgeCertificateDogGroup:view")
    @RequestMapping(value = {"list", ""})
    public String list(ShowJudgeCertificateDogGroup showJudgeCertificateDogGroup, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<ShowJudgeCertificateDogGroup> page = showJudgeCertificateDogGroupService.findPage(new Page<ShowJudgeCertificateDogGroup>(request, response), showJudgeCertificateDogGroup);
        model.addAttribute("page", page);
        return "show/judgecertificatedoggroup/showJudgeCertificateDogGroupList";
    }

    @RequiresPermissions("judgecertificatedoggroup:showJudgeCertificateDogGroup:view")
    @RequestMapping(value = "form")
    public String form(ShowJudgeCertificateDogGroup showJudgeCertificateDogGroup, Model model) {
        model.addAttribute("showJudgeCertificateDogGroup", showJudgeCertificateDogGroup);
        return "show/judgecertificatedoggroup/showJudgeCertificateDogGroupForm";
    }

    @RequiresPermissions("judgecertificatedoggroup:showJudgeCertificateDogGroup:edit")
    @RequestMapping(value = "save")
    public String save(ShowJudgeCertificateDogGroup showJudgeCertificateDogGroup, Model model, RedirectAttributes redirectAttributes) {
        if (!beanValidator(model, showJudgeCertificateDogGroup)) {
            return form(showJudgeCertificateDogGroup, model);
        }
        showJudgeCertificateDogGroupService.save(showJudgeCertificateDogGroup);
        addMessage(redirectAttributes, "保存犬种组犬展裁判证书表成功");
        return "redirect:" + Global.getAdminPath() + "/judgecertificatedoggroup/showJudgeCertificateDogGroup/?repage";
    }

    @RequiresPermissions("judgecertificatedoggroup:showJudgeCertificateDogGroup:edit")
    @RequestMapping(value = "delete")
    public String delete(ShowJudgeCertificateDogGroup showJudgeCertificateDogGroup, RedirectAttributes redirectAttributes) {
        showJudgeCertificateDogGroupService.delete(showJudgeCertificateDogGroup);
        addMessage(redirectAttributes, "删除犬种组犬展裁判证书表成功");
        return "redirect:" + Global.getAdminPath() + "/judgecertificatedoggroup/showJudgeCertificateDogGroup/?repage";
    }

}