package com.cku.oa.show.service;

import java.util.List;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.show.entity.ShowAdvisor;
import com.cku.oa.show.dao.ShowAdvisorDao;

/**
 * 赛事顾问Service
 * @author yuanshuai
 * @version 2025-07-02
 */
@Service
@Transactional(readOnly = true)
public class ShowAdvisorService extends CrudService<ShowAdvisorDao, ShowAdvisor> {

	public ShowAdvisor get(String id) {
		return super.get(id);
	}
	
	public List<ShowAdvisor> findList(ShowAdvisor showAdvisor) {
		return super.findList(showAdvisor);
	}
	
	public Page<ShowAdvisor> findPage(Page<ShowAdvisor> page, ShowAdvisor showAdvisor) {
		return super.findPage(page, showAdvisor);
	}
	
	@Transactional(readOnly = false)
	public void save(ShowAdvisor showAdvisor) {
		if (StringUtils.isNotBlank(showAdvisor.getExperience())) {
			showAdvisor.setExperience(StringEscapeUtils.unescapeHtml4(showAdvisor.getExperience()));
		}
		if (StringUtils.isNotBlank(showAdvisor.getExperienceEn())) {
			showAdvisor.setExperienceEn(StringEscapeUtils.unescapeHtml4(showAdvisor.getExperienceEn()));
		}
		super.save(showAdvisor);
	}
	
	@Transactional(readOnly = false)
	public void delete(ShowAdvisor showAdvisor) {
		super.delete(showAdvisor);
	}
	
}