package com.cku.oa.report.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;

import lombok.Data;

@Data
public class ReportMemberAreaVo implements Serializable {

	private static final long serialVersionUID = -3316210547430345975L;

	private static final Map<String, BigDecimal> DEFAULT_MAP = new LinkedHashMap<String, BigDecimal>() {
		private static final long serialVersionUID = 0L;
		{
			put("合计", BigDecimal.ZERO);
			put("银卡", BigDecimal.ZERO);
			put("金卡", BigDecimal.ZERO);
			put("铂金卡", BigDecimal.ZERO);
			put("紫金卡", BigDecimal.ZERO);
		}
	};

	private Map<String, BigDecimal> validTotal = new LinkedHashMap<String, BigDecimal>(DEFAULT_MAP);// 有效会员合计

	private Map<String, BigDecimal> addedTotal = new LinkedHashMap<String, BigDecimal>(DEFAULT_MAP);// 新增会员合计

	private Map<String, BigDecimal> lossTotal = new LinkedHashMap<String, BigDecimal>(DEFAULT_MAP);// 流失会员合计

	private Map<String, BigDecimal> renewalTotal = new LinkedHashMap<String, BigDecimal>(DEFAULT_MAP);// 续费会员合计

	private Map<String, BigDecimal> keepTotal = new LinkedHashMap<String, BigDecimal>(DEFAULT_MAP);// 留存会员合计

}
