package com.cku.oa.order.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.goods.entity.Sku;
import com.cku.oa.goods.entity.SysBusinessService;
import com.cku.oa.goods.service.SkuService;
import com.cku.oa.goods.service.SysBusinessServiceService;
import com.cku.oa.order.vo.OrderBusinessVo;
import com.cku.oa.order.vo.request.OrderBusinessRequest;
import com.thinkgem.jeesite.common.utils.SpringContextHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 订单service工厂类
 *
 * @author yuanshuai
 * @date 2023/6/18 14:45
 */
@Component
public class OrderServiceFactory {

    @Autowired
    private SysBusinessServiceService sysBusinessServiceService;
    @Autowired
    private SkuService skuService;


    /**
     * 获得业务服务类
     *
     * @author yuanshuai
     * @date 2023/6/18 18:03
     */
    public IOrderBusinessService<OrderBusinessRequest> getBusinessService(String businessId) {
        if (StringUtils.isBlank(businessId)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "业务ID为空");
        }
        SysBusinessService businessService = sysBusinessServiceService.get(businessId);
        if (Objects.isNull(businessService)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "业务ID有误");
        }
        //没配置服务无法下单
        if (StringUtils.isBlank(businessService.getServiceName())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该业务尚未完成配置，无法下单");
        }
        return SpringContextHolder.getBean(businessService.getServiceName());
    }

    /**
     * 获得业务服务类
     *
     * @author yuanshuai
     * @date 2023/6/18 18:03
     */
    public IOrderBusinessService<OrderBusinessRequest> getBusinessServiceByName(String serviceName) {
        if (StringUtils.isBlank(serviceName)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "服务名称为空");
        }
        return SpringContextHolder.getBean(serviceName);
    }

    /**
     * 获得商品服务类
     *
     * @author yuanshuai
     * @date 2023/6/18 18:03
     */
    public ISkuBusinessService<OrderBusinessVo> getSkuService(String skuId) {
        if (StringUtils.isBlank(skuId)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "商品ID为空");
        }
        Sku sku = skuService.get(skuId);
        if (Objects.isNull(sku)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "商品ID有误");
        }
        //没配置服务无法下单
        if (StringUtils.isBlank(sku.getServiceName())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该业务尚未完成配置，无法下单");
        }
        return SpringContextHolder.getBean(sku.getServiceName());
    }

    /**
     * 获得商品服务类
     *
     * @author yuanshuai
     * @date 2023/6/18 18:03
     */
    public ISkuBusinessService<OrderBusinessVo> getSkuServiceByName(String serviceName) {
        if (StringUtils.isBlank(serviceName)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "服务名称为空");
        }
        return SpringContextHolder.getBean(serviceName);
    }
}
