package com.cku.oa.kennel.web;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.kennel.entity.KennelOwnerChange;
import com.cku.oa.kennel.service.KennelOwnerChangeService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 犬舍所有人变更Controller
 * @author zhuguanjin
 * @version 2016-08-23
 */
@Controller
@RequestMapping(value = "${adminPath}/kennel/kennelOwnerChange")
public class KennelOwnerChangeController extends BaseController {

	@Autowired
	private KennelOwnerChangeService kennelOwnerChangeService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	
	@ModelAttribute
	public KennelOwnerChange get(@RequestParam(required=false) String id) {
		KennelOwnerChange entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = kennelOwnerChangeService.get(id);
		}
		if (entity == null){
			entity = new KennelOwnerChange();
		}
		return entity;
	}
	
	@RequiresPermissions("kennel:kennelOwnerChange:view")
	@RequestMapping(value = {"list", ""})
	public String list(KennelOwnerChange kennelOwnerChange, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<KennelOwnerChange> page = kennelOwnerChangeService.findPage(new Page<KennelOwnerChange>(request, response), kennelOwnerChange); 
		model.addAttribute("page", page);
		return "oa/kennel/kennelOwnerChangeList";
	}

	@RequiresPermissions("kennel:kennelOwnerChange:view")
	@RequestMapping(value = "form")
	public String form(KennelOwnerChange kennelOwnerChange, Model model) {
		model.addAttribute("kennelOwnerChange", kennelOwnerChange);
		return "oa/kennel/kennelOwnerChangeForm";
	}

	@RequiresPermissions("kennel:kennelOwnerChange:audit")
	@RequestMapping(value = "auditForm")
	public String auditForm(String id, Model model) {
		model.addAttribute("kennelOwnerChange", kennelOwnerChangeService.get(id));
		return "oa/kennel/kennelOwnerChangeAuditForm";
	}
	
	@RequiresPermissions("kennel:kennelOwnerChange:audit")
	@RequestMapping(value = "audit")
	@ResponseBody
	public Object audit(KennelOwnerChange kennelOwnerChange) {
		HashMap<String,String> map = new HashMap<String,String>();
		map.put("rc", "0");
		try {
			kennelOwnerChangeService.audit(kennelOwnerChange);
		} catch (Exception e) {
			logger.warn("审核失败",e);
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}
	
	@RequiresPermissions("kennel:kennelOwnerChange:edit")
	@RequestMapping(value = "save")
	public String save(KennelOwnerChange kennelOwnerChange, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, kennelOwnerChange)){
			return form(kennelOwnerChange, model);
		}
		kennelOwnerChangeService.save(kennelOwnerChange);
		addMessage(redirectAttributes, "保存犬舍所有人变更成功");
		return "redirect:"+Global.getAdminPath()+"/kennel/kennelOwnerChange/?repage";
	}
	
	@RequiresPermissions("kennel:kennelOwnerChange:edit")
	@RequestMapping(value = "delete")
	public String delete(KennelOwnerChange kennelOwnerChange, RedirectAttributes redirectAttributes) {
		kennelOwnerChangeService.delete(kennelOwnerChange);
		addMessage(redirectAttributes, "删除犬舍所有人变更成功");
		return "redirect:"+Global.getAdminPath()+"/kennel/kennelOwnerChange/?repage";
	}

	@RequiresPermissions("kennel:kennelOwnerChange:resolve")
	@RequestMapping(value = "resolve")
	public String resolve(KennelOwnerChange kennelOwnerChange, RedirectAttributes redirectAttributes) {
		addMessage(redirectAttributes, "处理犬舍所有人变更成功");
		try {
			kennelOwnerChangeService.resolve(kennelOwnerChange);
		} catch (Exception e) {
			logger.warn("处理犬舍所有人变更失败：",e);
			addMessage(redirectAttributes, "处理犬舍所有人变更失败："+e.getMessage());
		}
		return "redirect:"+Global.getAdminPath()+"/kennel/kennelOwnerChange/?repage";
	}
	
	
	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderAdd")
	public String orderAdd(@RequestParam(required=true)String runningNumber,
			@RequestParam(required=true)String chargingItemId,
			@RequestParam(required=true)String memberCode,
			Model model) {
		PaymentChargingItem pci = paymentChargingItemService.get(chargingItemId);
		model.addAttribute("paymentMoney", pci.getPrice());
		model.addAttribute("chargingItemId" , chargingItemId);
		model.addAttribute("runningNumber", runningNumber);
		model.addAttribute("kennelOwnerChange", new KennelOwnerChange());
		return "oa/kennel/kennelOwnerChangeOrderAdd";
	}
	
	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderSave")
	@ResponseBody
	public Object orderSave(KennelOwnerChange kennelOwnerChange, Model model) {
		kennelOwnerChange.setKennelCode(kennelOwnerChange.getKennelCodeStr());
		Map<String,String> map = kennelOwnerChangeService.orderSaveNew(kennelOwnerChange);
		return map;
	}
	
	@RequiresPermissions("finance:paymentOrder:orderItem")
	@RequestMapping(value = "orderList")
	public String orderList(KennelOwnerChange kennelOwnerChange, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<KennelOwnerChange> page = kennelOwnerChangeService.findPage(new Page<KennelOwnerChange>(request, response), kennelOwnerChange); 
		model.addAttribute("page", page);
		return "oa/kennel/kennelOwnerChangeOrderList";
	}

	@RequestMapping(value = "getKennelName")
	@ResponseBody
	public Object getKennelName(@RequestParam(required=true)String originOwnerMemberCode) {
		Map<String,String> map=kennelOwnerChangeService.getKennelName(originOwnerMemberCode);
		return map;
	}

}

