package com.cku.oa.ipaddress.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.cku.oa.ipaddress.entity.IpAddress;
import com.cku.util.DateUtils;
import com.cku.oa.ipaddress.dao.IpAddressDao;

/**
 * ip映射表Service
 * @author ip映射表
 * @version 2019-10-18
 */
@Service
@Transactional(readOnly = true)
public class IpAddressService extends CrudService<IpAddressDao, IpAddress> {

	@Autowired
	private IpAddressDao ipAddressDao;
	
	public IpAddress get(String id) {
		return super.get(id);
	}
	
	public List<IpAddress> findList(IpAddress ipAddress) {
		return super.findList(ipAddress);
	}
	
	public Page<IpAddress> findPage(Page<IpAddress> page, IpAddress ipAddress) {
		return super.findPage(page, ipAddress);
	}
	
	@Transactional(readOnly = false)
	public void save(IpAddress ipAddress) {
		super.save(ipAddress);
	}
	
	@Transactional(readOnly = false)
	public void delete(IpAddress ipAddress) {
		super.delete(ipAddress);
	}
	
	
	@Transactional(readOnly = false)
	public void addIpAddress(String ip) {
		IpAddress ipAddress = new IpAddress();
		ipAddress.setIp(ip);
		ipAddress.setToday(DateUtils.getStringDateShort());
		IpAddress result = this.findByParam(ipAddress);
		if (result == null) {
//			ipAddress.setId(IdGen.uuid());
			ipAddress.setCount(1);
			this.insertIpAddress(ipAddress);
		} else {
			this.updateByParam(ipAddress);
		}
	}

	@Transactional(readOnly = false)
	public void insertIpAddress(IpAddress ipAddress) {
		ipAddressDao.insert(ipAddress);
	}

	public IpAddress findByParam(IpAddress ipAddress) {
		return ipAddressDao.findByParam(ipAddress);
	}

	@Transactional(readOnly = false)
	public void updateByParam(IpAddress ipAddress) {
		ipAddressDao.updateByParam(ipAddress);
	}

	public boolean isBlackList(String ip) {
		return !CollectionUtils.isEmpty(ipAddressDao.findIpBlackList(ip));
	}
	
}