/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.handler.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 在册牵犬师Entity
 * @author 柴雪腾
 * @version 2016-08-26
 */
public class Handler extends DataEntity<Handler> {
	
	private static final long serialVersionUID = 1L;
	private String name;		// 会员姓名
	private String webMembershipCode;		// 网站会员
	private String memberCode;		// 会员号
	private String gender;		// 性别
	private String identityCard;		// 身份证号
	private String address;		// 详细地址
	private String telephone;		// 联系电话
	private String certificateCode;		// 证书号
	private String postcode;		// 邮政编码
	private String qualification;		// 申请资格
	private String qualificationDetil;		// 资格说明
	private String reviewer;		// 审核人
	private String reviewState;		// 审核状态
	
	public Handler() {
		super();
	}

	public Handler(String id){
		super(id);
	}

	@Length(min=0, max=64, message="会员姓名长度必须介于 0 和 64 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Length(min=0, max=100, message="网站会员长度必须介于 0 和 100 之间")
	public String getWebMembershipCode() {
		return webMembershipCode;
	}

	public void setWebMembershipCode(String webMembershipCode) {
		this.webMembershipCode = webMembershipCode;
	}
	
	@Length(min=0, max=100, message="会员号长度必须介于 0 和 100 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}
	
	@Length(min=0, max=1, message="性别长度必须介于 0 和 1 之间")
	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}
	
	@Length(min=0, max=64, message="身份证号长度必须介于 0 和 64 之间")
	public String getIdentityCard() {
		return identityCard;
	}

	public void setIdentityCard(String identityCard) {
		this.identityCard = identityCard;
	}
	
	@Length(min=0, max=255, message="详细地址长度必须介于 0 和 255 之间")
	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}
	
	@Length(min=0, max=64, message="联系电话长度必须介于 0 和 64 之间")
	public String getTelephone() {
		return telephone;
	}

	public void setTelephone(String telephone) {
		this.telephone = telephone;
	}
	
	@Length(min=0, max=64, message="证书号长度必须介于 0 和 64 之间")
	public String getCertificateCode() {
		return certificateCode;
	}

	public void setCertificateCode(String certificateCode) {
		this.certificateCode = certificateCode;
	}
	
	@Length(min=0, max=64, message="邮政编码长度必须介于 0 和 64 之间")
	public String getPostcode() {
		return postcode;
	}

	public void setPostcode(String postcode) {
		this.postcode = postcode;
	}
	
	@Length(min=0, max=500, message="申请资格长度必须介于 0 和 500 之间")
	public String getQualification() {
		return qualification;
	}

	public void setQualification(String qualification) {
		this.qualification = qualification;
	}
	
	public String getQualificationDetil() {
		return qualificationDetil;
	}

	public void setQualificationDetil(String qualificationDetil) {
		this.qualificationDetil = qualificationDetil;
	}
	
	@Length(min=0, max=64, message="审核人长度必须介于 0 和 64 之间")
	public String getReviewer() {
		return reviewer;
	}

	public void setReviewer(String reviewer) {
		this.reviewer = reviewer;
	}
	
	@Length(min=0, max=20, message="审核状态长度必须介于 0 和 20 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}
	
}