/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.handler.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.handler.entity.HandlerShow;
import com.cku.oa.show.entity.MainShows;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 活动DAO接口
 * @author 柴雪腾
 * @version 2016-08-08
 */
@MyBatisDao
public interface HandlerShowDao extends CrudDao<HandlerShow> {
	
	public List<String> getShowAddress();

	public HandlerShow getShow(String showCode);
	//赛事重复性验证
	public List<HandlerShow> getByShowCode(@Param("showCode")String showCode);
	
	List<HandlerShow> findEndHandler();
	
	int updateShowStatus(List<HandlerShow> list);
	
	public List<HandlerShow> findExaminerPage(HandlerShow handlerShow);
	
	int updateRegisterNum(@Param("showCode") String showCode , @Param("num") int num);
	
	public List<HandlerShow> findUnEndMainShows(@Param("pageNo") Integer pageNo, @Param("pageSize") Integer pageSize);

	int countUnEndMainShows();
	
	public List<HandlerShow> findCloseMainShows(@Param("pageNo") Integer pageNo, @Param("pageSize") Integer pageSize);

	int countCloseMainShows();
}