package com.cku.oa.groomerRefereeDelegate.web;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.groomerRefereeDelegate.service.GroomerRefereeDelegateService;
import com.cku.oa.showRefereeDelegate.entity.ShowExport;
import com.cku.util.JSONUtils;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.net.URLDecoder;
import java.util.List;

/**
 * 美容活动裁判委派
 *
 * @author yuanshuai
 * @date 2021/2/25 13:32
 */
@Controller
@RequestMapping(value = "${adminPath}/groomerShow/delegate")
public class GroomerRefereeDelegateController extends BaseController {

	private final static String AUTHORITY_PREFIX = "groomerShow:delegate:";

	@Autowired
	private GroomerRefereeDelegateService groomerRefereeDelegateService;

	@RequiresPermissions(AUTHORITY_PREFIX + "view")
	@RequestMapping(value = {"list", ""})
	public String list(HttpServletRequest request, HttpServletResponse response, Model model) {
		return "oa/groomerRefereeDelegate/groomerShowRefereeList";
	}

	/**
	 * 导入美容活动裁判信息模板
	 *
	 * @author yuanshuai
	 * @date 2021/2/25 13:51
	 */
	@RequiresPermissions(AUTHORITY_PREFIX + "delegate")
	@RequestMapping(value = "import/template")
	public String importFileTemplate(HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
			groomerRefereeDelegateService.importFileTemplate(response);
			return null;
		} catch (Exception e) {
			addMessage(redirectAttributes, "导入模板下载失败！失败信息：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/groomerShow/delegate/list?repage";
	}

	/**
	 * 根据导入美容活动和裁判委派裁判
	 *
	 * @author yuanshuai
	 * @date 2021/2/25 13:36
	 */
	@RequiresPermissions(AUTHORITY_PREFIX + "delegate")
	@RequestMapping(value = "import", method = RequestMethod.POST)
	public String importFile(MultipartFile file, Model model, RedirectAttributes redirectAttributes) {
		try {
			groomerRefereeDelegateService.importGroomerReferee(file, model);
			model.addAttribute("message", "美容活动裁判委派成功。");
		} catch (Exception e) {
			model.addAttribute("message", "美容活动裁判委派失败！失败信息：" + e.getMessage());
		}
		return "oa/groomerRefereeDelegate/groomerShowRefereeList";
	}

	/**
	 * 美容活动裁判结果导出
	 *
	 * @author yuanshuai
	 * @date 2021/2/26 17:22
	 */
	@RequiresPermissions(AUTHORITY_PREFIX + "delegate")
	@RequestMapping(value = "export", method = RequestMethod.POST)
	public void exportFile(@RequestBody String body, HttpServletResponse response) {
		try {
			String json = URLDecoder.decode(body, "utf-8").substring(5);
			if (StringUtils.isBlank(json)) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "委派结果为空，请先导入美容活动裁判信息");
			}
			List<ShowExport> groomerExportList = JSONUtils.toList(json, ShowExport.class);
			groomerRefereeDelegateService.exportGroomerShowReferee(groomerExportList, response);
		} catch (Exception e) {
			logger.error("美容导出报错：", e);
		}
	}

}