/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.web;

import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.constant.Constants;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.groomer.entity.GroomerShow;
import com.cku.oa.groomer.entity.GroomerShowReferee;
import com.cku.oa.groomer.enums.GradeWrittenEnum;
import com.cku.oa.groomer.service.GroomerRegisterService;
import com.cku.oa.groomer.service.GroomerShowRefereeService;
import com.cku.oa.groomer.service.GroomerShowService;
import com.cku.oa.groomer.vo.GroomerRegisterVO;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 美容师报名表Controller
 * 
 * @author cxt
 * @version 2016-07-14
 */
@Controller
@RequestMapping(value = "${adminPath}/groomer/groomerRegister")
public class GroomerRegisterController extends BaseController {

	@Autowired
	private GroomerRegisterService groomerRegisterService;

	@Autowired
	private GroomerShowRefereeService showRefereeService;

	@Autowired
	private GroomerShowService groomerShowService;

	@ModelAttribute
	public GroomerRegister get(@RequestParam(required = false) String id) {
		GroomerRegister entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = groomerRegisterService.get(id);
		}
		if (entity == null) {
			entity = new GroomerRegister();
		}
		return entity;
	}

	@Autowired
	private PaymentOrderService paymentOrderService;

	@RequiresPermissions("groomer:groomerRegister:view")
	@RequestMapping(value = { "list", "" })
	public String list(GroomerRegister groomerRegister, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		Page<GroomerRegister> page = groomerRegisterService.findPage(new Page<GroomerRegister>(request, response),
				groomerRegister);
		// 查询有没有退款或退款中 fmdog_breed_certified_code
		Map<String, String> map = paymentOrderService
				.getRefundStateByBusinessId(page.getList().stream().map(a -> a.getId()).collect(Collectors.toSet()));
		List<GroomerRegister> list = page.getList().stream().map(a -> {
			GroomerRegisterVO b = new GroomerRegisterVO();
			BeanUtils.copyProperties(a, b);
			b.setBusinessRefundState(map.keySet().contains(a.getId()));
			return b;
		}).collect(Collectors.toList());
		page.setList(list);
		model.addAttribute("page", page);

		return "oa/groomer/groomerRegisterList";
	}

	@RequiresPermissions("groomer:groomerRegister:view")
	@RequestMapping(value = "form")
	public String form(GroomerRegister groomerRegister, Model model) {
		model.addAttribute("groomerRegister", groomerRegister);
		model.addAttribute("groomerShow", groomerRegister.getGroomerShow());
		model.addAttribute("groomerShowTypeMap",
				groomerShowService.getShowTypeMap(groomerRegister.getGroomerShow().getShowCode()));
		return "oa/groomer/groomerRegisterForm";
	}

	@RequiresPermissions("groomer:groomerRegister:view")
	@RequestMapping(value = "ttform")
	public String ttform(GroomerRegister groomerRegister, Model model) {
		model.addAttribute("groomerRegister", groomerRegister);
		return "oa/groomer/groomerRegisterTTForm";
	}

	/**
	 * 查看
	 * 
	 * @Author chaixueteng
	 * @2016年8月27日上午11:46:47
	 */
	@RequiresPermissions("groomer:groomerRegister:view")
	@RequestMapping(value = "view")
	public String view(GroomerRegister groomerRegister, Model model) {
		model.addAttribute("groomerRegister", groomerRegister);
		return "oa/groomer/groomerRegisterView";
	}

	@RequiresPermissions("groomer:groomerRegister:edit")
	@RequestMapping(value = "save")
	public String save(GroomerRegister groomerRegister, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, groomerRegister)) {
			return form(groomerRegister, model);
		}
		groomerRegisterService.save(groomerRegister);
		addMessage(redirectAttributes, "保存美容师报名表成功");
		return "redirect:" + Global.getAdminPath() + "/groomer/groomerRegister/?repage";
	}

	@RequiresPermissions("groomer:groomerRegister:delete")
	@RequestMapping(value = "delete")
	public String delete(GroomerRegister groomerRegister, RedirectAttributes redirectAttributes) {
		groomerRegisterService.delete(groomerRegister);
		addMessage(redirectAttributes, "删除美容师报名表成功");
		return "redirect:" + Global.getAdminPath() + "/groomer/groomerRegister/?repage";
	}

	/**
	 * 成绩管理
	 * 
	 * @Author chaixueteng
	 * @2016年7月14日下午5:27:18
	 */
	@RequiresPermissions("groomer:grade:view")
	@RequestMapping(value = "grade")
	public String grade(GroomerRegister groomerRegister, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		Page<GroomerRegister> page = groomerRegisterService.findGradePage(new Page<GroomerRegister>(request, response),
				groomerRegister);
		model.addAttribute("page", page);
		return "oa/groomer/groomerRegisterGradeList";
	}

	/**
	 * 电话报名
	 * 
	 * @Author chaixueteng
	 * @2016年7月14日下午7:14:55
	 */
	@RequiresPermissions("groomer:groomerRegister:view")
	@RequestMapping(value = "webFrom")
	@ResponseBody
	public ResultDto<Boolean> webFrom(GroomerRegister groomerRegister, Model model,
			RedirectAttributes redirectAttributes) {
		try {
			groomerRegisterService.mobileSave(groomerRegister);
			return ResultDto.success("报名成功", Boolean.TRUE);
		} catch (Exception e) {
			return ResultDto.error(ZAErrorCode.ZA_ERROR, e.getMessage());
		}
	}

	/**
	 * 电话报名
	 * 
	 * @Author chaixueteng
	 * @2016年7月14日下午7:14:55
	 */
	@RequiresPermissions("groomer:groomerRegister:view")
	@RequestMapping(value = "webTTFrom")
	public String webTTFrom(GroomerRegister groomerRegister, Model model, RedirectAttributes redirectAttributes) {
		try {
			groomerRegisterService.mobileTTSave(groomerRegister);
			addMessage(redirectAttributes, "报名成功");
		} catch (Exception e) {
			addMessage(redirectAttributes, "报名失败：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/groomer/groomerRegister";
	}

	/**
	 * 录入成绩页面
	 * 
	 * @Author chaixueteng
	 * @2016年7月21日下午2:40:43
	 */
	@RequiresPermissions("groomer:grade:edit")
	@RequestMapping(value = "inputForm")
	public String inputForm(String id, Model model) {
		List<GroomerShowReferee> showRefereeList = showRefereeService.findAllShowReferee();
		model.addAttribute("showRefereeList", showRefereeList);
		model.addAttribute("groomerRegister", groomerRegisterService.get(id));
		return "oa/groomer/groomerRegisterGradeForm";
	}

	/**
	 * 录入成绩页面 (教师)
	 * 
	 * @Author chaixueteng
	 * @2016年7月21日下午2:40:43
	 */
	@RequiresPermissions("groomer:grade:edit")
	@RequestMapping(value = "inputFormM")
	public String inputFormM(String id, Model model) {
		List<GroomerShowReferee> showRefereeList = showRefereeService.findAllShowReferee();
		model.addAttribute("showRefereeList", showRefereeList);
		model.addAttribute("groomerRegister", groomerRegisterService.get(id));
		return "oa/groomer/groomerRegisterGradeFormMaster";
	}

	/**
	 * 查看
	 * 
	 * @Author chaixueteng
	 * @2016年8月27日上午11:46:47
	 */
	@RequiresPermissions("groomer:grade:view")
	@RequestMapping(value = "gradeView")
	public String gradeView(GroomerRegister groomerRegister, Model model) {
		model.addAttribute("groomerRegister", groomerRegister);
		return "oa/groomer/groomerRegisterView";
	}

	/**
	 * 编辑
	 * 
	 * @Author zhangxiang
	 * @2019年3月26日上午10:17:47
	 */
	@RequiresPermissions("groomer:grade:view")
	@RequestMapping(value = "gradeViewEdit")
	public String gradeViewEdit(GroomerRegister groomerRegister, Model model) {
		model.addAttribute("groomerRegister", groomerRegister);
		return "oa/groomer/groomerRegisterViewEdit";
	}

	/**
	 * 编辑
	 * 
	 * @Author zhangxiang
	 * @2019年3月26日上午10:17:47
	 */
	@ResponseBody
	@RequestMapping(value = "gradeViewFormEdit")
	public Object gradeViewFormEdit(HttpServletRequest request, Model model) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("rc", "0");
		String id = request.getParameter("id");
		String gradeWrite = request.getParameter("gradeWrite");
		GroomerRegister groomerRegister = groomerRegisterService.get(id);
		try {
			if (groomerRegister == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "笔试成绩修改失败");
			}
			if (Objects.equals(gradeWrite, groomerRegister.getGradeWrite())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "您的修改后的笔试成绩和当前成绩一样，请检查！");
			}
			if (Objects.equals(GradeWrittenEnum.PASSED.code(), groomerRegister.getGradeWrite())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "笔试成绩为通过时无法修改状态!");
			}
			GroomerShow showCode = groomerShowService.getShowCode(groomerRegister.getShowCode());
			String[] str = groomerRegister.getShowCode().split(Constants.LINE);

			if ((Objects.equals(showCode.getShowType(), "exam") && str[2].trim().equals("ZG")) ||
					((Objects.equals(showCode.getShowType(), "match") &&
							(str[2].trim().equals("JY") || str[2].trim().equals("ZHRY")
									|| str[2].trim().equals("CQ") || str[2].trim().equals("CQTZ"))))) {
				if (Objects.equals(groomerRegister.getGradeWrite(), GradeWrittenEnum.TO_BE_EXAM.code())
						|| Objects.equals(groomerRegister.getGradeWrite(), GradeWrittenEnum.PASSED.code())) {
					String result = null;
					if (Objects.equals(groomerRegister.getGradeWrite(), GradeWrittenEnum.TO_BE_EXAM.code())){
						result = "请参加笔试考试!";
					} else {
						result = "笔试已通过,不能修改成绩!";
					}
					throw new ZAException(ZAErrorCode.ZA_ERROR, result);
				} else if (Objects.equals(gradeWrite, GradeWrittenEnum.PASSED.code())) {
					groomerRegister.setRemarks((groomerRegister.getRemarks() == null ? "" : groomerRegister.getRemarks()) + ";业务人员" + UserUtils.getLoginUser().getId() + ":" + UserUtils.getLoginUser().getName() + "操作笔试成绩为通过!");
				}
				//groomerRegister.setWrittenExamStatus(GradeWrittenEnum.PASSED.code());
			}
			groomerRegister.setGradeWrite(gradeWrite);
			groomerRegister.setExamNum(groomerRegister.getExamNum() + Constants.NUM_ONE);
			groomerRegister.setEligibility(Boolean.FALSE);
			groomerRegisterService.save(groomerRegister);
			// 成绩通过触发发证逻辑
			if ("1".equals(gradeWrite)) {
				groomerRegisterService.saveGrade(groomerRegister, false);
			}
			map.put("msg", "保存成功");
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	/**
	 * 根据会员号查询会员信息
	 * 
	 * @throws ZAException
	 * @Author chaixueteng
	 * @2016年7月19日下午3:15:14
	 */
	@RequestMapping(value = "/getMemberMessage")
	@ResponseBody
	public Object getMemberMessage(HttpServletRequest request, HttpServletResponse response) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("rc", "0");
		String memberCode = request.getParameter("memberCode");
		String showCode = request.getParameter("showCode");
		try {
			map = groomerRegisterService.getMemberMessage(memberCode, showCode);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	/**
	 * 成绩录入
	 * 
	 * @Author chaixueteng
	 * @2016年7月26日上午10:30:06
	 */
	@RequestMapping(value = "inputGrade")
	@ResponseBody
	public Object inputGrade(GroomerRegister groomerRegister, RedirectAttributes redirectAttributes) {
		Map<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			groomerRegisterService.saveGrade(groomerRegister, true);
		} catch (Exception e) {
			map.put("rc", "0");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	/**
	 * 成绩导入
	 * 
	 * @Author chaixueteng
	 * @2016年7月26日上午10:30:06
	 */
	@RequiresPermissions("groomer:grade:import")
	@RequestMapping(value = "import", method = RequestMethod.POST)
	public String importFile(MultipartFile file, RedirectAttributes redirectAttributes) {
		try {
			// 赛事信息导入
			groomerRegisterService.importShows(file);
			addMessage(redirectAttributes, "导入成功！");
		} catch (Exception e) {
			addMessage(redirectAttributes, "导入失败！失败信息：" + e.getMessage());
		}
		return "redirect:" + Global.getAdminPath() + "/groomer/groomerRegister/grade";
	}

	/**
	 * 修改请假状态
	 * 
	 * @Author chaixueteng
	 * @2016年8月1日下午4:28:22
	 */
	@RequiresPermissions("groomer:groomerRegister:edit")
	@RequestMapping(value = "updateLeaveFlag")
	public String updateLeaveFlag(String tmp, GroomerRegister groomerRegister, RedirectAttributes redirectAttributes) {
		groomerRegisterService.updateLeaveFlag(groomerRegister);
		addMessage(redirectAttributes, "更新状态成功");
		if ("1".equals(tmp)) {
			return "redirect:" + Global.getAdminPath() + "/groomer/groomerRegister/ttform?id="
					+ groomerRegister.getId();
		}
		return "redirect:" + Global.getAdminPath() + "/groomer/groomerRegister/form?id=" + groomerRegister.getId();
	}

	/**
	 * 根据报名编号回显复选框级别
	 * 
	 * @throws Exception
	 * @Author chaixueteng
	 * @2016年7月19日下午3:15:14
	 */
	@RequestMapping(value = "/getRegisterMessage")
	public void getRegisterMessage(HttpServletRequest request, HttpServletResponse response) throws Exception {
		String id = request.getParameter("id");
		response.setContentType("text/Xml;charset=utf-8");
		String str = groomerRegisterService.getRegisterMessage(id);
		response.getWriter().write(str);
	}

	/**
	 * 美容报名信息导出
	 * 
	 * @Author chaixueteng
	 * @2016年8月3日下午4:48:21
	 */
	@RequiresPermissions("groomer:groomerRegister:export")
	@RequestMapping(value = "export")
	public String export(GroomerRegister groomerRegister, HttpServletResponse response,
			RedirectAttributes redirectAttributes) {
		try {
			groomerRegisterService.export(groomerRegister, response);
		} catch (IOException e) {
			addMessage(redirectAttributes, "导出报名信息失败！失败信息：" + e.getMessage());
			return "oa/groomer/groomerRegisterList";
		}
		return null;
	}

	/**
	 * 审核证件照
	 * 
	 * @Author chaixueteng
	 * @2016年8月17日下午1:33:48
	 */
	@RequiresPermissions("groomer:groomerRegister:audit")
	@RequestMapping(value = { "uploadImage" })
	public String uploadImage(GroomerRegister groomerRegister, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		model.addAttribute("groomerRegister", groomerRegister);
		return "oa/groomer/groomerUploadImage";
	}

	/**
	 * 上传证件照
	 * 
	 * @Author chaixueteng
	 * @2016年8月17日下午1:33:48
	 */
	@RequiresPermissions("groomer:groomerRegister:audit")
	@RequestMapping(value = { "toUpImage" })
	public String toUpImage(GroomerRegister groomerRegister, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		model.addAttribute("groomerRegister", groomerRegister);
		return "oa/groomer/groomerToUpImage";
	}

	/**
	 * 审核证件照并审核通过
	 * 
	 * @Author chaixueteng
	 * @2016年8月17日下午1:33:48
	 */
	@RequestMapping(value = { "saveImage" })
	@ResponseBody
	public Object saveImage(GroomerRegister groomerRegister, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		Map<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			groomerRegisterService.saveImage(groomerRegister);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	/**
	 * 保存证件照并审核通过
	 * 
	 * @Author chaixueteng
	 * @2016年8月17日下午1:33:48
	 */
	@RequestMapping(value = { "toReImage" })
	@ResponseBody
	public Object toReImage(GroomerRegister groomerRegister, HttpServletRequest request, HttpServletResponse response,
			Model model) {
		Map<String, String> map = new HashMap<String, String>();
		map.put("rc", "0");
		try {
			groomerRegisterService.toReImage(groomerRegister);
		} catch (Exception e) {
			map.put("rc", "1");
			map.put("msg", e.getMessage());
		}
		return map;
	}

	/**
	 * 重复报名校验
	 * 
	 * @throws Exception
	 * 
	 * @Author chaixueteng
	 * @2016年9月6日下午5:34:44
	 */
	@RequestMapping(value = "registerCheck")
	@ResponseBody
	public String registerCheck(HttpServletRequest request, HttpServletResponse response) throws Exception {
		String showCode = request.getParameter("showCode");
		String memberCode = request.getParameter("memberCode");
		return groomerRegisterService.registerCheck(memberCode, showCode);
	}

}