package com.cku.oa.groomer.service;

import java.util.Date;
import java.util.List;
import java.util.Objects;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.groomer.dao.GroomerRegisterDao;
import com.cku.oa.groomer.dao.GroomerWrittenExamInfoDao;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.groomer.entity.GroomerWrittenExamInfo;
import com.cku.oa.groomer.enums.CommitExamTypeEnum;
import com.cku.oa.groomer.mq.DelayedMessageProducer;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * 美容资格认证笔试信息表Service
 * 
 * @author hjx
 * @version 2023-11-23
 */
@Service
@Transactional(readOnly = true)
public class GroomerWrittenExamInfoService extends CrudService<GroomerWrittenExamInfoDao, GroomerWrittenExamInfo> {

	@Autowired
	private GroomerWrittenExamInfoDao groomerWrittenExamInfoDao;

	@Autowired
	private GroomerRegisterDao groomerRegisterDao;

	@Autowired
	private DelayedMessageProducer delayedMessageProducer;

	public GroomerWrittenExamInfo get(String id) {
		return super.get(id);
	}

	public List<GroomerWrittenExamInfo> findList(GroomerWrittenExamInfo groomerWrittenExamInfo) {
		return super.findList(groomerWrittenExamInfo);
	}

	public Page<GroomerWrittenExamInfo> findPage(Page<GroomerWrittenExamInfo> page,
			GroomerWrittenExamInfo groomerWrittenExamInfo) {
		return super.findPage(page, groomerWrittenExamInfo);
	}

	@Transactional(readOnly = false)
	public void save(GroomerWrittenExamInfo groomerWrittenExamInfo) {
		super.save(groomerWrittenExamInfo);
	}

	@Transactional(readOnly = false)
	public void delete(GroomerWrittenExamInfo groomerWrittenExamInfo) {
		super.delete(groomerWrittenExamInfo);
	}

	public GroomerWrittenExamInfo queryWrittenExamInfoByCondition(GroomerWrittenExamInfo groomerWrittenExamInfo) {
		return groomerWrittenExamInfoDao.getWrittenExamInfoByCondition(groomerWrittenExamInfo);
	}

	@Transactional(rollbackFor = Exception.class)
	public void updateWrittenExamInfoAndStatus(GroomerRegister groomerRegister,
			GroomerWrittenExamInfo groomerWrittenExamInfo) {
		groomerRegisterDao.update(groomerRegister);
		this.save(groomerWrittenExamInfo);
	}

	public List<GroomerWrittenExamInfo> queryWrittenExamInfoListByMaxDate(List<String> registerIds, String memberCode) {
		return groomerWrittenExamInfoDao.queryWrittenExamInfoListByMaxDate(registerIds, memberCode);
	}

	public boolean sendDelayedMessage(String groomerWrittenExamInfoId, Integer minute) {
		delayedMessageProducer.sendDelayedMessage(groomerWrittenExamInfoId, (minute + 1) * 60);
		return true;
	}
	
	
	/**
	 * 强制关闭考试
	 */
	@Transactional(rollbackFor = Exception.class)
	public boolean close(String id) {
		GroomerWrittenExamInfo info = get(id);
		if (Objects.isNull(info) || !Objects.isNull(info.getCommitExamType())) {
			return false;
		}
		info.setAutoCloseTime(new Date());
		info.setCommitExamType(CommitExamTypeEnum.AUTO_SUBMISSION.code());
		/*info.setGradeWrite("0");*/
		info.preUpdate();
		super.save(info);
		return true;
	}

}