/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.service;

import com.cku.oa.constant.Constants;
import com.cku.oa.groomer.dao.GroomerShowRefereeDao;
import com.cku.oa.groomer.entity.GroomerShowReferee;
import com.cku.restful.v1.cab.groomer.model.RestGroomerShowReferee;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 赛事裁判表Service
 * @author lgl
 * @version 2016-07-14
 */
@Service
@Transactional(readOnly = true)
public class GroomerShowRefereeService extends CrudService<GroomerShowRefereeDao, GroomerShowReferee> {

	public GroomerShowReferee get(String id) {
		return super.get(id);
	}

	public List<GroomerShowReferee> findList(GroomerShowReferee showReferee) {
		return super.findList(showReferee);
	}

	public Page<GroomerShowReferee> findPage(Page<GroomerShowReferee> page, GroomerShowReferee showReferee) {
		return super.findPage(page, showReferee);
	}

	@Transactional(readOnly = false)
	public void save(GroomerShowReferee showReferee) {
//		showReferee.setType("0");
		super.save(showReferee);
	}

	@Transactional(readOnly = false)
	public void delete(GroomerShowReferee showReferee) {
		super.delete(showReferee);
	}
	//美容审查员
	public List<GroomerShowReferee> findAllShowReferee(){
		return dao.findAllShowReferee();
	}
	//培训审查员
	public List<GroomerShowReferee> findHanlerReferee(){
		return dao.findHanlerReferee();
	}

	public String findRefereeNameEn(String nameCn){
		return dao.findRefereeNameEn(nameCn);
	}

	public List<RestGroomerShowReferee> getRefereeList(String ids){
		return dao.getRefereeList(ids);
	}

	@Transactional(readOnly = false)
    public void saveHandlerShowReferee(GroomerShowReferee groomerShowReferee) {
		groomerShowReferee.setType("1");
		if(StringUtils.isBlank(groomerShowReferee.getRefereeLinkOrderText())){
			groomerShowReferee.setRefereeLinkOrder(null);
		} else {
			groomerShowReferee.setRefereeLinkOrder(Integer.parseInt(groomerShowReferee.getRefereeLinkOrderText()));
		}
		if (StringUtils.isNotBlank(groomerShowReferee.getRefereeIntroduce())) {
			groomerShowReferee.setRefereeIntroduce(StringEscapeUtils.unescapeHtml4(groomerShowReferee.getRefereeIntroduce()));
		}
		save(groomerShowReferee);
    }

	public GroomerShowReferee getGroomerShowReferee(String nameEn){
		return dao.getGroomerShowReferee(nameEn);
	}

	public GroomerShowReferee getLikeGroomerShowReferee(String referee){
		return dao.getLikeGroomerShowReferee(referee);
	}

	public List<String> findAllShowRefereeNameEn(){
		List<GroomerShowReferee> allShowRefereeName = dao.findAllShowReferee();
		List<String> showRefereeList = allShowRefereeName.stream().map(GroomerShowReferee::getRefereeNameEn).collect(Collectors.toList());
		return showRefereeList;
	}

	public String findHandlerRefereeNameEn(String nameCn){
		return dao.findHandlerRefereeNameEn(nameCn);
	}
}