package com.cku.oa.groomer.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.groomer.entity.GroomerExamQuestionsOptions;
import com.cku.oa.groomer.dao.GroomerExamQuestionsOptionsDao;

/**
 * 美容考试题选项表Service
 * @author hjx
 * @version 2023-11-23
 */
@Service
@Transactional(readOnly = true)
public class GroomerExamQuestionsOptionsService extends CrudService<GroomerExamQuestionsOptionsDao, GroomerExamQuestionsOptions> {

	@Autowired
	private GroomerExamQuestionsOptionsDao groomerExamQuestionsOptionsDao;

	public GroomerExamQuestionsOptions get(String id) {
		return super.get(id);
	}
	
	public List<GroomerExamQuestionsOptions> findList(GroomerExamQuestionsOptions groomerExamQuestionsOptions) {
		return super.findList(groomerExamQuestionsOptions);
	}
	
	public Page<GroomerExamQuestionsOptions> findPage(Page<GroomerExamQuestionsOptions> page, GroomerExamQuestionsOptions groomerExamQuestionsOptions) {
		return super.findPage(page, groomerExamQuestionsOptions);
	}
	
	@Transactional(readOnly = false)
	public void save(GroomerExamQuestionsOptions groomerExamQuestionsOptions) {
		super.save(groomerExamQuestionsOptions);
	}
	
	@Transactional(readOnly = false)
	public void delete(GroomerExamQuestionsOptions groomerExamQuestionsOptions) {
		super.delete(groomerExamQuestionsOptions);
	}

	public List<GroomerExamQuestionsOptions> queryQuestionsOptionsByQuestionIds(List<String> questionIds){
		return groomerExamQuestionsOptionsDao.queryQuestionsOptionsByQuestionIds(questionIds);
	}
	public List<GroomerExamQuestionsOptions> queryQuestionsOptionsByQuestionIdsAndNoDelFlag(List<String> questionIds){
		return groomerExamQuestionsOptionsDao.queryQuestionsOptionsByQuestionIdsAndNoDelFlag(questionIds);
	}
}