package com.cku.oa.groomer.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description: 提交美容考试request
 * @Author: Hujiaxin    //作者
 * @CreateDate: 2023/11/24 16:59	//创建时间
 */
@Data
public class CommitWrittenExamRequest implements Serializable {

    /**
     * 试卷id
     */
    private String examPaperId;

    /**
     * 考试完成时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endExamTime;

    /**
     * 提交考试状态
     */
    private Integer commitExamType;

    /**
     * 最后选中事件
     * @return
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date lastSelectedTime;

    /**
     * 理论答题信息表Id
     */
    private String writtenInfoId;

    /**
     * 答题内容
     */
    List<CommitWrittenExamDetailRequest> commitWrittenExamDetailRequests;
}
