/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.entity;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringEscapeUtils;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

/**
 * 美容师报名表Entity
 * @author cxt
 * @version 2016-07-14
 */
/**
 * @author user
 *
 */
public class GroomerRegister extends DataEntity<GroomerRegister> {

	private static final long serialVersionUID = 1L;
	@ExcelField(title = "id", align = 2, sort = 1)
	private String id;
	@NotBlank
	@ExcelField(title = "赛事编号", align = 2, sort = 9)
	private String showCode; // 赛事编号
	private String registerCode; // 报名序号
	@ExcelField(title = "会员号", align = 2, sort = 2)
	private String memberCode; // 会员号
	@ExcelField(title = "姓名", align = 2, sort = 3)
	private String name; // 姓名
	private String gender; // 性别
	@ExcelField(title = "联系电话", align = 2, sort = 4)
	private String mobile; // 手机
	private String avatar; // 照片
	@ExcelField(title = "参赛级别", align = 2, sort = 60)
	private String showLevel; // 参赛级别

	@ExcelField(title = "培训学校", align = 2, sort = 5)
	private String schoolNameCn; // 培训机构
	private String fee; // 报名费
	private String leaveCancel; // 请假及取消
	private String showLeave; // 赛场请假
	@ExcelField(title = "比赛品种", align = 2, sort = 8)
	private String showDogBreed; // 比赛品种
	private String showDogBreedExtra; // 自定义比赛犬种
	
	private String showDogBreedStr;
	private String orderPrice; // 单价
	private String paymentMemberCode; // 付款会员号
	private String operator; // 操作人员
	@ExcelField(title = "成绩", align = 2, sort = 17)
	private String grade; // 成绩
	private String paymentChargingItemId; // 收费项目
	private String source; // 来源
	private String reviewState; // 审核状态
	private Date reviewTime; // 审核时间
	private String reviewRemarks; // 审核原因
	private String runningNumber; // 流水号
	private String paymentState; // 支付状态
	private Date paymentTime; // 支付时间
	private Date proccessTime; // 处理时间
	private String proccessState; // 处理状态
	@ExcelField(title = "序号", align = 2, sort = 16)
	private String testNo; // 考试号
	@ExcelField(title = "审查员", align = 2, sort = 15)
	private String referee; // 审查员(裁判)
	private Date gradeTime; // 成绩录入时间
	private String teamMemberCode; // 参赛队员
	private TrainingInstitution trainingInstitution; // 美容师合作机构
	private GroomerShow groomerShow; // 美容师活动表
	@ExcelField(title = "参加考试日期", align = 2, sort = 18)
	private Date takeCertificateDate; // 参加考试日期
	@ExcelField(title = "名次", align = 2, sort = 20)
	private String place;// 名次
	private GroomerShowReferee showReferee; // referee
	private Member member;// 会员表
	private String gradeWrite;// 笔试成绩
	private GroomerQualificationCertificate groomerQualificationCertificate;
	private String reviewStateExclud; // 排除的审核状态

	private String memberCodesStr;
	private List<String> memberCodes;
	
	private String groomerShowId;
	private String schoolsId;
	
	private String levelCn;
	private String endFlag;

	/**
	 * 是否有资格考试
	 */
	private Boolean eligibility;

	/**
	 * 考试次数
	 */
	private Integer examNum;

	/**
	 * 美容报名活动流程状态
	 */
	private Integer groomerQualificationStatus;

	/**
	 * 是否为重置状态
	 * @return
	 */
	private Boolean reset;
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((avatar == null) ? 0 : avatar.hashCode());
		result = prime * result + ((beginCreateDate == null) ? 0 : beginCreateDate.hashCode());
		result = prime * result + ((endCreateDate == null) ? 0 : endCreateDate.hashCode());
		result = prime * result + ((fee == null) ? 0 : fee.hashCode());
		result = prime * result + ((gender == null) ? 0 : gender.hashCode());
		result = prime * result + ((grade == null) ? 0 : grade.hashCode());
		result = prime * result + ((gradeTime == null) ? 0 : gradeTime.hashCode());
		result = prime * result + ((gradeWrite == null) ? 0 : gradeWrite.hashCode());
		result = prime * result
				+ ((groomerQualificationCertificate == null) ? 0 : groomerQualificationCertificate.hashCode());
		result = prime * result + ((groomerShow == null) ? 0 : groomerShow.hashCode());
		result = prime * result + ((groomerShowId == null) ? 0 : groomerShowId.hashCode());
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		result = prime * result + ((leaveCancel == null) ? 0 : leaveCancel.hashCode());
		result = prime * result + ((member == null) ? 0 : member.hashCode());
		result = prime * result + ((memberCode == null) ? 0 : memberCode.hashCode());
		result = prime * result + ((memberCodes == null) ? 0 : memberCodes.hashCode());
		result = prime * result + ((memberCodesStr == null) ? 0 : memberCodesStr.hashCode());
		result = prime * result + ((mobile == null) ? 0 : mobile.hashCode());
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		result = prime * result + ((operator == null) ? 0 : operator.hashCode());
		result = prime * result + ((orderPrice == null) ? 0 : orderPrice.hashCode());
		result = prime * result + ((paymentChargingItemId == null) ? 0 : paymentChargingItemId.hashCode());
		result = prime * result + ((paymentMemberCode == null) ? 0 : paymentMemberCode.hashCode());
		result = prime * result + ((paymentState == null) ? 0 : paymentState.hashCode());
		result = prime * result + ((paymentTime == null) ? 0 : paymentTime.hashCode());
		result = prime * result + ((place == null) ? 0 : place.hashCode());
		result = prime * result + ((proccessState == null) ? 0 : proccessState.hashCode());
		result = prime * result + ((proccessTime == null) ? 0 : proccessTime.hashCode());
		result = prime * result + ((referee == null) ? 0 : referee.hashCode());
		result = prime * result + ((registerCode == null) ? 0 : registerCode.hashCode());
		result = prime * result + ((reviewRemarks == null) ? 0 : reviewRemarks.hashCode());
		result = prime * result + ((reviewState == null) ? 0 : reviewState.hashCode());
		result = prime * result + ((reviewStateExclud == null) ? 0 : reviewStateExclud.hashCode());
		result = prime * result + ((reviewTime == null) ? 0 : reviewTime.hashCode());
		result = prime * result + ((runningNumber == null) ? 0 : runningNumber.hashCode());
		result = prime * result + ((schoolNameCn == null) ? 0 : schoolNameCn.hashCode());
		result = prime * result + ((schoolsId == null) ? 0 : schoolsId.hashCode());
		result = prime * result + ((showCategory == null) ? 0 : showCategory.hashCode());
		result = prime * result + ((showCode == null) ? 0 : showCode.hashCode());
		result = prime * result + ((showDogBreed == null) ? 0 : showDogBreed.hashCode());
		result = prime * result + ((showDogBreedExtra == null) ? 0 : showDogBreedExtra.hashCode());
		result = prime * result + ((showDogBreedStr == null) ? 0 : showDogBreedStr.hashCode());
		result = prime * result + ((showLeave == null) ? 0 : showLeave.hashCode());
		result = prime * result + ((showLevel == null) ? 0 : showLevel.hashCode());
		result = prime * result + ((showReferee == null) ? 0 : showReferee.hashCode());
		result = prime * result + ((source == null) ? 0 : source.hashCode());
		result = prime * result + ((takeCertificateDate == null) ? 0 : takeCertificateDate.hashCode());
		result = prime * result + ((teamMemberCode == null) ? 0 : teamMemberCode.hashCode());
		result = prime * result + ((testNo == null) ? 0 : testNo.hashCode());
		result = prime * result + ((trainingInstitution == null) ? 0 : trainingInstitution.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		GroomerRegister other = (GroomerRegister) obj;
		if (avatar == null) {
			if (other.avatar != null)
				return false;
		} else if (!avatar.equals(other.avatar))
			return false;
		if (beginCreateDate == null) {
			if (other.beginCreateDate != null)
				return false;
		} else if (!beginCreateDate.equals(other.beginCreateDate))
			return false;
		if (endCreateDate == null) {
			if (other.endCreateDate != null)
				return false;
		} else if (!endCreateDate.equals(other.endCreateDate))
			return false;
		if (fee == null) {
			if (other.fee != null)
				return false;
		} else if (!fee.equals(other.fee))
			return false;
		if (gender == null) {
			if (other.gender != null)
				return false;
		} else if (!gender.equals(other.gender))
			return false;
		if (grade == null) {
			if (other.grade != null)
				return false;
		} else if (!grade.equals(other.grade))
			return false;
		if (gradeTime == null) {
			if (other.gradeTime != null)
				return false;
		} else if (!gradeTime.equals(other.gradeTime))
			return false;
		if (gradeWrite == null) {
			if (other.gradeWrite != null)
				return false;
		} else if (!gradeWrite.equals(other.gradeWrite))
			return false;
		if (groomerQualificationCertificate == null) {
			if (other.groomerQualificationCertificate != null)
				return false;
		} else if (!groomerQualificationCertificate.equals(other.groomerQualificationCertificate))
			return false;
		if (groomerShow == null) {
			if (other.groomerShow != null)
				return false;
		} else if (!groomerShow.equals(other.groomerShow))
			return false;
		if (groomerShowId == null) {
			if (other.groomerShowId != null)
				return false;
		} else if (!groomerShowId.equals(other.groomerShowId))
			return false;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		if (leaveCancel == null) {
			if (other.leaveCancel != null)
				return false;
		} else if (!leaveCancel.equals(other.leaveCancel))
			return false;
		if (member == null) {
			if (other.member != null)
				return false;
		} else if (!member.equals(other.member))
			return false;
		if (memberCode == null) {
			if (other.memberCode != null)
				return false;
		} else if (!memberCode.equals(other.memberCode))
			return false;
		if (memberCodes == null) {
			if (other.memberCodes != null)
				return false;
		} else if (!memberCodes.equals(other.memberCodes))
			return false;
		if (memberCodesStr == null) {
			if (other.memberCodesStr != null)
				return false;
		} else if (!memberCodesStr.equals(other.memberCodesStr))
			return false;
		if (mobile == null) {
			if (other.mobile != null)
				return false;
		} else if (!mobile.equals(other.mobile))
			return false;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		if (operator == null) {
			if (other.operator != null)
				return false;
		} else if (!operator.equals(other.operator))
			return false;
		if (orderPrice == null) {
			if (other.orderPrice != null)
				return false;
		} else if (!orderPrice.equals(other.orderPrice))
			return false;
		if (paymentChargingItemId == null) {
			if (other.paymentChargingItemId != null)
				return false;
		} else if (!paymentChargingItemId.equals(other.paymentChargingItemId))
			return false;
		if (paymentMemberCode == null) {
			if (other.paymentMemberCode != null)
				return false;
		} else if (!paymentMemberCode.equals(other.paymentMemberCode))
			return false;
		if (paymentState == null) {
			if (other.paymentState != null)
				return false;
		} else if (!paymentState.equals(other.paymentState))
			return false;
		if (paymentTime == null) {
			if (other.paymentTime != null)
				return false;
		} else if (!paymentTime.equals(other.paymentTime))
			return false;
		if (place == null) {
			if (other.place != null)
				return false;
		} else if (!place.equals(other.place))
			return false;
		if (proccessState == null) {
			if (other.proccessState != null)
				return false;
		} else if (!proccessState.equals(other.proccessState))
			return false;
		if (proccessTime == null) {
			if (other.proccessTime != null)
				return false;
		} else if (!proccessTime.equals(other.proccessTime))
			return false;
		if (referee == null) {
			if (other.referee != null)
				return false;
		} else if (!referee.equals(other.referee))
			return false;
		if (registerCode == null) {
			if (other.registerCode != null)
				return false;
		} else if (!registerCode.equals(other.registerCode))
			return false;
		if (reviewRemarks == null) {
			if (other.reviewRemarks != null)
				return false;
		} else if (!reviewRemarks.equals(other.reviewRemarks))
			return false;
		if (reviewState == null) {
			if (other.reviewState != null)
				return false;
		} else if (!reviewState.equals(other.reviewState))
			return false;
		if (reviewStateExclud == null) {
			if (other.reviewStateExclud != null)
				return false;
		} else if (!reviewStateExclud.equals(other.reviewStateExclud))
			return false;
		if (reviewTime == null) {
			if (other.reviewTime != null)
				return false;
		} else if (!reviewTime.equals(other.reviewTime))
			return false;
		if (runningNumber == null) {
			if (other.runningNumber != null)
				return false;
		} else if (!runningNumber.equals(other.runningNumber))
			return false;
		if (schoolNameCn == null) {
			if (other.schoolNameCn != null)
				return false;
		} else if (!schoolNameCn.equals(other.schoolNameCn))
			return false;
		if (schoolsId == null) {
			if (other.schoolsId != null)
				return false;
		} else if (!schoolsId.equals(other.schoolsId))
			return false;
		if (showCategory == null) {
			if (other.showCategory != null)
				return false;
		} else if (!showCategory.equals(other.showCategory))
			return false;
		if (showCode == null) {
			if (other.showCode != null)
				return false;
		} else if (!showCode.equals(other.showCode))
			return false;
		if (showDogBreed == null) {
			if (other.showDogBreed != null)
				return false;
		} else if (!showDogBreed.equals(other.showDogBreed))
			return false;
		if (showDogBreedExtra == null) {
			if (other.showDogBreedExtra != null)
				return false;
		} else if (!showDogBreedExtra.equals(other.showDogBreedExtra))
			return false;
		if (showDogBreedStr == null) {
			if (other.showDogBreedStr != null)
				return false;
		} else if (!showDogBreedStr.equals(other.showDogBreedStr))
			return false;
		if (showLeave == null) {
			if (other.showLeave != null)
				return false;
		} else if (!showLeave.equals(other.showLeave))
			return false;
		if (showLevel == null) {
			if (other.showLevel != null)
				return false;
		} else if (!showLevel.equals(other.showLevel))
			return false;
		if (showReferee == null) {
			if (other.showReferee != null)
				return false;
		} else if (!showReferee.equals(other.showReferee))
			return false;
		if (source == null) {
			if (other.source != null)
				return false;
		} else if (!source.equals(other.source))
			return false;
		if (takeCertificateDate == null) {
			if (other.takeCertificateDate != null)
				return false;
		} else if (!takeCertificateDate.equals(other.takeCertificateDate))
			return false;
		if (teamMemberCode == null) {
			if (other.teamMemberCode != null)
				return false;
		} else if (!teamMemberCode.equals(other.teamMemberCode))
			return false;
		if (testNo == null) {
			if (other.testNo != null)
				return false;
		} else if (!testNo.equals(other.testNo))
			return false;
		if (trainingInstitution == null) {
			if (other.trainingInstitution != null)
				return false;
		} else if (!trainingInstitution.equals(other.trainingInstitution))
			return false;
		return true;
	}
	
	

	public String getLevelCn() {
		return levelCn;
	}

	public void setLevelCn(String levelCn) {
		this.levelCn = levelCn;
	}

	public String getSchoolsId() {
		return schoolsId;
	}

	public void setSchoolsId(String schoolsId) {
		this.schoolsId = schoolsId;
	}

	public String getReviewStateExclud() {
		return reviewStateExclud;
	}

	public void setReviewStateExclud(String reviewStateExclud) {
		this.reviewStateExclud = reviewStateExclud;
	}

	public GroomerShowReferee getShowReferee() {
		return showReferee;
	}

	public void setShowReferee(GroomerShowReferee showReferee) {
		this.showReferee = showReferee;
	}

	public Date getTakeCertificateDate() {
		return takeCertificateDate;
	}

	public void setTakeCertificateDate(Date takeCertificateDate) {
		this.takeCertificateDate = takeCertificateDate;
	}

	public String getId() {
		return super.id;
	}

	public void setId(String id) {
		super.id = id;
	}

	public GroomerRegister() {
		super();
	}

	public GroomerRegister(String id) {
		super(id);
	}

	@Length(min = 1, max = 100, message = "赛事编号长度必须介于 1 和 100 之间")
	public String getShowCode() {
		return showCode;
	}

	public void setShowCode(String showCode) {
		this.showCode = showCode;
	}

	@Length(min = 0, max = 64, message = "报名序号长度必须介于 0 和 64 之间")
	public String getRegisterCode() {
		return registerCode;
	}

	public void setRegisterCode(String registerCode) {
		this.registerCode = registerCode;
	}

	@Length(min = 0, max = 64, message = "会员号长度必须介于 0 和 64 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	public String getAvatar() {
		return avatar;
	}

	public void setAvatar(String avatar) {
		this.avatar = avatar;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	@Length(min = 0, max = 20, message = "赛事级别长度必须介于 0 和 20 之间")
	public String getShowLevel() {
		return showLevel;
	}

	public void setShowLevel(String showLevel) {
		this.showLevel = StringEscapeUtils.unescapeHtml4(showLevel);
	}

	public String getSchoolNameCn() {
		return schoolNameCn;
	}
	//转义乱码
	public void setSchoolNameCn(String schoolNameCn) {
		this.schoolNameCn = StringEscapeUtils.unescapeHtml4(schoolNameCn);
	}

	public String getFee() {
		return fee;
	}

	public void setFee(String fee) {
		this.fee = fee;
	}

	@Length(min = 0, max = 64, message = "请假及取消长度必须介于 0 和 64 之间")
	public String getLeaveCancel() {
		return leaveCancel;
	}

	public void setLeaveCancel(String leaveCancel) {
		this.leaveCancel = leaveCancel;
	}

	@Length(min = 0, max = 64, message = "赛场请假长度必须介于 0 和 64 之间")
	public String getShowLeave() {
		return showLeave;
	}

	public void setShowLeave(String showLeave) {
		this.showLeave = showLeave;
	}

	@Length(min = 0, max = 64, message = "比赛犬种长度必须介于 0 和 64 之间")
	public String getShowDogBreed() {
		return showDogBreed;
	}

	public void setShowDogBreed(String showDogBreed) {
		this.showDogBreed = showDogBreed;
	}

	public String getOrderPrice() {
		return orderPrice;
	}

	public void setOrderPrice(String orderPrice) {
		this.orderPrice = orderPrice;
	}

	@Length(min = 0, max = 64, message = "付款会员号长度必须介于 0 和 64 之间")
	public String getPaymentMemberCode() {
		return paymentMemberCode;
	}

	public void setPaymentMemberCode(String paymentMemberCode) {
		this.paymentMemberCode = paymentMemberCode;
	}

	@Length(min = 0, max = 64, message = "操作人员长度必须介于 0 和 64 之间")
	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	@Length(min = 0, max = 50, message = "成绩长度必须介于 0 和 50 之间")
	public String getGrade() {
		return grade;
	}

	public void setGrade(String grade) {
		this.grade = grade;
	}

	public String getPaymentChargingItemId() {
		return paymentChargingItemId;
	}

	public void setPaymentChargingItemId(String paymentChargingItemId) {
		this.paymentChargingItemId = paymentChargingItemId;
	}

	@Length(min = 0, max = 64, message = "来源长度必须介于 0 和 64 之间")
	public String getSource() {
		return source;
	}

	public void setSource(String source) {
		this.source = source;
	}

	@Length(min = 0, max = 64, message = "审核状态长度必须介于 0 和 64 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}

	@Length(min = 0, max = 64, message = "审核原因长度必须介于 0 和 64 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	@Length(min = 0, max = 64, message = "流水号长度必须介于 0 和 64 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min = 0, max = 64, message = "支付状态长度必须介于 0 和 64 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProccessTime() {
		return proccessTime;
	}

	public void setProccessTime(Date proccessTime) {
		this.proccessTime = proccessTime;
	}

	@Length(min = 0, max = 64, message = "处理状态长度必须介于 0 和 64 之间")
	public String getProccessState() {
		return proccessState;
	}

	public void setProccessState(String proccessState) {
		this.proccessState = proccessState;
	}

	public String getTestNo() {
		return testNo;
	}

	public void setTestNo(String testNo) {
		this.testNo = testNo;
	}

	public String getReferee() {
		return referee;
	}

	public void setReferee(String referee) {
		this.referee = referee;
	}

	public Date getGradeTime() {
		return gradeTime;
	}

	public void setGradeTime(Date gradeTime) {
		this.gradeTime = gradeTime;
	}

	public GroomerShow getGroomerShow() {
		return groomerShow;
	}

	public void setGroomerShow(GroomerShow groomerShow) {
		this.groomerShow = groomerShow;
	}

	public TrainingInstitution getTrainingInstitution() {
		return trainingInstitution;
	}

	public void setTrainingInstitution(TrainingInstitution trainingInstitution) {
		this.trainingInstitution = trainingInstitution;
	}

	public String getDelFlag() {
		return super.delFlag;
	}

	public void setDelFlag(String delFlag) {
		super.delFlag = delFlag;
	}

	public String getTeamMemberCode() {
		return teamMemberCode;
	}

	public void setTeamMemberCode(String teamMemberCode) {
		this.teamMemberCode = teamMemberCode;
	}

	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date beginCreateDate;
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date endCreateDate;

	public Date getBeginCreateDate() {
		return beginCreateDate;
	}

	public void setBeginCreateDate(Date beginCreateDate) {
		this.beginCreateDate = beginCreateDate;
	}

	public Date getEndCreateDate() {
		return endCreateDate;
	}

	public void setEndCreateDate(Date endCreateDate) {
		this.endCreateDate = endCreateDate;
	}

	public Member getMember() {
		return member;
	}

	public void setMember(Member member) {
		this.member = member;
	}

	public String getPlace() {
		return place;
	}

	public void setPlace(String place) {
		this.place = place;
	}

	public String getGradeWrite() {
		return gradeWrite;
	}

	public void setGradeWrite(String gradeWrite) {
		this.gradeWrite = gradeWrite;
	}
	@ExcelField(title = "活动分类", align = 2, sort = 80)
	private String showCategory; // 活动分类

	public String getShowCategory() {
		return showCategory;
	}

	public void setShowCategory(String showCategory) {
		this.showCategory = showCategory;
	}

	public GroomerQualificationCertificate getGroomerQualificationCertificate() {
		return groomerQualificationCertificate;
	}

	public void setGroomerQualificationCertificate(GroomerQualificationCertificate groomerQualificationCertificate) {
		this.groomerQualificationCertificate = groomerQualificationCertificate;
	}

	public List<String> getMemberCodes() {
		return memberCodes;
	}

	public void setMemberCodes(List<String> memberCodes) {
		this.memberCodes = memberCodes;
	}

	public String getGroomerShowId() {
		return groomerShowId;
	}

	public void setGroomerShowId(String groomerShowId) {
		this.groomerShowId = groomerShowId;
	}

	public String getMemberCodesStr() {
		return memberCodesStr;
	}

	public void setMemberCodesStr(String memberCodesStr) {
		this.memberCodesStr = memberCodesStr;
	}

	public String getShowDogBreedStr() {
		return showDogBreedStr;
	}

	public void setShowDogBreedStr(String showDogBreedStr) {
		this.showDogBreedStr = showDogBreedStr;
	}

	public String getShowDogBreedExtra() {
		return showDogBreedExtra;
	}

	public void setShowDogBreedExtra(String showDogBreedExtra) {
		this.showDogBreedExtra = showDogBreedExtra;
	}

	public String getEndFlag() {
		return endFlag;
	}

	public void setEndFlag(String endFlag) {
		this.endFlag = endFlag;
	}
	public Boolean getEligibility() {
		return eligibility;
	}

	public void setEligibility(Boolean eligibility) {
		this.eligibility = eligibility;
	}

	public Integer getExamNum() {
		return examNum;
	}

	public void setExamNum(Integer examNum) {
		this.examNum = examNum;
	}

	public Integer getGroomerQualificationStatus() {
		return groomerQualificationStatus;
	}

	public void setGroomerQualificationStatus(Integer groomerQualificationStatus) {
		this.groomerQualificationStatus = groomerQualificationStatus;
	}

	public Boolean getReset() {
		return reset;
	}

	public void setReset(Boolean reset) {
		this.reset = reset;
	}

}