/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.groomer.entity.GroomerShowReferee;
import com.cku.restful.v1.cab.groomer.model.RestGroomerShowReferee;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 赛事裁判表DAO接口
 * @author lgl
 * @version 2016-07-14
 */
@MyBatisDao
public interface GroomerShowRefereeDao extends CrudDao<GroomerShowReferee> {
	//美容审查员
	public List<GroomerShowReferee> findAllShowReferee();
	//培训审查员
	public List<GroomerShowReferee> findHanlerReferee();
	//查询英文名称
	public String findRefereeNameEn(String nameCn);
	
	/**
	 * 
	 * @Description：根据id串查询id所在的裁判数据
	 * @author: zhuoHeng
	 * @version: 2016年11月23日 下午3:11:08
	 */
	public List<RestGroomerShowReferee> getRefereeList(@Param("ids") String ids);

	public GroomerShowReferee getGroomerShowReferee(@Param("nameEn") String nameEn);

	public GroomerShowReferee getLikeGroomerShowReferee(@Param("referee") String referee);

	public String findHandlerRefereeNameEn(String nameCn);
}